/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.MatrixUtils;
import edu.cmu.tetradapp.editor.CovCellEditor;
import edu.cmu.tetradapp.editor.CovCellRenderer;
import edu.cmu.tetradapp.editor.CovMatrixTable;
import edu.cmu.tetradapp.editor.DataModelContainer;
import edu.cmu.tetradapp.editor.NumberCellEditor;
import edu.cmu.tetradapp.editor.NumberCellRenderer;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class CovMatrixJTable
extends JTable
implements DataModelContainer,
PropertyChangeListener {
    private CovCellRenderer covCellRenderer;
    private CovCellEditor covCellEditor;

    public CovMatrixJTable(CovarianceMatrix covMatrix) {
        if (covMatrix == null) {
            throw new NullPointerException();
        }
        CovMatrixTable dataModel = new CovMatrixTable(covMatrix);
        dataModel.addPropertyChangeListener(this);
        this.setModel(dataModel);
        this.setDefaultEditor(Number.class, new NumberCellEditor());
        this.setDefaultRenderer(Number.class, new NumberCellRenderer());
        this.setAutoResizeMode(0);
        this.covCellEditor = new CovCellEditor();
        this.covCellRenderer = new CovCellRenderer(covMatrix);
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(true);
        this.setTableHeader(null);
        dataModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                CovMatrixJTable.this.firePropertyChange("tableChanged", null, null);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                CovMatrixTable covMatrixTable = (CovMatrixTable)CovMatrixJTable.this.getModel();
                CovarianceMatrix covMatrix = covMatrixTable.getCovMatrix();
                int row = CovMatrixJTable.this.rowAtPoint(e.getPoint());
                int col = CovMatrixJTable.this.columnAtPoint(e.getPoint());
                if (row < 3 || row >= 4 + covMatrix.getDimension() || col >= 1 + covMatrix.getDimension()) {
                    ListSelectionModel rowSelectionModel = CovMatrixJTable.this.getSelectionModel();
                    ListSelectionModel colSelectionModel = CovMatrixJTable.this.getColumnModel().getSelectionModel();
                    rowSelectionModel.clearSelection();
                    colSelectionModel.clearSelection();
                }
                super.mousePressed(e);
            }
        });
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                CovMatrixJTable.this.updateSelection();
            }
        });
        this.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
                CovMatrixJTable.this.updateSelection();
            }
        });
    }

    private void updateSelection() {
        int i;
        ListSelectionModel rowSelectionModel = this.getSelectionModel();
        ListSelectionModel colSelectionModel = this.getColumnModel().getSelectionModel();
        CovMatrixTable covMatrixTable = (CovMatrixTable)this.getModel();
        CovarianceMatrix covMatrix = covMatrixTable.getCovMatrix();
        covMatrix.clearSelection();
        for (i = 0; i < covMatrix.getDimension(); ++i) {
            Node variable = covMatrix.getVariables().get(i);
            if (colSelectionModel.isSelectedIndex(i + 1)) {
                covMatrix.select(variable);
            }
            if (!rowSelectionModel.isSelectedIndex(i + 4)) continue;
            covMatrix.select(variable);
        }
        for (i = -1; i < covMatrix.getDimension(); ++i) {
            for (int j = -1; j < covMatrix.getDimension(); ++j) {
                covMatrixTable.fireTableCellUpdated(i + 4, j + 1);
            }
        }
        this.firePropertyChange("modelChanged", null, null);
    }

    @Override
    public TableCellEditor getCellEditor(int row, int col) {
        CovMatrixTable covMatrixTable = (CovMatrixTable)this.getModel();
        this.covCellEditor.setRed(false);
        if (row >= 4 && col >= 1) {
            List<String> varNames = covMatrixTable.getCovMatrix().getVariableNames();
            List<String> selectedVarNames = covMatrixTable.getCovMatrix().getSelectedVariableNames();
            CovarianceMatrix subMatrix = covMatrixTable.getCovMatrix().getSubmatrix(selectedVarNames);
            if (selectedVarNames.contains(varNames.get(row - 4)) && selectedVarNames.contains(varNames.get(col - 1)) && !MatrixUtils.isPositiveDefinite(subMatrix.getMatrix())) {
                this.covCellEditor.setRed(true);
            }
        }
        return this.covCellEditor;
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int col) {
        CovMatrixTable covMatrixTable = (CovMatrixTable)this.getModel();
        List<String> varNames = covMatrixTable.getCovMatrix().getVariableNames();
        List<String> selectedVarNames = covMatrixTable.getCovMatrix().getSelectedVariableNames();
        CovarianceMatrix subMatrix = covMatrixTable.getCovMatrix().getSubmatrix(selectedVarNames);
        this.covCellEditor.setRed(false);
        this.covCellRenderer.setPositiveDefinite(true);
        if (row >= 4 && row - 4 < varNames.size() && col >= 1 && col - 1 < varNames.size() && selectedVarNames.contains(varNames.get(row - 4)) && selectedVarNames.contains(varNames.get(col - 1)) && !MatrixUtils.isPositiveDefinite(subMatrix.getMatrix())) {
            this.covCellEditor.setRed(true);
            this.covCellRenderer.setPositiveDefinite(false);
        }
        return this.covCellRenderer;
    }

    @Override
    public DataModel getDataModel() {
        CovMatrixTable covMatrixTable = (CovMatrixTable)this.getModel();
        return covMatrixTable.getCovMatrix();
    }

    public boolean isEditingMatrixPositiveDefinite() {
        CovMatrixTable covMatrixTable = (CovMatrixTable)this.getModel();
        return covMatrixTable.isEditingMatrixPositiveDefinite();
    }

    public void restore() {
        CovMatrixTable covMatrixTable = (CovMatrixTable)this.getModel();
        covMatrixTable.restore();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("modelChanged".equals(evt.getPropertyName())) {
            this.firePropertyChange("modelChanged", null, null);
        }
    }
}

