/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import cern.colt.matrix.DoubleMatrix2D;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.CorrelationMatrix;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.MatrixUtils;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import javax.swing.table.AbstractTableModel;

class CovMatrixTable
extends AbstractTableModel {
    private CovarianceMatrix covMatrix;
    private DoubleMatrix2D editingMatrix;
    private boolean editingMatrixPositiveDefinite;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public CovMatrixTable(CovarianceMatrix covMatrix) {
        this.covMatrix = covMatrix;
        this.editingMatrix = covMatrix.getMatrix().copy();
        this.editingMatrixPositiveDefinite = MatrixUtils.isPositiveDefinite(this.editingMatrix);
    }

    @Override
    public int getRowCount() {
        return this.getNumVariables() < 100 ? 100 : this.getNumVariables();
    }

    @Override
    public int getColumnCount() {
        return this.getNumVariables() < 30 ? 30 : this.getNumVariables() + 1;
    }

    @Override
    public Object getValueAt(int row, int col) {
        int firstDataRow = 4;
        int firstDataCol = 1;
        int matrixRow = row - firstDataRow;
        int matrixCol = col - firstDataCol;
        int lastDataRow = firstDataRow + this.getNumVariables();
        int lastDataCol = firstDataCol + this.getNumVariables();
        if (row == 1 && col == 0) {
            return "Sample Size";
        }
        if (row == 1 && col == 1) {
            return this.getSampleSize();
        }
        if (col == firstDataCol - 1 && row >= firstDataRow && row < lastDataRow) {
            return this.getVariableName(matrixRow);
        }
        if (row == firstDataRow - 1 && col >= firstDataCol && col < lastDataCol) {
            return this.getVariableName(matrixCol);
        }
        if (row >= firstDataRow && row < lastDataRow && matrixCol <= matrixRow) {
            return this.getValue(matrixRow, matrixCol);
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        int firstDataRow = 4;
        int firstDataCol = 1;
        int matrixRow = row - firstDataRow;
        int matrixCol = col - firstDataCol;
        int lastDataRow = firstDataRow + this.getNumVariables();
        int lastDataCol = firstDataCol + this.getNumVariables();
        if (row == 1 && col == 1) {
            return true;
        }
        if (col == firstDataCol - 1 && row >= firstDataRow && row < lastDataRow) {
            return true;
        }
        if (row == firstDataRow - 1 && col >= firstDataCol && col < lastDataCol) {
            return true;
        }
        if (row >= firstDataRow && row < lastDataRow && col >= firstDataCol && matrixCol < matrixRow) {
            return true;
        }
        return !(this.covMatrix instanceof CorrelationMatrix) && row >= firstDataRow && row < lastDataRow && col >= firstDataCol && matrixCol == matrixRow;
    }

    @Override
    public void setValueAt(Object aValue, int row, int col) {
        String value;
        int firstDataRow = 4;
        int firstDataCol = 1;
        int matrixRow = row - firstDataRow;
        int matrixCol = col - firstDataCol;
        int lastDataRow = firstDataRow + this.getNumVariables();
        int lastDataCol = firstDataCol + this.getNumVariables();
        if (row == 1 && col == 1) {
            value = (String)aValue;
            this.covMatrix.setSampleSize(Integer.parseInt(value));
            this.pcs.firePropertyChange("modelChanged", null, null);
            this.fireTableDataChanged();
        }
        if (col == firstDataCol - 1 && row >= firstDataRow && row < lastDataRow) {
            this.setVariableName(matrixRow, (String)aValue);
            this.fireTableDataChanged();
        }
        if (row == firstDataRow - 1 && col >= firstDataCol && col < lastDataCol) {
            this.setVariableName(matrixCol, (String)aValue);
            this.fireTableDataChanged();
        }
        if (row >= firstDataRow && row < lastDataRow && col >= firstDataCol && matrixCol <= matrixRow) {
            value = (String)aValue;
            double v = Double.parseDouble(value);
            this.setEditingValue(matrixRow, matrixCol, v);
            this.pcs.firePropertyChange("modelChanged", null, null);
            this.fireTableDataChanged();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    private void setVariableName(int index, String name) {
        List<Node> variables = this.getCovMatrix().getVariables();
        for (int i = 0; i < variables.size(); ++i) {
            ContinuousVariable _variable = (ContinuousVariable)variables.get(i);
            if (!name.equals(_variable.getName())) continue;
            return;
        }
        ContinuousVariable variable = (ContinuousVariable)variables.get(index);
        variable.setName(name);
    }

    private void setEditingValue(int row, int col, double v) {
        if (row == col && v <= 0.0) {
            return;
        }
        this.editingMatrix.set(row, col, v);
        this.editingMatrix.set(col, row, v);
        this.editingMatrixPositiveDefinite = MatrixUtils.isPositiveDefinite(this.editingMatrix);
        if (this.editingMatrixPositiveDefinite) {
            this.getCovMatrix().setMatrix(this.editingMatrix.copy());
        }
    }

    private int getSampleSize() {
        return this.getCovMatrix().getSampleSize();
    }

    private String getVariableName(int matrixRow) {
        return this.getCovMatrix().getVariableName(matrixRow);
    }

    private double getValue(int matrixRow, int matrixCol) {
        return this.editingMatrix.get(matrixRow, matrixCol);
    }

    public CovarianceMatrix getCovMatrix() {
        return this.covMatrix;
    }

    private int getNumVariables() {
        return this.covMatrix.getSize();
    }

    public boolean isEditingMatrixPositiveDefinite() {
        return this.editingMatrixPositiveDefinite;
    }

    public void restore() {
        this.editingMatrix = this.covMatrix.getMatrix();
        this.editingMatrixPositiveDefinite = MatrixUtils.isPositiveDefinite(this.editingMatrix);
        this.pcs.firePropertyChange("modelChanged", null, null);
        this.fireTableDataChanged();
    }
}

