/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.ColtDataSet;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetradapp.editor.DataEditor;
import edu.cmu.tetradapp.editor.EditorWindow;
import edu.cmu.tetradapp.util.DesktopController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

final class CreateTimeSeriesDataAction
extends AbstractAction {
    private DataEditor dataEditor;
    private DataSet dataSet;
    private int numLags = 2;

    public CreateTimeSeriesDataAction(DataEditor editor) {
        super("Time Series Data");
        if (editor == null) {
            throw new NullPointerException();
        }
        this.dataEditor = editor;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DataModel dataModel = this.getDataEditor().getSelectedDataModel();
        if (!(dataModel instanceof DataSet)) {
            JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Must be a tabular data set.");
            return;
        }
        this.dataSet = (DataSet)dataModel;
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(this.getNumLags(), 0, 20, 1);
        JSpinner jSpinner = new JSpinner(spinnerNumberModel);
        jSpinner.setPreferredSize(jSpinner.getPreferredSize());
        spinnerNumberModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SpinnerNumberModel model = (SpinnerNumberModel)e.getSource();
                CreateTimeSeriesDataAction.this.setNumLags(model.getNumber().intValue());
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        Box b = Box.createVerticalBox();
        Box b1 = Box.createHorizontalBox();
        b1.add(new JLabel("Number of time lags: "));
        b1.add(Box.createHorizontalGlue());
        b1.add(Box.createHorizontalStrut(15));
        b1.add(jSpinner);
        b1.setBorder(new EmptyBorder(10, 10, 10, 10));
        b.add(b1);
        panel.add((Component)b, "Center");
        EditorWindow editorWindow = new EditorWindow(panel, "Create time series data", "Save", true, this.dataEditor);
        DesktopController.getInstance().addEditorWindow(editorWindow, JLayeredPane.PALETTE_LAYER);
        editorWindow.setVisible(true);
        editorWindow.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosed(InternalFrameEvent e) {
                EditorWindow window = (EditorWindow)e.getSource();
                if (!window.isCanceled()) {
                    if (CreateTimeSeriesDataAction.this.dataSet.isContinuous()) {
                        CreateTimeSeriesDataAction.this.createContinuousTimeSeriesData();
                    } else if (CreateTimeSeriesDataAction.this.dataSet.isDiscrete()) {
                        CreateTimeSeriesDataAction.this.createDiscreteTimeSeriesData();
                    } else {
                        JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Data set must be either continuous or discrete.");
                    }
                }
            }
        });
    }

    private void createContinuousTimeSeriesData() {
        Node[] dataVars = this.dataSet.getVariables().toArray(new Node[0]);
        int n = dataVars.length;
        int m = this.getNumLags();
        Node[][] laggedVars = new Node[m + 1][n];
        Knowledge knowledge = new Knowledge();
        for (int s = 0; s < m; ++s) {
            for (int j = 0; j < n; ++j) {
                String name1 = dataVars[j].getName();
                String name2 = name1 + "." + (s + 1);
                laggedVars[s][j] = new ContinuousVariable(name2);
                laggedVars[s][j].setCenter(80 * j + 50, 80 * (m - s) + 50);
                knowledge.addToTier(s, laggedVars[s][j].getName());
            }
        }
        LinkedList<Node> variables = new LinkedList<Node>();
        for (int s = 0; s < m; ++s) {
            for (int i = 0; i < n; ++i) {
                double[] rawData = new double[this.dataSet.getNumRows()];
                for (int j = 0; j < this.dataSet.getNumRows(); ++j) {
                    rawData[j] = this.dataSet.getDouble(j, i);
                }
                int size = this.dataSet.getNumRows();
                double[] laggedRaw = new double[size - m + 1];
                System.arraycopy(rawData, s, laggedRaw, 0, size - m + 1);
                variables.add((ContinuousVariable)laggedVars[s][i]);
            }
        }
        ColtDataSet _laggedData = new ColtDataSet(this.dataSet.getNumRows() - m + 1, variables);
        for (int s = 0; s < m; ++s) {
            for (int i = 0; i < n; ++i) {
                double[] rawData = new double[this.dataSet.getNumRows()];
                for (int j = 0; j < this.dataSet.getNumRows(); ++j) {
                    rawData[j] = this.dataSet.getDouble(j, i);
                }
                int size = this.dataSet.getNumRows();
                double[] laggedRaw = new double[size - m + 1];
                System.arraycopy(rawData, s, laggedRaw, 0, size - m + 1);
                int col = _laggedData.getVariables().indexOf(laggedVars[s][i]);
                for (int i1 = 0; i1 < laggedRaw.length; ++i1) {
                    _laggedData.setDouble(i1, col, laggedRaw[i1]);
                }
            }
        }
        knowledge.setDefaultToKnowledgeLayout(true);
        _laggedData.setKnowledge(knowledge);
        DataModelList list = new DataModelList();
        list.add(_laggedData);
        this.getDataEditor().reset(list);
        this.getDataEditor().selectFirstTab();
    }

    private void createDiscreteTimeSeriesData() {
        Node[] dataVars = this.dataSet.getVariables().toArray(new Node[0]);
        int n = dataVars.length;
        int m = this.getNumLags();
        Node[][] laggedVars = new Node[m + 1][n];
        Knowledge knowledge = new Knowledge();
        for (int s = 0; s <= m; ++s) {
            for (int j = 0; j < n; ++j) {
                String name1 = dataVars[j].getName();
                String name2 = name1 + "." + (s + 1);
                laggedVars[s][j] = new DiscreteVariable((DiscreteVariable)dataVars[j]);
                laggedVars[s][j].setName(name2);
                laggedVars[s][j].setCenter(80 * j + 50, 80 * (m - s) + 50);
                knowledge.addToTier(s, laggedVars[s][j].getName());
            }
        }
        LinkedList<Node> variables = new LinkedList<Node>();
        for (int s = 0; s <= m; ++s) {
            for (int i = 0; i < n; ++i) {
                int[] rawData = new int[this.dataSet.getNumRows()];
                for (int j = 0; j < this.dataSet.getNumRows(); ++j) {
                    rawData[j] = this.dataSet.getInt(j, i);
                }
                int size = this.dataSet.getNumRows();
                int[] laggedRaw = new int[size - m + 1];
                System.arraycopy(rawData, m - s, laggedRaw, 0, size - m + 1);
                variables.add(laggedVars[s][i]);
            }
        }
        ColtDataSet _laggedData = new ColtDataSet(this.dataSet.getNumRows() - m + 1, variables);
        for (int s = 0; s <= m; ++s) {
            for (int i = 0; i < n; ++i) {
                int[] rawData = new int[this.dataSet.getNumRows()];
                for (int j = 0; j < this.dataSet.getNumRows(); ++j) {
                    rawData[j] = this.dataSet.getInt(j, i);
                }
                int size = this.dataSet.getNumRows();
                int[] laggedRaw = new int[size - m + 1];
                System.arraycopy(rawData, m - s, laggedRaw, 0, size - m + 1);
                int _col = _laggedData.getColumn(laggedVars[s][i]);
                for (int j = 0; j < this.dataSet.getNumRows(); ++j) {
                    _laggedData.setInt(j, _col, laggedRaw[j]);
                }
            }
        }
        knowledge.setDefaultToKnowledgeLayout(true);
        _laggedData.setKnowledge(knowledge);
        DataModelList list = new DataModelList();
        list.add(_laggedData);
        this.getDataEditor().reset(list);
        this.getDataEditor().selectFirstTab();
    }

    private void setNumLags(int numLags) {
        if (numLags < 2 || numLags > 20) {
            throw new IllegalArgumentException();
        }
        this.numLags = numLags;
    }

    private DataEditor getDataEditor() {
        return this.dataEditor;
    }

    private int getNumLags() {
        return this.numLags;
    }
}

