/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.editor.TabularDataJTable;
import edu.cmu.tetradapp.editor.TabularDataTable;
import java.awt.Component;
import java.text.NumberFormat;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

class DataCellRenderer
extends DefaultTableCellRenderer {
    private NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
    private DataSet dataSet;
    private int numLeadingCols;

    public DataCellRenderer(TabularDataJTable tableTabular, int numLeadingCols) {
        this.dataSet = ((TabularDataTable)tableTabular.getModel()).getDataSet();
        this.numLeadingCols = numLeadingCols;
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof String) {
            this.setText((String)value);
        } else if (value instanceof Integer) {
            this.setText(value.toString());
        } else if (value instanceof Double) {
            double doubleValue = (Double)value;
            this.setText(this.nf.format(doubleValue));
        } else {
            this.setText("");
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
        DefaultTableCellRenderer renderer = (DefaultTableCellRenderer)c;
        if (this.dataSet.getNumColumns() > 0 && col >= this.getNumLeadingCols() && col < this.dataSet.getNumColumns() + this.getNumLeadingCols()) {
            int dataCol = col - this.getNumLeadingCols();
            Node variable = this.dataSet.getVariable(dataCol);
            if (variable instanceof DiscreteVariable) {
                renderer.setHorizontalAlignment(4);
            } else {
                renderer.setHorizontalAlignment(4);
            }
        }
        return renderer;
    }

    private int getNumLeadingCols() {
        return this.numLeadingCols;
    }
}

