/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import cern.jet.random.Normal;
import cern.jet.random.engine.MersenneTwister;
import edu.cmu.tetrad.data.ColtDataSet;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.NumberFormatUtil;
import java.text.NumberFormat;

public class DescriptiveStats {
    public static String generateDescriptiveStats(DataSet dataSet, Node variable) {
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        String result = "Descriptive Statistics for: " + variable.getName() + "\n";
        result = result + "------------------------------------\n\n";
        double[] normalValues = DescriptiveStats.normalParams(dataSet, variable);
        result = result + "Sample Size:\t\t" + dataSet.getNumRows() + "\n";
        result = result + "Mean:\t\t\t" + nf.format(normalValues[0]) + "\nStandard Deviation:\t" + nf.format(normalValues[1]) + "\nVariance:\t\t" + nf.format(normalValues[2]) + "\n";
        result = result + "SE Mean:\t\t" + nf.format(DescriptiveStats.standardErrorMean(normalValues[1], dataSet.getNumRows())) + "\n";
        double[] median = DescriptiveStats.median((ColtDataSet)dataSet, variable);
        result = result + "Median:\t\t\t" + nf.format(median[0]) + "\n";
        result = result + "Minimum Value:\t\t" + nf.format(median[1]) + "\nMaximum Value:\t\t" + nf.format(median[2]);
        return result;
    }

    public static double[] median(ColtDataSet dataSet, Node variable) {
        ColtDataSet dataCopy = new ColtDataSet(dataSet);
        DescriptiveStats.sortVariable(dataCopy, variable);
        double[] result = new double[3];
        int column = dataCopy.getColumn(variable);
        result[1] = dataCopy.getDouble(0, column);
        result[2] = dataCopy.getDouble(dataSet.getNumRows() - 1, column);
        if (dataSet.getNumRows() % 2 == 1) {
            result[0] = dataCopy.getDouble(dataSet.getNumRows() / 2, column);
            return result;
        }
        double firstValue = dataCopy.getDouble(dataSet.getNumRows() / 2, column);
        double secondValue = dataCopy.getDouble(dataSet.getNumRows() / 2 - 1, column);
        result[0] = (firstValue + secondValue) / 2.0;
        return result;
    }

    public static void sortVariable(DataSet dataSet, Node variable) {
        int columnIndex = dataSet.getColumn(variable);
        for (int i = 0; i < dataSet.getNumRows(); ++i) {
            for (int k = i; k < dataSet.getNumRows(); ++k) {
                if (!(dataSet.getDouble(i, columnIndex) > dataSet.getDouble(k, columnIndex))) continue;
                double temp = dataSet.getDouble(i, columnIndex);
                dataSet.setDouble(i, columnIndex, dataSet.getDouble(k, columnIndex));
                dataSet.setDouble(k, columnIndex, temp);
            }
        }
    }

    public static Normal getNormal(DataSet dataSet, Node variable) {
        double[] paramsForNormal = DescriptiveStats.normalParams(dataSet, variable);
        double mean = paramsForNormal[0];
        double sd = paramsForNormal[1];
        return new Normal(mean, sd, new MersenneTwister());
    }

    public static double standardErrorMean(double stdDev, double sampleSize) {
        return stdDev / Math.sqrt(sampleSize);
    }

    public static double[] normalParams(DataSet dataSet, Node variable) {
        int i;
        int columnIndex = dataSet.getColumn(variable);
        double mean = 0.0;
        double sd = 0.0;
        for (i = 0; i < dataSet.getNumRows(); ++i) {
            mean += dataSet.getDouble(i, columnIndex);
        }
        mean /= (double)dataSet.getNumRows();
        for (i = 0; i < dataSet.getNumRows(); ++i) {
            sd += (dataSet.getDouble(i, columnIndex) - mean) * (dataSet.getDouble(i, columnIndex) - mean);
        }
        double[] result = new double[3];
        result[2] = sd /= (double)dataSet.getNumRows() - 1.0;
        sd = Math.sqrt(sd);
        result[0] = mean;
        result[1] = sd;
        return result;
    }
}

