/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetradapp.editor.EditorWindow;
import edu.cmu.tetradapp.util.DesktopController;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class DirectedPathsAction
extends AbstractAction
implements ClipboardOwner {
    private GraphWorkbench workbench;
    private int centerX;
    private int centerY;

    public DirectedPathsAction(GraphWorkbench workbench) {
        super("Directed Paths");
        this.workbench = workbench;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Box b = Box.createVerticalBox();
        Graph graph = this.workbench.getGraph();
        JTextArea textArea = new JTextArea();
        JScrollPane scroll = new JScrollPane(textArea);
        scroll.setPreferredSize(new Dimension(600, 600));
        textArea.append("Directed Paths:");
        for (int i = 0; i < graph.getNodes().size(); ++i) {
            for (int j = 0; j < graph.getNodes().size(); ++j) {
                Node node2;
                Node node1 = graph.getNodes().get(i);
                List<List<Node>> directedPaths = GraphUtils.directedPathsFromTo(graph, node1, node2 = graph.getNodes().get(j));
                if (directedPaths.isEmpty()) continue;
                textArea.append("\n\nFrom " + node1 + " to " + node2 + ":");
                for (int k = 0; k < directedPaths.size(); ++k) {
                    textArea.append("\nPath " + k + ": ");
                    List<Node> trek = directedPaths.get(k);
                    textArea.append(((Object)trek.get(0)).toString());
                    for (int m = 1; m < trek.size(); ++m) {
                        Node n0 = trek.get(m - 1);
                        Node n1 = trek.get(m);
                        Edge edge = graph.getEdge(n0, n1);
                        Endpoint endpoint0 = edge.getProximalEndpoint(n0);
                        Endpoint endpoint1 = edge.getProximalEndpoint(n1);
                        textArea.append(endpoint0 == Endpoint.ARROW ? "<" : "-");
                        textArea.append("-");
                        textArea.append(endpoint1 == Endpoint.ARROW ? ">" : "-");
                        textArea.append(((Object)n1).toString());
                    }
                }
            }
        }
        Box b2 = Box.createHorizontalBox();
        b2.add(scroll);
        textArea.setCaretPosition(0);
        b.add(b2);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add(b);
        EditorWindow window = new EditorWindow(panel, "Directed Paths", "Close", false, this.workbench);
        DesktopController.getInstance().addEditorWindow(window, JLayeredPane.PALETTE_LAYER);
        window.setVisible(true);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

