/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.bayes.Evidence;
import edu.cmu.tetrad.bayes.Proposition;
import edu.cmu.tetrad.graph.Node;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.basic.BasicButtonUI;

class EvidenceEditor
extends JPanel {
    private Evidence evidence;
    private JToggleButton[][] buttons;
    private HashMap<JToggleButton, Integer> buttonsToVariables = new HashMap();
    private HashMap<JToggleButton, Integer> buttonsToCategories = new HashMap();
    private HashMap<JCheckBox, Integer> checkBoxesToVariables = new HashMap();
    private HashMap<Integer, JCheckBox> variablesToCheckboxes = new HashMap();

    public EvidenceEditor(Evidence evidence) {
        if (evidence == null) {
            throw new NullPointerException();
        }
        this.evidence = evidence;
        this.setLayout(new BoxLayout(this, 1));
        Box d = Box.createHorizontalBox();
        d.add(new JLabel("Variable/Categories"));
        d.add(Box.createHorizontalGlue());
        d.add(new JLabel("Manipulated"));
        this.add(d);
        this.buttons = new JToggleButton[evidence.getNumNodes()][];
        for (int i = 0; i < evidence.getNumNodes(); ++i) {
            Box c = Box.createHorizontalBox();
            c.add(new JLabel(evidence.getNode(i).getName() + ":  "){

                @Override
                public Dimension getMaximumSize() {
                    return this.getPreferredSize();
                }
            });
            this.buttons[i] = new JToggleButton[evidence.getNumCategories(i)];
            Node node = evidence.getNode(i);
            for (int j = 0; j < evidence.getNumCategories(i); ++j) {
                String name = evidence.getCategory(node, j);
                JToggleButton button = new JToggleButton(" " + name + " "){

                    @Override
                    public Dimension getMaximumSize() {
                        return this.getPreferredSize();
                    }
                };
                button.setBorder(new CompoundBorder(new LineBorder(Color.DARK_GRAY, 1, true), new EmptyBorder(0, 2, 0, 1)));
                button.setBackground(Color.WHITE);
                button.setUI(new BasicButtonUI());
                button.setFont(new Font("Serif", 1, 12));
                this.buttonsToVariables.put(button, i);
                this.buttonsToCategories.put(button, j);
                this.buttons[i][j] = button;
                button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JToggleButton button = (JToggleButton)e.getSource();
                        int i = (Integer)EvidenceEditor.this.buttonsToVariables.get(button);
                        int j = (Integer)EvidenceEditor.this.buttonsToCategories.get(button);
                        Proposition proposition = EvidenceEditor.this.getEvidence().getProposition();
                        if (proposition.getNumAllowed(i) == EvidenceEditor.this.getEvidence().getNumCategories(i)) {
                            proposition.setCategory(i, j);
                        } else if (proposition.getNumAllowed(i) == 1) {
                            if (proposition.getSingleCategory(i) == j) {
                                proposition.removeCategory(i, j);
                            } else {
                                if ((1 & e.getModifiers()) != 1) {
                                    proposition.setVariable(i, false);
                                }
                                proposition.addCategory(i, j);
                            }
                        } else if (proposition.isAllowed(i, j)) {
                            proposition.removeCategory(i, j);
                        } else {
                            proposition.addCategory(i, j);
                        }
                        if (proposition.getNumAllowed(i) == 0) {
                            proposition.setVariable(i, true);
                        }
                        EvidenceEditor.this.resetSelected(i);
                    }
                });
                c.add(button);
                c.add(Box.createHorizontalStrut(2));
            }
            c.add(Box.createHorizontalGlue());
            JCheckBox checkbox = new JCheckBox(){

                @Override
                public Dimension getMaximumSize() {
                    return this.getPreferredSize();
                }
            };
            checkbox.setSelected(this.getEvidence().isManipulated(i));
            this.checkBoxesToVariables.put(checkbox, i);
            this.variablesToCheckboxes.put(i, checkbox);
            checkbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JCheckBox checkbox = (JCheckBox)e.getSource();
                    boolean selected = checkbox.isSelected();
                    Object o = EvidenceEditor.this.checkBoxesToVariables.get(checkbox);
                    int variable = (Integer)o;
                    if (EvidenceEditor.this.getEvidence().getProposition().getSingleCategory(variable) == -1) {
                        JOptionPane.showMessageDialog(checkbox, "Please choose a single category to manipulate on.");
                        checkbox.setSelected(false);
                        EvidenceEditor.this.getEvidence().setManipulated(variable, false);
                    } else {
                        EvidenceEditor.this.getEvidence().setManipulated(variable, selected);
                    }
                }
            });
            checkbox.setBackground(Color.WHITE);
            checkbox.setBorder(null);
            c.add(checkbox);
            c.setMaximumSize(new Dimension(1000, 30));
            this.add(c);
            this.resetSelected(i);
        }
    }

    private void highlightCorrectly(Proposition proposition) {
        for (JToggleButton _button : this.buttonsToVariables.keySet()) {
            int _i = this.buttonsToVariables.get(_button);
            int _j = this.buttonsToCategories.get(_button);
            if (!proposition.isUnconditioned(_i) && proposition.isAllowed(_i, _j)) {
                _button.setBackground(Color.LIGHT_GRAY);
                continue;
            }
            _button.setBackground(Color.WHITE);
        }
    }

    public Evidence getEvidence() {
        return this.evidence;
    }

    private void resetSelected(int variable) {
        int j;
        if (this.evidence.hasNoEvidence(variable)) {
            for (j = 0; j < this.buttons[variable].length; ++j) {
                this.buttons[variable][j].setSelected(false);
            }
        } else {
            for (j = 0; j < this.buttons[variable].length; ++j) {
                this.buttons[variable][j].setSelected(this.evidence.getProposition().isAllowed(variable, j));
            }
        }
        if (this.evidence.getProposition().getSingleCategory(variable) == -1) {
            JCheckBox checkbox = this.variablesToCheckboxes.get(variable);
            checkbox.setSelected(false);
            this.getEvidence().setManipulated(variable, false);
        }
        this.highlightCorrectly(this.evidence.getProposition());
    }
}

