/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetradapp.model.FciIndTestParams;
import edu.cmu.tetradapp.util.DoubleTextField;
import edu.cmu.tetradapp.util.IntTextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;

class FciIndTestParamsEditor
extends JComponent {
    private FciIndTestParams params = null;
    private DoubleTextField alphaField;
    private IntTextField depthField;
    private JCheckBox completeRuleSetCheckBox;
    private JCheckBox possibleDsepCheckBox;
    private IntTextField maxReachablePathLengthField;

    public FciIndTestParamsEditor(FciIndTestParams params) {
        this.params = params;
        this.alphaField = new DoubleTextField(this.indTestParams().getAlpha(), 8, new DecimalFormat("0.0########"));
        this.alphaField.setFilter(new DoubleTextField.Filter(){

            @Override
            public double filter(double value, double oldValue) {
                try {
                    FciIndTestParamsEditor.this.indTestParams().setAlpha(value);
                    return value;
                }
                catch (IllegalArgumentException e) {
                    return oldValue;
                }
            }
        });
        this.depthField = new IntTextField(this.indTestParams().getDepth(), 5);
        this.depthField.setFilter(new IntTextField.Filter(){

            @Override
            public int filter(int value, int oldValue) {
                try {
                    FciIndTestParamsEditor.this.indTestParams().setDepth(value);
                    return value;
                }
                catch (IllegalArgumentException e) {
                    return oldValue;
                }
            }
        });
        this.completeRuleSetCheckBox = new JCheckBox();
        this.completeRuleSetCheckBox.setSelected(this.indTestParams().isCompleteRuleSetUsed());
        this.completeRuleSetCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox source = (JCheckBox)actionEvent.getSource();
                FciIndTestParamsEditor.this.indTestParams().setCompleteRuleSetUsed(source.isSelected());
            }
        });
        this.possibleDsepCheckBox = new JCheckBox();
        this.possibleDsepCheckBox.setSelected(this.indTestParams().isCompleteRuleSetUsed());
        this.possibleDsepCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox source = (JCheckBox)actionEvent.getSource();
                FciIndTestParamsEditor.this.indTestParams().setCompleteRuleSetUsed(source.isSelected());
            }
        });
        this.possibleDsepCheckBox = new JCheckBox();
        this.possibleDsepCheckBox.setSelected(this.indTestParams().isPossibleDsepDone());
        this.possibleDsepCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox source = (JCheckBox)actionEvent.getSource();
                FciIndTestParamsEditor.this.indTestParams().setPossibleDsepDone(source.isSelected());
            }
        });
        this.maxReachablePathLengthField = new IntTextField(this.indTestParams().getMaxReachablePathLength(), 3);
        this.maxReachablePathLengthField.setFilter(new IntTextField.Filter(){

            @Override
            public int filter(int value, int oldValue) {
                try {
                    FciIndTestParamsEditor.this.indTestParams().setMaxReachablePathLength(value);
                    return value;
                }
                catch (Exception e) {
                    return oldValue;
                }
            }
        });
        this.buildGui();
    }

    private void buildGui() {
        this.setLayout(new BoxLayout(this, 1));
        if (this.alphaField != null) {
            Box b1 = Box.createHorizontalBox();
            b1.add(new JLabel("Alpha:"));
            b1.add(Box.createHorizontalStrut(10));
            b1.add(Box.createHorizontalGlue());
            b1.add(this.alphaField);
            this.add(b1);
        }
        Box b2 = Box.createHorizontalBox();
        b2.add(new JLabel("Depth:"));
        b2.add(Box.createHorizontalStrut(10));
        b2.add(Box.createHorizontalGlue());
        b2.add(this.depthField);
        this.add(b2);
        Box b3 = Box.createHorizontalBox();
        b3.add(new JLabel("Use complete rule set: "));
        b3.add(this.completeRuleSetCheckBox);
        this.add(b3);
        Box b4 = Box.createHorizontalBox();
        b4.add(new JLabel("Do possible DSEP search: "));
        b4.add(this.possibleDsepCheckBox);
        this.add(b4);
        Box b5 = Box.createHorizontalBox();
        b5.add(new JLabel("Max reachable path length: "));
        b5.add(this.maxReachablePathLengthField);
        this.add(b5);
        this.add(Box.createHorizontalGlue());
    }

    private FciIndTestParams indTestParams() {
        return this.params;
    }
}

