/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.sem.GeneralizedSemPm;
import edu.cmu.tetrad.sem.TemplateExpander;
import edu.cmu.tetradapp.model.calculator.parser.ExpressionParser;
import edu.cmu.tetradapp.util.StringTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class GeneralizedTemplateEditor
extends JComponent {
    private Color color = Color.BLACK;
    private int start = 0;
    private int stringWidth = 0;
    private long recolorTime = System.currentTimeMillis();
    private JTextPane expressionTextPane;
    private DefaultStyledDocument expressionTextDoc;
    private GeneralizedSemPm semPm;
    private ExpressionParser latestParser;
    private Box equationsBox = Box.createVerticalBox();
    private JRadioButton variablesCheckBox;
    private JRadioButton errorsCheckBox;
    private JRadioButton parametersCheckBox;
    private StringTextField startsWithField;

    public GeneralizedTemplateEditor(GeneralizedSemPm semPm) {
        ExpressionParser parser;
        if (semPm == null) {
            throw new NullPointerException("SEM PM must be provided.");
        }
        this.semPm = new GeneralizedSemPm(semPm);
        this.equationsBox = Box.createVerticalBox();
        JScrollPane scroll = new JScrollPane(this.equationsBox);
        scroll.setPreferredSize(new Dimension(400, 300));
        StyleContext sc = new StyleContext();
        this.expressionTextDoc = new DefaultStyledDocument(sc);
        this.expressionTextPane = new JTextPane(this.expressionTextDoc);
        this.setParseText(semPm.getVariablesTemplate());
        this.latestParser = parser = new ExpressionParser();
        try {
            String template = this.getSemPm().getVariablesTemplate();
            parser.parseExpression(template);
        }
        catch (ParseException e) {
            throw new RuntimeException("Cannot parse the stored expression.", e);
        }
        final Map<String, String> expressionsMap = this.getExpressionsMap(semPm);
        String[] expressionTokens = this.getExpressionTokens(expressionsMap);
        final JComboBox<String> expressionsBox = new JComboBox<String>(expressionTokens);
        expressionsBox.setMaximumSize(expressionsBox.getPreferredSize());
        JButton insertButton = new JButton("Insert");
        insertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String token = (String)expressionsBox.getSelectedItem();
                String signature = "-New Parameter-".equals(token) ? GeneralizedTemplateEditor.this.nextParameterName("b") : (String)expressionsMap.get(token);
                while (signature.contains("%")) {
                    signature = signature.replaceFirst("%", GeneralizedTemplateEditor.this.nextParameterName("b"));
                }
                GeneralizedTemplateEditor.this.expressionTextPane.replaceSelection(signature);
            }
        });
        this.variablesCheckBox = new JRadioButton("Variables");
        this.errorsCheckBox = new JRadioButton("Errors");
        this.parametersCheckBox = new JRadioButton("Parameters");
        ButtonGroup group = new ButtonGroup();
        group.add(this.variablesCheckBox);
        group.add(this.errorsCheckBox);
        group.add(this.parametersCheckBox);
        this.variablesCheckBox.setSelected(true);
        this.updateEquationsDisplay();
        this.variablesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeneralizedTemplateEditor.this.setParseText(GeneralizedTemplateEditor.this.getSemPm().getVariablesTemplate());
                GeneralizedTemplateEditor.this.updateEquationsDisplay();
            }
        });
        this.errorsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeneralizedTemplateEditor.this.setParseText(GeneralizedTemplateEditor.this.getSemPm().getErrorsTemplate());
                GeneralizedTemplateEditor.this.updateEquationsDisplay();
            }
        });
        this.parametersCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeneralizedTemplateEditor.this.setParseText(GeneralizedTemplateEditor.this.getSemPm().getParametersTemplate());
                GeneralizedTemplateEditor.this.updateEquationsDisplay();
            }
        });
        JButton applyButton = new JButton("APPLY");
        applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeneralizedTemplateEditor.this.applyChanges();
                GeneralizedTemplateEditor.this.updateEquationsDisplay();
            }
        });
        this.startsWithField = new StringTextField("", 6);
        Box b = Box.createVerticalBox();
        Box b4 = Box.createHorizontalBox();
        b4.add(new JLabel("Type Template:"));
        b4.add(Box.createHorizontalGlue());
        b4.add(expressionsBox);
        b4.add(Box.createHorizontalStrut(5));
        b4.add(insertButton);
        b.add(b4);
        b.add(Box.createVerticalStrut(5));
        JScrollPane expressionScroll = new JScrollPane(this.expressionTextPane);
        expressionScroll.setPreferredSize(new Dimension(500, 50));
        Box b5 = Box.createHorizontalBox();
        b5.add(expressionScroll);
        b.add(b5);
        b.add(Box.createVerticalStrut(5));
        JPanel applyToPanel = new JPanel();
        applyToPanel.setLayout(new FlowLayout(0));
        Box b7 = Box.createHorizontalBox();
        b7.add(new JLabel("Apply to: "));
        b7.add(this.variablesCheckBox);
        b7.add(this.errorsCheckBox);
        b7.add(this.parametersCheckBox);
        b7.add(Box.createHorizontalGlue());
        b7.add(new JLabel("Starts with: "));
        b7.add(this.startsWithField);
        b.add(b7);
        b.add(Box.createVerticalStrut(5));
        b.add(new JScrollPane(scroll));
        Box b8 = Box.createHorizontalBox();
        b8.add(Box.createHorizontalGlue());
        b8.add(applyButton);
        b.add(b8);
        b.add(Box.createVerticalStrut(5));
        b.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.add((Component)b, "Center");
        this.expressionTextDoc.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                GeneralizedTemplateEditor.this.listen();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                GeneralizedTemplateEditor.this.listen();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                GeneralizedTemplateEditor.this.listen();
            }
        });
        class ColorThread
        extends Thread {
            private boolean stop = false;

            ColorThread() {
            }

            @Override
            public void run() {
                StyledDocument document = (StyledDocument)GeneralizedTemplateEditor.this.expressionTextPane.getDocument();
                Style red = GeneralizedTemplateEditor.this.expressionTextPane.addStyle("Red", null);
                StyleConstants.setForeground(red, Color.RED);
                Style black = GeneralizedTemplateEditor.this.expressionTextPane.addStyle("Black", null);
                StyleConstants.setForeground(black, Color.BLACK);
                while (!this.stop) {
                    if (System.currentTimeMillis() < GeneralizedTemplateEditor.this.recolorTime) continue;
                    if (GeneralizedTemplateEditor.this.color == Color.RED) {
                        document.setCharacterAttributes(GeneralizedTemplateEditor.this.start, GeneralizedTemplateEditor.this.stringWidth, GeneralizedTemplateEditor.this.expressionTextPane.getStyle("Red"), true);
                    } else if (GeneralizedTemplateEditor.this.color == Color.BLACK) {
                        document.setCharacterAttributes(GeneralizedTemplateEditor.this.start, GeneralizedTemplateEditor.this.stringWidth, GeneralizedTemplateEditor.this.expressionTextPane.getStyle("Black"), true);
                    }
                    try {
                        ColorThread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }

            public void scheduleStop() {
                this.stop = true;
            }
        }
        final ColorThread thread = new ColorThread();
        thread.start();
        this.addComponentListener(new ComponentAdapter(){
            {
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                thread.scheduleStop();
            }
        });
        this.expressionTextPane.setCaretPosition(this.expressionTextPane.getText().length());
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                GeneralizedTemplateEditor.this.listen();
            }

            @Override
            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        });
        this.setFocusCycleRoot(true);
    }

    public void useParametersAsStartup() {
        this.parametersCheckBox.setSelected(true);
    }

    private String[] getExpressionTokens(Map<String, String> expressionsMap) {
        String[] expressionTokens = new String[expressionsMap.keySet().size()];
        int i = -1;
        for (String token : expressionsMap.keySet()) {
            expressionTokens[++i] = token;
        }
        return expressionTokens;
    }

    private Map<String, String> getExpressionsMap(GeneralizedSemPm semPm) {
        int i;
        String[][] templateExpressions = new String[][]{{"NEW", "NEW(b)"}, {"TSUM", "TSUM($)"}, {"TPROD", "TPROD($)"}};
        String[][] expressions = new String[][]{{"+", " + "}, {"-", " - "}, {"*", " * "}, {"/", " / "}, {"^", "^"}, {"pow(a, b)", "pow(%, %)"}, {"sqrt(a)", "sqrt(%)"}, {"sin(a)", "sin(%)"}, {"cos(a)", "cos(%)"}, {"tan(a)", "tan(%)"}, {"asin(a)", "asin(%)"}, {"acos(a)", "acos(%)"}, {"atan(a)", "atan(%)"}, {"sinh(a)", "sinh(%)"}, {"tanh(a)", "tanh(%)"}, {"ln(a)", "ln(%)"}, {"log10(a)", "log10(%)"}, {"round(a)", "round(%)"}, {"ceil(a)", "ceil(%)"}, {"floor(a)", "floor(%)"}, {"abs(a)", "abs(%)"}, {"max(a, b, ...)", "max(%, %)"}, {"min(a, b, ...)", "min(%, %)"}, {"AND(a, b)", "AND(%, %)"}, {"OR(a, b)", "OR(%, %)"}, {"XOR(a, b)", "XOR(%, %)"}, {"IF(a, b, c)", "IF(%, %, %)"}, {"<", " < "}, {"<=", " <= "}, {"=", " = "}, {">=", " >= "}, {">", " > "}, {"Normal(mean, sd)", "Normal(%, %)"}, {"Uniform(mean, sd)", "Uniform(%, %)"}, {"StudentT(df)", "StudentT(%)"}, {"Beta(alpha, beta)", "Beta(%, %)"}, {"Gamma(alpha, lambda)", "Gamma(%, %)"}, {"ChiSquare(df)", "ChiSquare(%)"}, {"Hyperbolic(alpha, beta)", "Hyperbolic(%, %)"}, {"Poisson(lambda)", "Poisson(%)"}, {"ExponentialPower(tau)", "ExponentialPower(%)"}, {"Exponential(lambda)", "Exponential(%)"}, {"VonMises(freedom)", "VonMises(%)"}, {"Split(a1, b1, a2, b2, ...)", "Split(%, %, %, %)"}, {"Discrete(a1, a2, a3, a4, ...)", "Discrete(%, %, %, %)"}, {"Indicator(p)", "Indicator(.5)"}, {"Mixture(a1, dist1, b1, dist2, ...)", "Mixture(%, Normal(%, %), %, Normal(%, %))"}};
        List<Node> nodes = semPm.getNodes();
        LinkedHashMap<String, String> expressionsMap = new LinkedHashMap<String, String>();
        for (i = 0; i < templateExpressions.length; ++i) {
            expressionsMap.put(templateExpressions[i][0], templateExpressions[i][1]);
        }
        for (i = 0; i < nodes.size(); ++i) {
            expressionsMap.put(nodes.get(i).getName(), nodes.get(i).getName());
        }
        for (i = 0; i < expressions.length; ++i) {
            expressionsMap.put(expressions[i][0], expressions[i][1]);
        }
        return expressionsMap;
    }

    public String nextParameterName(String base) {
        Set<String> parameters = this.getSemPm().getParameters();
        parameters.addAll(this.latestParser.getParameters());
        int i = 0;
        block0: while (true) {
            String name = base + ++i;
            for (String parameter : parameters) {
                if (!parameter.equals(name)) continue;
                continue block0;
            }
            break;
        }
        return base + i;
    }

    public GeneralizedSemPm getSemPm() {
        return this.semPm;
    }

    private void setParseText(String text) {
        try {
            this.expressionTextDoc.remove(0, this.expressionTextPane.getText().length());
            this.expressionTextDoc.insertString(0, text, null);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    private void applyChanges() {
        String formula;
        ArrayList<Node> nodes = new ArrayList<Node>();
        ArrayList<String> parameters = new ArrayList<String>();
        String startWith = this.startsWithField.getText();
        if (this.variablesCheckBox.isSelected()) {
            for (Node node : this.getSemPm().getVariableNodes()) {
                formula = "";
                try {
                    formula = TemplateExpander.getInstance().expandTemplate(this.expressionTextPane.getText(), this.getSemPm(), node);
                }
                catch (ParseException e) {
                    continue;
                }
                if (!node.getName().startsWith(startWith)) continue;
                try {
                    this.getSemPm().setNodeExpression(node, formula);
                }
                catch (ParseException e) {
                    continue;
                }
                nodes.add(node);
            }
        }
        if (this.errorsCheckBox.isSelected()) {
            for (Node node : this.getSemPm().getErrorNodes()) {
                formula = "";
                try {
                    formula = TemplateExpander.getInstance().expandTemplate(this.expressionTextPane.getText(), this.getSemPm(), node);
                }
                catch (ParseException e) {
                    continue;
                }
                if (!node.getName().startsWith(startWith)) continue;
                try {
                    this.getSemPm().setNodeExpression(node, formula);
                }
                catch (ParseException e) {
                    continue;
                }
                nodes.add(node);
            }
        }
        if (this.parametersCheckBox.isSelected()) {
            ArrayList<String> _parameters = new ArrayList<String>(this.getSemPm().getParameters());
            Collections.sort(_parameters);
            for (String parameter : _parameters) {
                String formula2 = "";
                try {
                    formula2 = TemplateExpander.getInstance().expandTemplate(this.expressionTextPane.getText(), this.getSemPm(), null);
                }
                catch (ParseException e) {
                    continue;
                }
                if (!parameter.startsWith(startWith)) continue;
                try {
                    this.getSemPm().setParameterExpression(parameter, formula2);
                }
                catch (ParseException e) {
                    continue;
                }
                parameters.add(parameter);
            }
        }
    }

    private void updateEquationsDisplay() {
        JLabel label;
        String symbol;
        Box c;
        this.equationsBox.removeAll();
        if (this.variablesCheckBox.isSelected()) {
            for (Node node : this.getSemPm().getVariableNodes()) {
                c = Box.createHorizontalBox();
                symbol = node.getNodeType() == NodeType.ERROR ? " ~ " : " = ";
                label = new JLabel(node + symbol + this.getSemPm().getNodeExpressionString(node));
                c.add(label);
                c.add(Box.createHorizontalGlue());
                this.equationsBox.add(c);
                this.equationsBox.add(Box.createVerticalStrut(5));
            }
        }
        if (this.errorsCheckBox.isSelected()) {
            for (Node node : this.getSemPm().getErrorNodes()) {
                c = Box.createHorizontalBox();
                symbol = node.getNodeType() == NodeType.ERROR ? " ~ " : " = ";
                label = new JLabel(node + symbol + this.getSemPm().getNodeExpressionString(node));
                c.add(label);
                c.add(Box.createHorizontalGlue());
                this.equationsBox.add(c);
                this.equationsBox.add(Box.createVerticalStrut(5));
            }
        }
        if (this.parametersCheckBox.isSelected()) {
            ArrayList<String> _parameters = new ArrayList<String>(this.getSemPm().getParameters());
            Collections.sort(_parameters);
            for (String parameter : _parameters) {
                Box c2 = Box.createHorizontalBox();
                label = new JLabel(parameter + " ~ " + this.getSemPm().getParameterExpressionString(parameter));
                c2.add(label);
                c2.add(Box.createHorizontalGlue());
                this.equationsBox.add(c2);
                this.equationsBox.add(Box.createVerticalStrut(5));
            }
        }
        this.equationsBox.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.equationsBox.revalidate();
        this.equationsBox.repaint();
    }

    private void listen() {
        String expressionString = this.expressionTextPane.getText();
        ExpressionParser parser = new ExpressionParser();
        try {
            if (!"".equals(expressionString.trim())) {
                parser.parseExpression(expressionString);
            }
            this.color = Color.BLACK;
            this.start = 0;
            this.stringWidth = expressionString.length();
            this.recolorTime = System.currentTimeMillis();
            if (this.variablesCheckBox.isSelected() && !"".equals(expressionString.trim())) {
                this.getSemPm().setVariablesTemplate(expressionString);
            }
            if (this.errorsCheckBox.isSelected() && !"".equals(expressionString.trim())) {
                this.getSemPm().setErrorsTemplate(expressionString);
            }
            if (this.parametersCheckBox.isSelected() && !"".equals(expressionString.trim())) {
                this.getSemPm().setParametersTemplate(expressionString);
            }
        }
        catch (ParseException e) {
            this.color = Color.RED;
            this.start = e.getErrorOffset();
            this.stringWidth = parser.getNextOffset() - e.getErrorOffset();
            this.recolorTime = System.currentTimeMillis();
        }
        this.latestParser = parser;
    }
}

