/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.BayesProperties;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Pattern;
import edu.cmu.tetrad.search.GesOrienter;
import edu.cmu.tetrad.search.ImpliedOrientation;
import edu.cmu.tetrad.search.IndTestType;
import edu.cmu.tetrad.search.PatternToDag;
import edu.cmu.tetrad.search.ScoredGraph;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.sem.SemEstimator;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.editor.AbstractSearchEditor;
import edu.cmu.tetradapp.editor.AllPathsAction;
import edu.cmu.tetradapp.editor.DirectedPathsAction;
import edu.cmu.tetradapp.editor.EditorWindow;
import edu.cmu.tetradapp.editor.GesDisplay;
import edu.cmu.tetradapp.editor.GesIndTestParamsEditor;
import edu.cmu.tetradapp.editor.GraphPropertiesAction;
import edu.cmu.tetradapp.editor.IndTestParamsEditor;
import edu.cmu.tetradapp.editor.IndependenceFactsAction;
import edu.cmu.tetradapp.editor.Indexable;
import edu.cmu.tetradapp.editor.NeighborhoodsAction;
import edu.cmu.tetradapp.editor.PatternDisplay;
import edu.cmu.tetradapp.editor.ScoredGraphsDisplay;
import edu.cmu.tetradapp.editor.SelectBidirectedAction;
import edu.cmu.tetradapp.editor.SelectUndirectedAction;
import edu.cmu.tetradapp.editor.TreksAction;
import edu.cmu.tetradapp.editor.TriplesAction;
import edu.cmu.tetradapp.model.AbstractAlgorithmRunner;
import edu.cmu.tetradapp.model.AlgorithmRunner;
import edu.cmu.tetradapp.model.GesIndTestParams;
import edu.cmu.tetradapp.model.GesRunner;
import edu.cmu.tetradapp.model.IGesRunner;
import edu.cmu.tetradapp.model.ImagesRunner;
import edu.cmu.tetradapp.model.IndTestParams;
import edu.cmu.tetradapp.model.IndTestProducer;
import edu.cmu.tetradapp.model.KnowledgeEditable;
import edu.cmu.tetradapp.model.MeekSearchParams;
import edu.cmu.tetradapp.model.SearchParams;
import edu.cmu.tetradapp.util.DesktopController;
import edu.cmu.tetradapp.util.LayoutEditable;
import edu.cmu.tetradapp.util.LayoutMenu;
import edu.cmu.tetradapp.util.WatchedProcess;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public class GesSearchEditor
extends AbstractSearchEditor
implements KnowledgeEditable,
LayoutEditable,
Indexable {
    private JTextArea modelStatsText;
    private JTabbedPane tabbedPane;
    private boolean alreadyLaidOut = false;
    private GesDisplay gesDisplay;

    public GesSearchEditor(GesRunner runner) {
        super(runner, "Result Pattern");
    }

    public GesSearchEditor(ImagesRunner runner) {
        super(runner, "Result Pattern");
    }

    @Override
    public Graph getGraph() {
        return this.getWorkbench().getGraph();
    }

    @Override
    public void layoutByGraph(Graph graph) {
        this.getWorkbench().layoutByGraph(graph);
    }

    @Override
    public void layoutByKnowledge() {
        GraphWorkbench resultWorkbench = this.getWorkbench();
        Graph graph = resultWorkbench.getGraph();
        Knowledge knowledge = this.getAlgorithmRunner().getParams().getKnowledge();
        SearchGraphUtils.arrangeByKnowledgeTiers(graph, knowledge);
        resultWorkbench.setGraph(graph);
    }

    @Override
    public Rectangle getVisibleRect() {
        return this.getWorkbench().getVisibleRect();
    }

    @Override
    public void setIndex(int index) {
        ((Indexable)((Object)this.getAlgorithmRunner())).setIndex(index);
        this.removeStatsTabs();
        this.firePropertyChange("modelChanged", null, null);
    }

    @Override
    public int getIndex() {
        return ((Indexable)((Object)this.getAlgorithmRunner())).getIndex();
    }

    @Override
    public void execute() {
        Window owner = (Window)this.getTopLevelAncestor();
        final WatchedProcess process = new WatchedProcess(owner){

            @Override
            public void watch() {
                Knowledge knowledge;
                GesSearchEditor.this.getExecuteButton().setEnabled(false);
                this.setErrorMessage(null);
                if (!GesSearchEditor.this.knowledgeMessageShown && !(knowledge = GesSearchEditor.this.getAlgorithmRunner().getParams().getKnowledge()).equals(new Knowledge())) {
                    JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Using previously set knowledge. (To edit, use the Knowledge menu.)");
                    GesSearchEditor.this.knowledgeMessageShown = true;
                }
                try {
                    GesSearchEditor.this.storeLatestWorkbenchGraph();
                    GesSearchEditor.this.getAlgorithmRunner().execute();
                    IGesRunner runner = (IGesRunner)((Object)GesSearchEditor.this.getAlgorithmRunner());
                    GesSearchEditor.this.arrangeGraphs();
                    GesSearchEditor.this.gesDisplay.resetGraphs(runner.getTopGraphs());
                }
                catch (Exception e) {
                    CharArrayWriter writer1 = new CharArrayWriter();
                    PrintWriter writer2 = new PrintWriter(writer1);
                    e.printStackTrace(writer2);
                    String message = writer1.toString();
                    writer2.close();
                    e.printStackTrace(System.out);
                    TetradLogger.getInstance().error(message);
                    String messageString = e.getMessage();
                    if (e.getCause() != null) {
                        messageString = e.getCause().getMessage();
                    }
                    if (messageString == null) {
                        messageString = message;
                    }
                    this.setErrorMessage(messageString);
                    TetradLogger.getInstance().error("************Algorithm stopped!");
                    GesSearchEditor.this.getExecuteButton().setEnabled(true);
                    throw new RuntimeException(e);
                }
                GesSearchEditor.this.getWorkbenchScroll().setBorder(new TitledBorder(GesSearchEditor.this.getResultLabel()));
                Graph resultGraph = GesSearchEditor.this.resultGraph();
                GesSearchEditor.this.doDefaultArrangement(resultGraph);
                GesSearchEditor.this.getWorkbench().setBackground(Color.WHITE);
                GesSearchEditor.this.getWorkbench().setGraph(resultGraph);
                GesSearchEditor.this.getGraphHistory().clear();
                GesSearchEditor.this.getGraphHistory().add(resultGraph);
                GesSearchEditor.this.getWorkbench().repaint();
                GesSearchEditor.this.firePropertyChange("algorithmFinished", null, null);
                GesSearchEditor.this.getExecuteButton().setEnabled(true);
                GesSearchEditor.this.firePropertyChange("modelChanged", null, null);
            }
        };
        Thread watcher = new Thread(){

            @Override
            public void run() {
                try {
                    do {
                        2.sleep(300L);
                    } while (process.isAlive());
                    GesSearchEditor.this.getExecuteButton().setEnabled(true);
                    return;
                }
                catch (InterruptedException e) {
                    GesSearchEditor.this.getExecuteButton().setEnabled(true);
                    return;
                }
            }
        };
        watcher.start();
    }

    @Override
    public List<String> getVarNames() {
        SearchParams params = this.getAlgorithmRunner().getParams();
        return params.getVarNames();
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        this.getAlgorithmRunner().getParams().setKnowledge(knowledge);
    }

    @Override
    public Knowledge getKnowledge() {
        return this.getAlgorithmRunner().getParams().getKnowledge();
    }

    @Override
    protected void doDefaultArrangement(Graph resultGraph) {
        if (this.alreadyLaidOut) {
            GraphUtils.arrangeBySourceGraph(resultGraph, this.getLatestWorkbenchGraph());
        } else if (this.getKnowledge().isDefaultToKnowledgeLayout()) {
            SearchGraphUtils.arrangeByKnowledgeTiers(resultGraph, this.getKnowledge());
            this.alreadyLaidOut = true;
        } else {
            GraphUtils.arrangeBySourceGraph(resultGraph, this.getLatestWorkbenchGraph());
            this.alreadyLaidOut = true;
        }
    }

    @Override
    protected void setup(String resultLabel) {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getToolbar(), "West");
        this.modelStatsText = new JTextArea();
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.add("Pattern", this.gesDisplay());
        this.add((Component)this.tabbedPane, "Center");
        this.add((Component)this.menuBar(), "North");
    }

    @Override
    protected JPanel getToolbar() {
        JPanel toolbar = new JPanel();
        this.getExecuteButton().setText("Execute*");
        this.getExecuteButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GesSearchEditor.this.removeStatsTabs();
                GesSearchEditor.this.execute();
            }
        });
        JButton statsButton = new JButton("Calc Stats");
        statsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window owner = (Window)GesSearchEditor.this.getTopLevelAncestor();
                new WatchedProcess(owner){

                    @Override
                    public void watch() {
                        GesSearchEditor.this.calcStats();
                    }
                };
            }
        });
        Box b1 = Box.createVerticalBox();
        b1.add(this.getParamsPanel());
        b1.add(Box.createVerticalStrut(10));
        Box b2 = Box.createHorizontalBox();
        b2.add(Box.createGlue());
        b2.add(this.getExecuteButton());
        b1.add(b2);
        b1.add(Box.createVerticalStrut(10));
        if (this.getAlgorithmRunner().getDataModel() instanceof DataSet) {
            Box b3 = Box.createHorizontalBox();
            b3.add(Box.createGlue());
            b3.add(statsButton);
            b1.add(b3);
        }
        if (this.getAlgorithmRunner().getParams() instanceof MeekSearchParams) {
            MeekSearchParams params = (MeekSearchParams)this.getAlgorithmRunner().getParams();
            JCheckBox preventCycles = new JCheckBox("Aggressively Prevent Cycles");
            preventCycles.setHorizontalTextPosition(4);
            preventCycles.setSelected(params.isAggressivelyPreventCycles());
            preventCycles.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JCheckBox box = (JCheckBox)e.getSource();
                    MeekSearchParams params = (MeekSearchParams)GesSearchEditor.this.getAlgorithmRunner().getParams();
                    params.setAggressivelyPreventCycles(box.isSelected());
                }
            });
            b1.add(Box.createVerticalStrut(5));
            Box hBox = Box.createHorizontalBox();
            hBox.add(Box.createHorizontalGlue());
            hBox.add(preventCycles);
            b1.add(hBox);
            b1.add(Box.createVerticalStrut(5));
        }
        Box b4 = Box.createHorizontalBox();
        JLabel label = new JLabel("<html>*Please note that some<br>searches may take a<br>long time to complete.</html>");
        label.setHorizontalAlignment(0);
        label.setVerticalAlignment(0);
        label.setBorder(new TitledBorder(""));
        b4.add(label);
        b1.add(Box.createVerticalStrut(10));
        b1.add(b4);
        toolbar.add(b1);
        return toolbar;
    }

    @Override
    protected void doPostExecutionSteps() {
        System.out.println("Post execution.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void addSpecialMenus(JMenuBar menuBar) {
        if (!(this.getAlgorithmRunner() instanceof IGesRunner)) {
            JMenu test = new JMenu("Independence");
            menuBar.add(test);
            DataModel dataModel = this.getAlgorithmRunner().getDataModel();
            if (dataModel == null && this.getAlgorithmRunner().getSourceGraph() != null) {
                this.addGraphTestMenuItems(test);
            } else if (dataModel instanceof DataSet) {
                DataSet _dataSet = (DataSet)dataModel;
                if (_dataSet.isContinuous()) {
                    this.addContinuousTestMenuItems(test);
                } else {
                    if (!_dataSet.isDiscrete()) throw new IllegalArgumentException("Don't have any tests for mixed data sets right now.");
                    this.addDiscreteTestMenuItems(test);
                }
            } else if (dataModel instanceof CovarianceMatrix) {
                this.addCovMatrixTestMenuItems(test);
            }
            test.addSeparator();
            AlgorithmRunner algorithmRunner = this.getAlgorithmRunner();
            if (algorithmRunner instanceof IndTestProducer) {
                IndTestProducer p = (IndTestProducer)((Object)algorithmRunner);
                IndependenceFactsAction action = new IndependenceFactsAction(this, p, "Independence Facts...");
                test.add(action);
            }
        }
        JMenu graph = new JMenu("Graph");
        JMenuItem showDags = new JMenuItem("Show DAGs in Pattern");
        JMenuItem meekOrient = new JMenuItem("Meek Orientation");
        JMenuItem dagInPattern = new JMenuItem("Choose DAG in Pattern");
        JMenuItem gesOrient = new JMenuItem("Global Score-based Reorientation");
        JMenuItem nextGraph = new JMenuItem("Next Graph");
        JMenuItem previousGraph = new JMenuItem("Previous Graph");
        graph.add(new GraphPropertiesAction(this.getWorkbench()));
        graph.add(new DirectedPathsAction(this.getWorkbench()));
        graph.add(new TreksAction(this.getWorkbench()));
        graph.add(new AllPathsAction(this.getWorkbench()));
        graph.add(new NeighborhoodsAction(this.getWorkbench()));
        graph.add(new TriplesAction(this.getWorkbench(), this.getAlgorithmRunner()));
        graph.addSeparator();
        graph.add(meekOrient);
        graph.add(dagInPattern);
        graph.add(gesOrient);
        graph.addSeparator();
        graph.add(previousGraph);
        graph.add(nextGraph);
        graph.addSeparator();
        graph.add(showDags);
        graph.addSeparator();
        graph.add(new JMenuItem(new SelectBidirectedAction(this.getWorkbench())));
        graph.add(new JMenuItem(new SelectUndirectedAction(this.getWorkbench())));
        menuBar.add(graph);
        showDags.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window owner = (Window)GesSearchEditor.this.getTopLevelAncestor();
                new WatchedProcess(owner){

                    @Override
                    public void watch() {
                        AlgorithmRunner runner = GesSearchEditor.this.getAlgorithmRunner();
                        Graph graph = runner.getResultGraph();
                        if (graph == null) {
                            JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "No result gaph.");
                            return;
                        }
                        if (runner instanceof ImagesRunner) {
                            ScoredGraphsDisplay display = new ScoredGraphsDisplay(((ImagesRunner)runner).getDagsToScores());
                            GraphWorkbench workbench = GesSearchEditor.this.getWorkbench();
                            EditorWindow editorWindow = new EditorWindow(display, "Independence Facts", "Close", false, workbench);
                            DesktopController.getInstance().addEditorWindow(editorWindow, JLayeredPane.PALETTE_LAYER);
                            editorWindow.setVisible(true);
                        } else {
                            PatternDisplay display = new PatternDisplay(graph);
                            GraphWorkbench workbench = GesSearchEditor.this.getWorkbench();
                            EditorWindow editorWindow = new EditorWindow(display, "Independence Facts", "Close", false, workbench);
                            DesktopController.getInstance().addEditorWindow(editorWindow, JLayeredPane.PALETTE_LAYER);
                            editorWindow.setVisible(true);
                        }
                    }
                };
            }
        });
        meekOrient.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImpliedOrientation rules = GesSearchEditor.this.getAlgorithmRunner().getMeekRules();
                rules.setKnowledge(GesSearchEditor.this.getAlgorithmRunner().getParams().getKnowledge());
                rules.orientImplied(GesSearchEditor.this.getGraph());
                GesSearchEditor.this.getGraphHistory().add(GesSearchEditor.this.getGraph());
                GesSearchEditor.this.getWorkbench().setGraph(GesSearchEditor.this.getGraph());
                GesSearchEditor.this.firePropertyChange("modelChanged", null, null);
            }
        });
        dagInPattern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EdgeListGraph graph = new EdgeListGraph(GesSearchEditor.this.getGraph());
                for (Edge edge : graph.getEdges()) {
                    if (!Edges.isBidirectedEdge(edge)) continue;
                    graph.removeEdge(edge);
                }
                PatternToDag search = new PatternToDag(new Pattern(graph));
                Graph dag = search.patternToDagMeekRules();
                GesSearchEditor.this.getGraphHistory().add(dag);
                GesSearchEditor.this.getWorkbench().setGraph(dag);
                ((AbstractAlgorithmRunner)GesSearchEditor.this.getAlgorithmRunner()).setResultGraph(dag);
                GesSearchEditor.this.firePropertyChange("modelChanged", null, null);
            }
        });
        gesOrient.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataModel dataModel = GesSearchEditor.this.getAlgorithmRunner().getDataModel();
                GesOrienter rules = dataModel instanceof DataSet ? new GesOrienter((DataSet)dataModel, new Knowledge()) : new GesOrienter((CovarianceMatrix)dataModel);
                rules.setKnowledge(GesSearchEditor.this.getAlgorithmRunner().getParams().getKnowledge());
                rules.orient(GesSearchEditor.this.getGraph());
                GesSearchEditor.this.getGraphHistory().add(GesSearchEditor.this.getGraph());
                GesSearchEditor.this.getWorkbench().setGraph(GesSearchEditor.this.getGraph());
                GesSearchEditor.this.firePropertyChange("modelChanged", null, null);
            }
        });
        nextGraph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Graph next = GesSearchEditor.this.getGraphHistory().next();
                GesSearchEditor.this.getWorkbench().setGraph(next);
                ((AbstractAlgorithmRunner)GesSearchEditor.this.getAlgorithmRunner()).setResultGraph(next);
                GesSearchEditor.this.firePropertyChange("modelChanged", null, null);
            }
        });
        previousGraph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Graph previous = GesSearchEditor.this.getGraphHistory().previous();
                GesSearchEditor.this.getWorkbench().setGraph(previous);
                ((AbstractAlgorithmRunner)GesSearchEditor.this.getAlgorithmRunner()).setResultGraph(previous);
                GesSearchEditor.this.firePropertyChange("modelChanged", null, null);
            }
        });
        menuBar.add(new LayoutMenu(this));
    }

    private GesDisplay gesDisplay() {
        GesDisplay display;
        Graph resultGraph = this.resultGraph();
        List<ScoredGraph> topGraphs = this.arrangeGraphs();
        this.gesDisplay = display = new GesDisplay(topGraphs, this);
        this.getGraphHistory().clear();
        this.getGraphHistory().add(resultGraph);
        this.setWorkbench(display.getWorkbench());
        this.getWorkbench().setAllowDoubleClickActions(false);
        this.getWorkbench().setAllowNodeEdgeSelection(true);
        this.setWorkbenchScroll(new JScrollPane(display));
        this.getWorkbenchScroll().setPreferredSize(new Dimension(450, 450));
        this.getWorkbenchScroll().setBorder(new TitledBorder(""));
        this.getWorkbench().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                GesSearchEditor.this.storeLatestWorkbenchGraph();
            }
        });
        return display;
    }

    private List<ScoredGraph> arrangeGraphs() {
        int i;
        IGesRunner runner = (IGesRunner)((Object)this.getAlgorithmRunner());
        Graph resultGraph = runner.getResultGraph();
        List<ScoredGraph> topGraphs = runner.getTopGraphs();
        if (topGraphs == null) {
            topGraphs = new ArrayList<ScoredGraph>();
        }
        Graph latestWorkbenchGraph = runner.getParams().getSourceGraph();
        Graph sourceGraph = runner.getSourceGraph();
        boolean arrangedAll = false;
        for (i = 0; i < topGraphs.size(); ++i) {
            arrangedAll = GraphUtils.arrangeBySourceGraph(topGraphs.get(i).getGraph(), latestWorkbenchGraph);
        }
        if (!arrangedAll) {
            for (i = 0; i < topGraphs.size(); ++i) {
                arrangedAll = GraphUtils.arrangeBySourceGraph(resultGraph, sourceGraph);
            }
        }
        if (!arrangedAll) {
            for (i = 0; i < topGraphs.size(); ++i) {
                GraphUtils.arrangeInCircle(resultGraph, 200, 200, 150);
            }
        }
        return topGraphs;
    }

    private Graph resultGraph() {
        Graph resultGraph = this.getAlgorithmRunner().getResultGraph();
        if (resultGraph == null) {
            resultGraph = new EdgeListGraph();
        }
        return resultGraph;
    }

    private void calcStats() {
        IGesRunner runner = (IGesRunner)((Object)this.getAlgorithmRunner());
        Graph resultGraph = runner.getTopGraphs().get(runner.getIndex()).getGraph();
        if (this.getAlgorithmRunner().getDataModel() instanceof DataSet) {
            String report;
            List<Edge> allEdges = resultGraph.getEdges();
            for (Edge edge : allEdges) {
                if (edge.getEndpoint1() != Endpoint.ARROW || edge.getEndpoint2() != Endpoint.ARROW) continue;
                resultGraph.setEndpoint(edge.getNode1(), edge.getNode2(), Endpoint.ARROW);
                resultGraph.removeEdge(edge);
            }
            Pattern pattern = new Pattern(resultGraph);
            PatternToDag ptd = new PatternToDag(pattern);
            Graph dag = ptd.patternToDagMeekRules();
            DataSet dataSet = (DataSet)this.getAlgorithmRunner().getDataModel();
            if (dataSet.isContinuous()) {
                report = this.reportIfContinuous(dag, dataSet);
            } else if (dataSet.isDiscrete()) {
                report = this.reportIfDiscrete(dag, dataSet);
            } else {
                throw new IllegalArgumentException("");
            }
            JScrollPane dagWorkbenchScroll = this.dagWorkbenchScroll(dag);
            this.modelStatsText.setLineWrap(true);
            this.modelStatsText.setWrapStyleWord(true);
            this.modelStatsText.setText(report);
            this.removeStatsTabs();
            this.tabbedPane.addTab("DAG in pattern", dagWorkbenchScroll);
            this.tabbedPane.addTab("DAG Model Statistics", this.modelStatsText);
        }
    }

    private String reportIfContinuous(Graph dag, DataSet dataSet) {
        SemPm semPm = new SemPm(dag);
        SemEstimator estimator = new SemEstimator(dataSet, semPm);
        estimator.estimate();
        SemIm semIm = estimator.getEstimatedSem();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(4);
        StringBuilder buf = new StringBuilder();
        buf.append("\nDegrees of Freedom = ").append(semPm.getDof()).append("Chi-Square = ").append(nf.format(semIm.getChiSquare())).append("\nP Value = ").append(nf.format(semIm.getPValue())).append("\nBIC Score = ").append(nf.format(semIm.getBicScore()));
        buf.append("\n\nThe above chi square test assumes that the maximum likelihood function over the measured variables has been maximized. Under that assumption, the null hypothesis for the test is that the population covariance matrix over all of the measured variables is equal to the estimated covariance matrix over all of the measured variables written as a function of the free model parameters--that is, the unfixed parameters for each directed edge (the linear coefficient for that edge), each exogenous variable (the variance for the error term for that variable), and each bidirected edge (the covariance for the exogenous variables it connects).  The model is explained in Bollen, Structural Equations with Latent Variable, 110. ");
        return buf.toString();
    }

    private String reportIfDiscrete(Graph dag, DataSet dataSet) {
        List<Node> vars = dataSet.getVariables();
        HashMap<String, DiscreteVariable> nodesToVars = new HashMap<String, DiscreteVariable>();
        for (int i = 0; i < dataSet.getNumColumns(); ++i) {
            DiscreteVariable var = (DiscreteVariable)vars.get(i);
            String name = var.getName();
            Node node = new GraphNode(name);
            nodesToVars.put(node.getName(), var);
        }
        BayesPm bayesPm = new BayesPm(new Dag(dag));
        List<Node> nodes = bayesPm.getDag().getNodes();
        for (Node node : nodes) {
            Node var = (Node)nodesToVars.get(node.getName());
            if (!(var instanceof DiscreteVariable)) continue;
            DiscreteVariable var2 = (DiscreteVariable)nodesToVars.get(node.getName());
            int numCategories = var2.getNumCategories();
            ArrayList<String> categories = new ArrayList<String>();
            for (int j = 0; j < numCategories; ++j) {
                categories.add(var2.getCategory(j));
            }
            bayesPm.setCategories(node, categories);
        }
        BayesProperties properties = new BayesProperties(dataSet, dag);
        properties.setGraph(dag);
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(4);
        StringBuilder buf = new StringBuilder();
        buf.append("\nP-value = ").append(properties.getLikelihoodRatioP());
        buf.append("\nDf = ").append(properties.getPValueDf());
        buf.append("\nChi square = ").append(nf.format(properties.getPValueChisq()));
        buf.append("\nBIC score = ").append(nf.format(properties.getBic()));
        buf.append("\n\nH0: Completely disconnected graph.");
        return buf.toString();
    }

    private void removeStatsTabs() {
        for (int i = this.tabbedPane.getTabCount() - 1; i >= 0; --i) {
            String name = this.tabbedPane.getTitleAt(i);
            if (name.equals("DAG Model Statistics")) {
                this.tabbedPane.removeTabAt(i);
                continue;
            }
            if (!name.equals("DAG in pattern")) continue;
            this.tabbedPane.removeTabAt(i);
        }
    }

    @Override
    public Graph getSourceGraph() {
        Graph sourceGraph = this.getWorkbench().getGraph();
        if (sourceGraph == null) {
            sourceGraph = this.getAlgorithmRunner().getSourceGraph();
        }
        return sourceGraph;
    }

    private void addGraphTestMenuItems(JMenu test) {
        IndTestType testType = this.getTestType();
        if (testType != IndTestType.D_SEPARATION) {
            this.setTestType(IndTestType.D_SEPARATION);
        }
        ButtonGroup group = new ButtonGroup();
        JCheckBoxMenuItem dsep = new JCheckBoxMenuItem("D-Separation");
        group.add(dsep);
        test.add(dsep);
        dsep.setSelected(true);
        dsep.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GesSearchEditor.this.setTestType(IndTestType.D_SEPARATION);
            }
        });
    }

    private void addContinuousTestMenuItems(JMenu test) {
        IndTestType testType = this.getTestType();
        if (testType != IndTestType.FISHER_Z && testType != IndTestType.FISHER_ZD && testType != IndTestType.FISHER_Z_BOOTSTRAP && testType != IndTestType.CORRELATION_T && testType != IndTestType.LINEAR_REGRESSION) {
            this.setTestType(IndTestType.FISHER_Z);
        }
        ButtonGroup group = new ButtonGroup();
        JCheckBoxMenuItem fishersZ = new JCheckBoxMenuItem("Fisher's Z");
        group.add(fishersZ);
        test.add(fishersZ);
        JCheckBoxMenuItem fishersZD = new JCheckBoxMenuItem("Fisher's Z - Generalized Inverse");
        group.add(fishersZD);
        test.add(fishersZD);
        JCheckBoxMenuItem fishersZBootstrap = new JCheckBoxMenuItem("Fisher's Z - Bootstrap");
        group.add(fishersZBootstrap);
        test.add(fishersZBootstrap);
        JCheckBoxMenuItem tTest = new JCheckBoxMenuItem("Cramer's T");
        group.add(tTest);
        test.add(tTest);
        JCheckBoxMenuItem linRegrTest = new JCheckBoxMenuItem("Linear Regression Test");
        group.add(linRegrTest);
        test.add(linRegrTest);
        testType = this.getTestType();
        if (testType == IndTestType.FISHER_Z) {
            fishersZ.setSelected(true);
        } else if (testType == IndTestType.FISHER_ZD) {
            fishersZD.setSelected(true);
        } else if (testType == IndTestType.FISHER_Z_BOOTSTRAP) {
            fishersZBootstrap.setSelected(true);
        } else if (testType == IndTestType.CORRELATION_T) {
            tTest.setSelected(true);
        } else if (testType == IndTestType.LINEAR_REGRESSION) {
            linRegrTest.setSelected(true);
        }
        fishersZ.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GesSearchEditor.this.setTestType(IndTestType.FISHER_Z);
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Using Fisher's Z.");
            }
        });
        fishersZD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GesSearchEditor.this.setTestType(IndTestType.FISHER_ZD);
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Using Fisher's Z - Generalized Inverse.");
            }
        });
        fishersZBootstrap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GesSearchEditor.this.setTestType(IndTestType.FISHER_Z_BOOTSTRAP);
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Using Fisher's Z - Bootstrap.");
            }
        });
        tTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GesSearchEditor.this.setTestType(IndTestType.CORRELATION_T);
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Using Cramer's T.");
            }
        });
        linRegrTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GesSearchEditor.this.setTestType(IndTestType.LINEAR_REGRESSION);
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Using linear regression test.");
            }
        });
    }

    private void addCovMatrixTestMenuItems(JMenu test) {
        IndTestType testType = this.getTestType();
        if (testType != IndTestType.FISHER_Z && testType != IndTestType.CORRELATION_T) {
            this.setTestType(IndTestType.FISHER_Z);
        }
        ButtonGroup group = new ButtonGroup();
        JCheckBoxMenuItem fishersZ = new JCheckBoxMenuItem("Fisher's Z");
        group.add(fishersZ);
        test.add(fishersZ);
        JCheckBoxMenuItem tTest = new JCheckBoxMenuItem("Cramer's T");
        group.add(tTest);
        test.add(tTest);
        testType = this.getTestType();
        if (testType == IndTestType.FISHER_Z) {
            fishersZ.setSelected(true);
        } else if (testType == IndTestType.CORRELATION_T) {
            tTest.setSelected(true);
        }
        fishersZ.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GesSearchEditor.this.setTestType(IndTestType.FISHER_Z);
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Using Fisher's Z.");
            }
        });
        tTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GesSearchEditor.this.setTestType(IndTestType.CORRELATION_T);
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Using Cramer's T.");
            }
        });
    }

    private void addDiscreteTestMenuItems(JMenu test) {
        IndTestType testType = this.getTestType();
        if (testType != IndTestType.CHI_SQUARE && testType != IndTestType.G_SQUARE) {
            this.setTestType(IndTestType.CHI_SQUARE);
        }
        ButtonGroup group = new ButtonGroup();
        JCheckBoxMenuItem chiSquare = new JCheckBoxMenuItem("Chi Square");
        group.add(chiSquare);
        test.add(chiSquare);
        JCheckBoxMenuItem gSquare = new JCheckBoxMenuItem("G Square");
        group.add(gSquare);
        test.add(gSquare);
        if (this.getTestType() == IndTestType.CHI_SQUARE) {
            chiSquare.setSelected(true);
        } else if (this.getTestType() == IndTestType.G_SQUARE) {
            gSquare.setSelected(true);
        }
        chiSquare.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GesSearchEditor.this.setTestType(IndTestType.CHI_SQUARE);
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Using Chi Square.");
            }
        });
        gSquare.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GesSearchEditor.this.setTestType(IndTestType.G_SQUARE);
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Using G square.");
            }
        });
    }

    private void setTestType(IndTestType testType) {
        this.getAlgorithmRunner().getParams().setIndTestType(testType);
    }

    private IndTestType getTestType() {
        return this.getAlgorithmRunner().getParams().getIndTestType();
    }

    private JPanel getParamsPanel() {
        JPanel paramsPanel = new JPanel();
        Box b2 = Box.createVerticalBox();
        JComponent indTestParamBox = this.getIndTestParamBox();
        if (indTestParamBox != null) {
            b2.add(indTestParamBox);
        }
        paramsPanel.add(b2);
        paramsPanel.setBorder(new TitledBorder("Parameters"));
        return paramsPanel;
    }

    private JComponent getIndTestParamBox() {
        SearchParams params = this.getAlgorithmRunner().getParams();
        IndTestParams indTestParams = params.getIndTestParams();
        return this.getIndTestParamBox(indTestParams);
    }

    private JComponent getIndTestParamBox(IndTestParams indTestParams) {
        if (indTestParams == null) {
            throw new NullPointerException();
        }
        if (indTestParams instanceof GesIndTestParams) {
            if (this.getAlgorithmRunner() instanceof IGesRunner) {
                IGesRunner gesRunner = (IGesRunner)((Object)this.getAlgorithmRunner());
                GesIndTestParams params = (GesIndTestParams)indTestParams;
                DataModel dataModel = gesRunner.getDataModel();
                boolean discreteData = dataModel instanceof DataSet && ((DataSet)dataModel).isDiscrete();
                return new GesIndTestParamsEditor(params, discreteData);
            }
            if (this.getAlgorithmRunner() instanceof ImagesRunner) {
                ImagesRunner gesRunner = (ImagesRunner)this.getAlgorithmRunner();
                GesIndTestParams params = (GesIndTestParams)indTestParams;
                DataSet dataSet = (DataSet)gesRunner.getDataModel();
                boolean discreteData = dataSet.isDiscrete();
                return new GesIndTestParamsEditor(params, discreteData);
            }
        }
        return new IndTestParamsEditor(indTestParams);
    }

    private JScrollPane dagWorkbenchScroll(Graph dag) {
        GraphWorkbench dagWorkbench = new GraphWorkbench(dag);
        dagWorkbench.setAllowDoubleClickActions(false);
        dagWorkbench.setAllowNodeEdgeSelection(true);
        JScrollPane dagWorkbenchScroll = new JScrollPane(dagWorkbench);
        dagWorkbenchScroll.setPreferredSize(new Dimension(450, 450));
        dagWorkbench.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                GesSearchEditor.this.storeLatestWorkbenchGraph();
            }
        });
        return dagWorkbenchScroll;
    }
}

