/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.model.Params;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetradapp.editor.ParameterEditor;
import edu.cmu.tetradapp.model.GraphComparisonParams;
import edu.cmu.tetradapp.model.GraphSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class GraphComparisonParamsEditor
extends JPanel
implements ParameterEditor {
    private GraphComparisonParams params = null;
    private SessionModel model1;
    private SessionModel model2;
    private Object[] parentModels;

    @Override
    public void setParams(Params params) {
        if (params == null) {
            throw new NullPointerException();
        }
        this.params = (GraphComparisonParams)params;
    }

    @Override
    public void setParentModels(Object[] parentModels) {
        this.parentModels = parentModels;
    }

    @Override
    public boolean mustBeShown() {
        return false;
    }

    @Override
    public void setup() {
        LinkedList<Object> graphSources = new LinkedList<Object>();
        for (Object parentModel : this.parentModels) {
            if (!(parentModel instanceof GraphSource)) continue;
            graphSources.add(parentModel);
        }
        if (graphSources.size() != 2) {
            throw new IllegalArgumentException("Expecting exactly two graph sources.");
        }
        this.model1 = (SessionModel)graphSources.get(0);
        this.model2 = (SessionModel)graphSources.get(1);
        this.setLayout(new BorderLayout());
        JRadioButton resetOnExecute = new JRadioButton("Reset");
        JRadioButton dontResetOnExecute = new JRadioButton("Appended to");
        ButtonGroup group1 = new ButtonGroup();
        group1.add(resetOnExecute);
        group1.add(dontResetOnExecute);
        resetOnExecute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphComparisonParamsEditor.this.getParams().setResetTableOnExecute(true);
            }
        });
        dontResetOnExecute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphComparisonParamsEditor.this.getParams().setResetTableOnExecute(false);
            }
        });
        if (this.getParams().isResetTableOnExecute()) {
            resetOnExecute.setSelected(true);
        } else {
            dontResetOnExecute.setSelected(true);
        }
        JRadioButton latents = new JRadioButton("Yes");
        JRadioButton noLatents = new JRadioButton("No");
        ButtonGroup group2 = new ButtonGroup();
        group2.add(latents);
        group2.add(noLatents);
        latents.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphComparisonParamsEditor.this.getParams().setKeepLatents(true);
            }
        });
        latents.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphComparisonParamsEditor.this.getParams().setKeepLatents(false);
            }
        });
        if (this.getParams().isKeepLatents()) {
            latents.setSelected(true);
        } else {
            noLatents.setSelected(true);
        }
        JRadioButton graph1 = new JRadioButton(this.model1.getName());
        JRadioButton graph2 = new JRadioButton(this.model2.getName());
        ButtonGroup group3 = new ButtonGroup();
        group3.add(graph1);
        group3.add(graph2);
        this.getParams().setReferenceGraphName(this.model1.getName());
        this.getParams().setTargetGraphName(this.model2.getName());
        graph1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphComparisonParamsEditor.this.getParams().setReferenceGraphName(GraphComparisonParamsEditor.this.model1.getName());
                GraphComparisonParamsEditor.this.getParams().setTargetGraphName(GraphComparisonParamsEditor.this.model2.getName());
            }
        });
        graph2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphComparisonParamsEditor.this.getParams().setReferenceGraphName(GraphComparisonParamsEditor.this.model2.getName());
                GraphComparisonParamsEditor.this.getParams().setTargetGraphName(GraphComparisonParamsEditor.this.model1.getName());
            }
        });
        if (this.getParams().getReferenceGraphName() == null) {
            this.getParams().setReferenceGraphName(this.model1.getName());
            graph1.setSelected(true);
        } else if (this.getParams().getReferenceGraphName().equals(this.model1.getName())) {
            graph1.setSelected(true);
        } else if (this.getParams().getReferenceGraphName().equals(this.model2.getName())) {
            graph2.setSelected(true);
        }
        Box b1 = Box.createVerticalBox();
        Box b2 = Box.createHorizontalBox();
        b2.add(new JLabel("Should the counts table be reset or appended to with each simulation?"));
        b2.add(Box.createHorizontalGlue());
        b1.add(b2);
        b1.add(Box.createVerticalStrut(5));
        Box b3 = Box.createHorizontalBox();
        b3.add(resetOnExecute);
        b3.add(Box.createHorizontalGlue());
        b1.add(b3);
        Box b4 = Box.createHorizontalBox();
        b4.add(dontResetOnExecute);
        b4.add(Box.createHorizontalGlue());
        b1.add(b4);
        b1.add(Box.createVerticalStrut(20));
        Box b5 = Box.createHorizontalBox();
        b5.add(new JLabel("Will the results graph contain latents? (Requires a different algorithm.)"));
        b5.add(Box.createHorizontalGlue());
        b1.add(b5);
        Box b6 = Box.createHorizontalBox();
        b6.add(latents);
        b6.add(Box.createHorizontalGlue());
        b1.add(b6);
        Box b7 = Box.createHorizontalBox();
        b7.add(noLatents);
        b7.add(Box.createHorizontalGlue());
        b1.add(b7);
        b1.add(Box.createVerticalStrut(20));
        Box b8 = Box.createHorizontalBox();
        b8.add(new JLabel("Which of the two input graphs is the true graph?"));
        b8.add(Box.createHorizontalGlue());
        b1.add(b8);
        Box b9 = Box.createHorizontalBox();
        b9.add(graph1);
        b9.add(Box.createHorizontalGlue());
        b1.add(b9);
        Box b10 = Box.createHorizontalBox();
        b10.add(graph2);
        b10.add(Box.createHorizontalGlue());
        b1.add(b10);
        b1.add(Box.createHorizontalGlue());
        this.add((Component)b1, "Center");
    }

    private synchronized GraphComparisonParams getParams() {
        return this.params;
    }
}

