/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.model.Params;
import edu.cmu.tetradapp.editor.ParameterEditor;
import edu.cmu.tetradapp.editor.RandomGraphEditor;
import edu.cmu.tetradapp.model.CyclicGraphParams;
import edu.cmu.tetradapp.model.GraphParams;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class GraphParamsEditor
extends JPanel
implements ParameterEditor {
    private GraphParams params = new GraphParams();

    @Override
    public void setParams(Params params) {
        if (params == null) {
            throw new NullPointerException();
        }
        this.params = (GraphParams)params;
    }

    @Override
    public void setParentModels(Object[] parentModels) {
    }

    @Override
    public void setup() {
        boolean cyclicAllowed = this.params instanceof CyclicGraphParams;
        final RandomGraphEditor randomDagEditor = new RandomGraphEditor(cyclicAllowed);
        this.setLayout(new BorderLayout());
        JRadioButton manual = new JRadioButton("An empty graph (to be constructed manually).");
        JRadioButton random = new JRadioButton("A random DAG.");
        ButtonGroup group = new ButtonGroup();
        group.add(manual);
        group.add(random);
        if (Preferences.userRoot().getInt("newGraphInitializationMode", 0) == 0) {
            manual.setSelected(true);
            randomDagEditor.setEnabled(false);
        } else {
            random.setSelected(true);
            randomDagEditor.setEnabled(true);
        }
        manual.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.userRoot().putInt("newGraphInitializationMode", 0);
                randomDagEditor.setEnabled(false);
            }
        });
        random.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.userRoot().putInt("newGraphInitializationMode", 1);
                randomDagEditor.setEnabled(true);
            }
        });
        Box b1 = Box.createVerticalBox();
        Box b2 = Box.createVerticalBox();
        Box b3 = Box.createHorizontalBox();
        b3.add(new JLabel("Make new graph:"));
        b3.add(Box.createHorizontalGlue());
        b2.add(b3);
        b1.add(Box.createVerticalStrut(5));
        Box b4 = Box.createHorizontalBox();
        b4.add(manual);
        b4.add(Box.createHorizontalGlue());
        b2.add(b4);
        Box b5 = Box.createHorizontalBox();
        b5.add(random);
        b5.add(Box.createHorizontalGlue());
        b2.add(b5);
        b2.setBorder(new TitledBorder(""));
        b1.add(b2);
        b1.add(Box.createVerticalStrut(5));
        Box b6 = Box.createHorizontalBox();
        b6.add(randomDagEditor);
        b6.add(Box.createHorizontalGlue());
        b1.add(b6);
        b1.add(Box.createHorizontalGlue());
        this.add((Component)b1, "Center");
    }

    @Override
    public boolean mustBeShown() {
        return false;
    }

    private synchronized GraphParams getParams() {
        return this.params;
    }
}

