/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetradapp.editor.EditorWindow;
import edu.cmu.tetradapp.util.DesktopController;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class GraphPropertiesAction
extends AbstractAction
implements ClipboardOwner {
    private GraphWorkbench workbench;

    public GraphPropertiesAction(GraphWorkbench workbench) {
        super("Graph Properties");
        this.workbench = workbench;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Box b = Box.createVerticalBox();
        Graph graph = this.workbench.getGraph();
        int numLatents = 0;
        for (Node node : graph.getNodes()) {
            if (node.getNodeType() != NodeType.LATENT) continue;
            ++numLatents;
        }
        int maxIndegree = 0;
        for (Node node : graph.getNodes()) {
            int indegree = graph.getNodesInTo(node, Endpoint.ARROW).size();
            if (indegree <= maxIndegree) continue;
            maxIndegree = indegree;
        }
        int maxOutdegree = 0;
        for (Node node : graph.getNodes()) {
            int outdegree = graph.getNodesOutTo(node, Endpoint.ARROW).size();
            if (outdegree <= maxOutdegree) continue;
            maxOutdegree = outdegree;
        }
        int numDirectedEdges = 0;
        int numBidirectedEdges = 0;
        int numUndirectedEdges = 0;
        for (Edge edge : graph.getEdges()) {
            if (Edges.isDirectedEdge(edge)) {
                ++numDirectedEdges;
                continue;
            }
            if (Edges.isBidirectedEdge(edge)) {
                ++numBidirectedEdges;
                continue;
            }
            if (!Edges.isUndirectedEdge(edge)) continue;
            ++numUndirectedEdges;
        }
        boolean cyclic = graph.existsDirectedCycle();
        List<Node> cycle = GraphUtils.directedCycle(graph);
        JTextArea textArea = new JTextArea();
        JScrollPane scroll = new JScrollPane(textArea);
        scroll.setPreferredSize(new Dimension(300, 300));
        textArea.append("\nNumber of nodes: " + String.valueOf(graph.getNumNodes()));
        textArea.append("\nNumber of latents: " + String.valueOf(numLatents));
        textArea.append("\nNumber of edges: " + String.valueOf(graph.getNumEdges()));
        textArea.append("\nNumber of directed edges: " + String.valueOf(numDirectedEdges));
        textArea.append("\nNumber of bidirected edges: " + String.valueOf(numBidirectedEdges));
        textArea.append("\nNumber of undirected edges: " + String.valueOf(numUndirectedEdges));
        textArea.append("\nMax degree: " + String.valueOf(graph.getConnectivity()));
        textArea.append("\nMax indegree: " + String.valueOf(maxIndegree));
        textArea.append("\nMax outdegree: " + String.valueOf(maxOutdegree));
        textArea.append("\nNumber of latents: " + String.valueOf(numLatents));
        textArea.append("\n" + (cyclic ? "Cyclic" : "Acyclic"));
        if (cyclic) {
            textArea.append("Example cycle: " + cycle.toString());
        }
        Box b2 = Box.createHorizontalBox();
        b2.add(scroll);
        textArea.setCaretPosition(0);
        b.add(b2);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add(b);
        EditorWindow window = new EditorWindow(panel, "Graph Properties", "Close", false, this.workbench);
        DesktopController.getInstance().addEditorWindow(window, JLayeredPane.PALETTE_LAYER);
        window.setVisible(true);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

