/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.sem.ISemIm;
import edu.cmu.tetradapp.editor.ImpliedCovTable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableModel;

class ImpliedMatricesPanel
extends JPanel {
    private ISemIm semIm;
    private JTable impliedJTable;
    private int matrixSelection = 0;
    private JComboBox selector;

    public ImpliedMatricesPanel(ISemIm semIm, int matrixSelection) {
        this.semIm = semIm;
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.selector());
        this.add(Box.createVerticalStrut(10));
        this.add(new JScrollPane(this.impliedJTable()));
        this.add(Box.createVerticalGlue());
        this.setBorder(new TitledBorder("Select Implied Matrix to View"));
        this.setMatrixSelection(matrixSelection);
    }

    public String getMatrixInTabDelimitedForm() {
        StringBuilder builder = new StringBuilder();
        TableModel model = this.impliedJTable().getModel();
        for (int row = 0; row < model.getRowCount(); ++row) {
            for (int col = 0; col < model.getColumnCount(); ++col) {
                Object o = model.getValueAt(row, col);
                if (o != null) {
                    builder.append(o);
                }
                builder.append('\t');
            }
            builder.append('\n');
        }
        return builder.toString();
    }

    private JTable impliedJTable() {
        if (this.impliedJTable == null) {
            this.impliedJTable = new JTable();
            this.impliedJTable.setTableHeader(null);
        }
        return this.impliedJTable;
    }

    private JComboBox selector() {
        if (this.selector == null) {
            this.selector = new JComboBox();
            List<String> selections = ImpliedMatricesPanel.getImpliedSelections();
            for (String selection : selections) {
                this.selector.addItem(selection);
            }
            this.selector.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    String item = (String)e.getItem();
                    ImpliedMatricesPanel.this.setMatrixSelection(ImpliedMatricesPanel.getImpliedSelections().indexOf(item));
                }
            });
        }
        return this.selector;
    }

    public void setMatrixSelection(int index) {
        this.selector().setSelectedIndex(index);
        this.switchView(index);
    }

    private void switchView(int index) {
        if (index < 0 || index > 3) {
            throw new IllegalArgumentException("Matrix selection must be 0, 1, 2, or 3.");
        }
        this.matrixSelection = index;
        switch (index) {
            case 0: {
                this.switchView(false, false);
                break;
            }
            case 1: {
                this.switchView(true, false);
                break;
            }
            case 2: {
                this.switchView(false, true);
                break;
            }
            case 3: {
                this.switchView(true, true);
            }
        }
    }

    private void switchView(boolean a, boolean b) {
        this.impliedJTable().setModel(new ImpliedCovTable(this.getSemIm(), a, b));
        this.impliedJTable().setAutoResizeMode(0);
        this.impliedJTable().setRowSelectionAllowed(false);
        this.impliedJTable().setCellSelectionEnabled(false);
        this.impliedJTable().doLayout();
    }

    private static List<String> getImpliedSelections() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Implied covariance matrix (all variables)");
        list.add("Implied covariance matrix (measured variables only)");
        list.add("Implied correlation matrix (all variables)");
        list.add("Implied correlation matrix (measured variables only)");
        return list;
    }

    private ISemIm getSemIm() {
        return this.semIm;
    }

    public int getMatrixSelection() {
        return this.matrixSelection;
    }
}

