/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetradapp.editor.GraphEditable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;

public class LoadGraph
extends AbstractAction {
    private GraphEditable graphEditable;

    public LoadGraph(GraphEditable graphEditable, String title) {
        super(title);
        if (graphEditable == null) {
            throw new NullPointerException("Component must not be null.");
        }
        this.graphEditable = graphEditable;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = LoadGraph.getJFileChooser();
        chooser.setFileSelectionMode(2);
        chooser.showOpenDialog((Component)((Object)this.graphEditable));
        File file = chooser.getSelectedFile();
        if (file == null) {
            return;
        }
        Preferences.userRoot().put("fileSaveLocation", file.getParent());
        Graph graph = GraphUtils.loadGraph(file);
        GraphUtils.arrangeInCircle(graph, 200, 200, 150);
        this.graphEditable.setGraph(graph);
    }

    private static JFileChooser getJFileChooser() {
        JFileChooser chooser = new JFileChooser();
        String sessionSaveLocation = Preferences.userRoot().get("fileSaveLocation", "");
        chooser.setCurrentDirectory(new File(sessionSaveLocation));
        chooser.resetChoosableFileFilters();
        chooser.setFileSelectionMode(2);
        return chooser;
    }

    private GraphEditable getGraphEditable() {
        return this.graphEditable;
    }
}

