/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.DataReader;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetradapp.editor.KnowledgeLoaderWizard;
import edu.cmu.tetradapp.model.KnowledgeEditable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

final class LoadKnowledgeAction
extends AbstractAction {
    private KnowledgeEditable knowledgeEditable;
    private String commentIndicator = "//";
    private String delimiters = "\t";

    public LoadKnowledgeAction(KnowledgeEditable knowledgeEditable) {
        super("Load Knowledge...");
        if (knowledgeEditable == null) {
            throw new NullPointerException();
        }
        this.knowledgeEditable = knowledgeEditable;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int ret = 1;
        while (ret == 1) {
            JFileChooser chooser = LoadKnowledgeAction.getJFileChooser();
            chooser.setFileSelectionMode(2);
            Component comp = this.knowledgeEditable instanceof Component ? (Component)((Object)this.knowledgeEditable) : null;
            chooser.showOpenDialog(comp);
            File file = chooser.getSelectedFile();
            if (file != null) {
                Preferences.userRoot().put("fileSaveLocation", file.getParent());
            }
            KnowledgeLoaderWizard wizard = new KnowledgeLoaderWizard(file, this.knowledgeEditable);
            wizard.setCommentIndicator(this.commentIndicator);
            ret = JOptionPane.showOptionDialog(null, wizard, "Knowledge Import Wizard", 2, -1, null, new String[]{"Cancel", "Select Another File", "Import Data"}, "Import Data");
            this.delimiters = wizard.getDelimiters();
            this.commentIndicator = wizard.getCommentIndicator();
            if (ret != 0) continue;
            try {
                DataReader reader = new DataReader();
                Knowledge knowledge = reader.parseKnowledge(file);
                this.knowledgeEditable.setKnowledge(knowledge);
            }
            catch (Exception e1) {
                String message;
                String string = message = e1.getMessage() == null ? e1.getClass().getName() : e1.getMessage();
                if ("".equals(message)) {
                    message = "Could not load knowledge.";
                }
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), message);
            }
        }
    }

    private static JFileChooser getJFileChooser() {
        JFileChooser chooser = new JFileChooser();
        String sessionSaveLocation = Preferences.userRoot().get("fileSaveLocation", Preferences.userRoot().absolutePath());
        chooser.setCurrentDirectory(new File(sessionSaveLocation));
        chooser.resetChoosableFileFilters();
        chooser.setFileSelectionMode(2);
        return chooser;
    }

    public String getDelimiters() {
        return this.delimiters;
    }
}

