/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.ColtDataSet;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.TimeSeriesData;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetradapp.editor.DataEditor;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;

class LoadTimeSeriesDataAction
extends AbstractAction {
    private DataEditor editor;

    public LoadTimeSeriesDataAction(DataEditor editor) {
        super("Load Time Series Data");
        if (editor == null) {
            throw new NullPointerException("Data Editor must not be null.");
        }
        this.editor = editor;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.loadTimeSeriesDataSet();
    }

    private void loadTimeSeriesDataSet() {
        JFileChooser chooser = this.getJFileChooser();
        chooser.setFileSelectionMode(2);
        chooser.showOpenDialog(this.editor);
        File file = chooser.getSelectedFile();
        Preferences.userRoot().put("fileSaveLocation", file.getParent());
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(file));
            LinkedList<Node> variables = new LinkedList<Node>();
            StringTokenizer st = new StringTokenizer(in.readLine());
            while (st.hasMoreTokens()) {
                String name = st.nextToken();
                ContinuousVariable var = new ContinuousVariable(name);
                variables.add(var);
            }
            ColtDataSet dataSet = new ColtDataSet(0, variables);
            int row = -1;
            while ((line = in.readLine()) != null) {
                int col = -1;
                st = new StringTokenizer(line);
                while (st.hasMoreTokens()) {
                    String literal = st.nextToken();
                    if (literal.length() == 0) continue;
                    dataSet.setObject(row, ++col, literal);
                }
            }
            TimeSeriesData dataSet3 = new TimeSeriesData(dataSet.getDoubleData(), dataSet.getVariableNames());
            this.editor.getDataWrapper().setDataModel(dataSet3);
            this.firePropertyChange("modelChanged", null, null);
            this.editor.reset();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private JFileChooser getJFileChooser() {
        JFileChooser chooser = new JFileChooser();
        String sessionSaveLocation = Preferences.userRoot().get("fileSaveLocation", Preferences.userRoot().absolutePath());
        chooser.setCurrentDirectory(new File(sessionSaveLocation));
        chooser.resetChoosableFileFilters();
        chooser.setFileSelectionMode(2);
        return chooser;
    }
}

