/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.regression.LogisticRegressionResult;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.editor.RegressionParamsEditorPanel;
import edu.cmu.tetradapp.model.LogisticRegressionParams;
import edu.cmu.tetradapp.model.LogisticRegressionRunner;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

public class LogisticRegressionEditor
extends JPanel {
    private JTextArea modelParameters;
    private NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();

    public LogisticRegressionEditor(LogisticRegressionRunner regressionRunner) {
        final LogisticRegressionRunner regRunner = regressionRunner;
        final GraphWorkbench workbench = new GraphWorkbench();
        this.modelParameters = new JTextArea();
        JButton executeButton = new JButton("Execute");
        executeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                regRunner.execute();
                LogisticRegressionEditor.this.print(regRunner.getResult(), regRunner.getAlpha());
                Graph outGraph = regRunner.getOutGraph();
                GraphUtils.arrangeInCircle(outGraph, 200, 200, 150);
                GraphUtils.fruchtermanReingoldLayout(outGraph);
                workbench.setGraph(outGraph);
                TetradLogger.getInstance().log("result", LogisticRegressionEditor.this.modelParameters.getText());
            }
        });
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setPreferredSize(new Dimension(600, 400));
        tabbedPane.add("Model", new JScrollPane(this.modelParameters));
        tabbedPane.add("Output Graph", new JScrollPane(workbench));
        LogisticRegressionParams params = (LogisticRegressionParams)regRunner.getParams();
        RegressionParamsEditorPanel paramsPanel = new RegressionParamsEditorPanel(params, regRunner.getDataModel());
        Box b = Box.createVerticalBox();
        Box b1 = Box.createHorizontalBox();
        b1.add(paramsPanel);
        b1.add(Box.createHorizontalStrut(5));
        b1.add(tabbedPane);
        b.add(b1);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(executeButton);
        b.add(buttonPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)b, "Center");
    }

    @Override
    public void setName(String name) {
        String oldName = this.getName();
        super.setName(name);
        this.firePropertyChange("name", oldName, this.getName());
    }

    private void print(LogisticRegressionResult result, double alpha) {
        int i;
        if (result == null) {
            return;
        }
        String text = result.getNy0() + " cases have " + result.getTarget() + " = 0; ";
        text = text + result.getNy1() + " cases have " + result.getTarget() + " = 1.\n\n";
        text = text + "Var\tAvg\tSD\n";
        for (i = 1; i <= result.getNumRegressors(); ++i) {
            text = text + result.getVariableNames()[i - 1] + "\t";
            text = text + this.nf.format(result.getxMeans()[i]) + "\t";
            text = text + this.nf.format(result.getxStdDevs()[i]) + "\n";
        }
        text = text + "\nCoefficients and Standard Errors:\n";
        text = text + "Var\tCoeff.\tStdErr\tProb.\tSig.\n";
        for (i = 1; i <= result.getNumRegressors(); ++i) {
            text = text + result.getVariableNames()[i - 1] + "\t";
            text = text + this.nf.format(result.getCoefs()[i]) + "\t";
            text = text + this.nf.format(result.getStdErrs()[i]) + "\t";
            text = text + this.nf.format(result.getProbs()[i]) + "\t";
            text = result.getProbs()[i] < alpha ? text + "*\n" : text + "\n";
        }
        text = text + "\n\nIntercept = " + this.nf.format(result.getIntercept()) + "\n";
        this.modelParameters.setText(text);
    }
}

