/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.VariableSource;
import edu.cmu.tetrad.model.Params;
import edu.cmu.tetradapp.editor.EditorWindow;
import edu.cmu.tetradapp.editor.ParameterEditor;
import edu.cmu.tetradapp.knowledge_editor.KnowledgeEditor;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.MbSearchParams;
import edu.cmu.tetradapp.util.DesktopController;
import edu.cmu.tetradapp.util.DoubleTextField;
import edu.cmu.tetradapp.util.IntTextField;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.border.MatteBorder;

public final class MbSearchParamEditor
extends JPanel
implements ParameterEditor {
    private MbSearchParams params;
    private String targetName;
    private List<String> varNames;
    private Object[] parentModels;

    @Override
    public void setParams(Params params) {
        if (params == null) {
            throw new NullPointerException();
        }
        this.params = (MbSearchParams)params;
    }

    @Override
    public void setParentModels(Object[] parentModels) {
        if (parentModels == null) {
            throw new NullPointerException();
        }
        this.parentModels = parentModels;
    }

    @Override
    public void setup() {
        this.varNames = this.params().getVarNames();
        if (this.varNames == null) {
            this.varNames = this.getVarsFromData(this.parentModels);
            if (this.varNames == null) {
                this.varNames = this.getVarsFromGraph(this.parentModels);
            }
            if (this.varNames == null) {
                throw new IllegalStateException("Variables are not accessible.");
            }
            this.params().setVarNames(this.varNames);
        }
        this.setBorder(new MatteBorder(10, 10, 10, 10, super.getBackground()));
        this.setLayout(new BoxLayout(this, 1));
        Object[] variableNames = this.varNames.toArray(new String[this.varNames.size()]);
        Arrays.sort(variableNames);
        JComboBox<Object> varsBox = new JComboBox<Object>(variableNames);
        varsBox.setMaximumSize(new Dimension(80, 24));
        varsBox.setPreferredSize(new Dimension(80, 24));
        String targetName = this.params.getTargetName();
        if (!Arrays.asList(variableNames).contains(targetName)) {
            this.params.setTargetName((String)variableNames[0]);
            targetName = this.params.getTargetName();
        }
        if (targetName == null) {
            targetName = (String)varsBox.getSelectedItem();
        } else {
            varsBox.setSelectedItem(targetName);
        }
        this.setTargetName(targetName);
        this.params().setTargetName(this.targetName());
        varsBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JComboBox box = (JComboBox)e.getSource();
                MbSearchParamEditor.this.setTargetName((String)box.getSelectedItem());
                MbSearchParamEditor.this.params().setTargetName(MbSearchParamEditor.this.targetName());
            }
        });
        DoubleTextField alphaField = new DoubleTextField(this.params.getAlpha(), 8, new DecimalFormat("0.0########"));
        alphaField.setFilter(new DoubleTextField.Filter(){

            @Override
            public double filter(double value, double oldValue) {
                try {
                    MbSearchParamEditor.this.params().setAlpha(value);
                    Preferences.userRoot().putDouble("alpha", MbSearchParamEditor.this.params().getAlpha());
                    return value;
                }
                catch (Exception e) {
                    return oldValue;
                }
            }
        });
        IntTextField pcDepthField = new IntTextField(this.params().getDepth(), 4);
        pcDepthField.setFilter(new IntTextField.Filter(){

            @Override
            public int filter(int value, int oldValue) {
                try {
                    MbSearchParamEditor.this.params().setDepth(value);
                    Preferences.userRoot().putInt("pcDepth", MbSearchParamEditor.this.params().getDepth());
                    return value;
                }
                catch (Exception e) {
                    return oldValue;
                }
            }
        });
        JButton knowledgeButton = new JButton("Edit");
        knowledgeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MbSearchParamEditor.this.openKnowledgeEditor();
            }
        });
        JCheckBox preventCycles = new JCheckBox();
        preventCycles.setSelected(this.params.isAggressivelyPreventCycles());
        preventCycles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox box = (JCheckBox)e.getSource();
                MbSearchParams p = MbSearchParamEditor.this.params;
                p.setAggressivelyPreventCycles(box.isSelected());
            }
        });
        Box hBox = Box.createHorizontalBox();
        hBox.add(new JLabel("Aggressively Prevent Cycles:"));
        hBox.add(Box.createHorizontalGlue());
        hBox.add(preventCycles);
        this.add(hBox);
        this.add(Box.createVerticalStrut(5));
        Box b0 = Box.createHorizontalBox();
        b0.add(new JLabel("Target:"));
        b0.add(Box.createRigidArea(new Dimension(10, 0)));
        b0.add(Box.createHorizontalGlue());
        b0.add(varsBox);
        this.add(b0);
        Box b1 = Box.createHorizontalBox();
        b1.add(new JLabel("Alpha:"));
        b1.add(Box.createRigidArea(new Dimension(10, 0)));
        b1.add(Box.createHorizontalGlue());
        b1.add(alphaField);
        this.add(b1);
        Box b2 = Box.createHorizontalBox();
        b2.add(new JLabel("Depth:"));
        b2.add(Box.createRigidArea(new Dimension(10, 0)));
        b2.add(Box.createHorizontalGlue());
        b2.add(pcDepthField);
        this.add(b2);
        Box b3 = Box.createHorizontalBox();
        b3.add(new JLabel("Knowledge:"));
        b3.add(Box.createRigidArea(new Dimension(10, 0)));
        b3.add(Box.createHorizontalGlue());
        b3.add(knowledgeButton);
        this.add(b3);
    }

    @Override
    public boolean mustBeShown() {
        return false;
    }

    private List<String> getVarsFromData(Object[] parentModels) {
        VariableSource dataModel = null;
        for (Object parentModel : parentModels) {
            if (!(parentModel instanceof DataWrapper)) continue;
            DataWrapper dataWrapper = (DataWrapper)parentModel;
            dataModel = dataWrapper.getSelectedDataModel();
        }
        if (dataModel == null) {
            return null;
        }
        return new ArrayList<String>(dataModel.getVariableNames());
    }

    private List<String> getVarsFromGraph(Object[] parentModels) {
        GraphSource graphSource = null;
        for (Object parentModel : parentModels) {
            if (!(parentModel instanceof GraphSource)) continue;
            graphSource = (GraphSource)parentModel;
        }
        if (graphSource == null) {
            return null;
        }
        return graphSource.getGraph().getNodeNames();
    }

    private void openKnowledgeEditor() {
        if (this.params() == null) {
            throw new NullPointerException("Parameter object must not be null if you want to launch a OldKnowledgeEditor.");
        }
        if (this.params().getKnowledge() == null) {
            throw new NullPointerException("Knowledge in params object must not be null.");
        }
        KnowledgeEditor knowledgeEditor = new KnowledgeEditor(this.params().getKnowledge(), this.varNames, this.params.getSourceGraph());
        EditorWindow editorWindow = new EditorWindow(knowledgeEditor, knowledgeEditor.getName(), "Save", false, this);
        DesktopController.getInstance().addEditorWindow(editorWindow, JLayeredPane.PALETTE_LAYER);
        editorWindow.setVisible(true);
    }

    private MbSearchParams params() {
        return this.params;
    }

    private String targetName() {
        return this.targetName;
    }

    private void setTargetName(String targetName) {
        this.targetName = targetName;
    }
}

