/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.VariableSource;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.model.Params;
import edu.cmu.tetrad.search.MimBuild;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.editor.ClusterEditor;
import edu.cmu.tetradapp.editor.EditorWindow;
import edu.cmu.tetradapp.editor.ParameterEditor;
import edu.cmu.tetradapp.knowledge_editor.KnowledgeEditor;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GraphWrapper;
import edu.cmu.tetradapp.model.MimParams;
import edu.cmu.tetradapp.util.DesktopController;
import edu.cmu.tetradapp.util.DoubleTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;

public class MimBuildParamsEditor
extends JPanel
implements ParameterEditor {
    private MimParams params;
    private Object[] parentModels;

    @Override
    public void setParams(Params params) {
        this.params = (MimParams)params;
    }

    @Override
    public void setParentModels(Object[] parentModels) {
        this.parentModels = parentModels;
    }

    @Override
    public void setup() {
        DoubleTextField alphaField = new DoubleTextField(this.getParams().getAlpha(), 4, NumberFormatUtil.getInstance().getNumberFormat());
        alphaField.setFilter(new DoubleTextField.Filter(){

            @Override
            public double filter(double value, double oldValue) {
                try {
                    MimBuildParamsEditor.this.getParams().setAlpha(value);
                    return value;
                }
                catch (Exception e) {
                    return oldValue;
                }
            }
        });
        String[] descriptions = MimBuild.getAlgorithmDescriptions();
        JComboBox<String> algorithmSelector = new JComboBox<String>(descriptions);
        algorithmSelector.setSelectedIndex(this.params.getAlgorithmType());
        algorithmSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox combo = (JComboBox)e.getSource();
                int index = combo.getSelectedIndex();
                MimBuildParamsEditor.this.getParams().setAlgorithmType(index);
            }
        });
        VariableSource dataModel = null;
        Graph graph = null;
        for (int i = 0; i < this.parentModels.length; ++i) {
            if (this.parentModels[i] instanceof DataWrapper) {
                DataWrapper dataWrapper = (DataWrapper)this.parentModels[i];
                dataModel = dataWrapper.getSelectedDataModel();
            }
            if (!(this.parentModels[i] instanceof GraphWrapper)) continue;
            GraphWrapper graphWrapper = (GraphWrapper)this.parentModels[i];
            graph = graphWrapper.getGraph();
        }
        if (dataModel != null) {
            ArrayList<String> varNames = new ArrayList<String>(dataModel.getVariableNames());
        } else if (graph != null) {
            Iterator<Node> it = graph.getNodes().iterator();
            ArrayList<String> varNames = new ArrayList<String>();
            while (it.hasNext()) {
                Node temp = it.next();
                if (temp.getNodeType() != NodeType.MEASURED) continue;
                varNames.add(temp.getName());
            }
        } else {
            System.out.println("Null Data Model");
        }
        Box b = Box.createVerticalBox();
        Box b1 = Box.createHorizontalBox();
        b1.add(new JLabel("Alpha:"));
        b1.add(Box.createHorizontalGlue());
        b1.add(alphaField);
        b.add(b1);
        JButton editClusters = new JButton("Edit");
        editClusters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MimBuildParamsEditor.this.openClusterEditor();
            }
        });
        JButton editKnowledge = new JButton("Edit");
        editKnowledge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MimBuildParamsEditor.this.openKnowledgeEditor();
            }
        });
        Box b2 = Box.createHorizontalBox();
        b2.add(new JLabel("Cluster Assignments:"));
        b2.add(Box.createHorizontalGlue());
        b2.add(editClusters);
        b.add(b2);
        Box b3 = Box.createHorizontalBox();
        b3.add(new JLabel("Knowledge"));
        b3.add(Box.createHorizontalGlue());
        b3.add(editKnowledge);
        b.add(b3);
        Box b4 = Box.createHorizontalBox();
        b4.add(new JLabel("Algorithm:"));
        b4.add(Box.createHorizontalGlue());
        b4.add(algorithmSelector);
        b.add(b4);
        this.setLayout(new BorderLayout());
        this.add((Component)b, "Center");
    }

    @Override
    public boolean mustBeShown() {
        return false;
    }

    private void openClusterEditor() {
        ClusterEditor clusterEditor = new ClusterEditor(this.getParams().getClusters(), this.getParams().getVarNames());
        EditorWindow window = new EditorWindow(clusterEditor, clusterEditor.getName(), "Save", false, this);
        DesktopController.getInstance().addEditorWindow(window, JLayeredPane.PALETTE_LAYER);
        window.setVisible(true);
    }

    private void openKnowledgeEditor() {
        KnowledgeEditor knowledgeEditor = new KnowledgeEditor(this.getParams().getKnowledge(), this.getParams().getVarNames(), this.getParams().getSourceGraph());
        int centerX = this.getLocation().x + this.getWidth() / 2;
        int centerY = this.getLocation().y + this.getWidth() / 2;
        EditorWindow window = new EditorWindow(knowledgeEditor, knowledgeEditor.getName(), "Save", false, this);
        DesktopController.getInstance().addEditorWindow(window, JLayeredPane.PALETTE_LAYER);
        window.setVisible(true);
    }

    private MimParams getParams() {
        return this.params;
    }
}

