/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.editor.BuildPureClustersIndTestParamsEditor;
import edu.cmu.tetradapp.editor.ClusterEditor;
import edu.cmu.tetradapp.editor.MimBuildIndTestParamsEditor;
import edu.cmu.tetradapp.editor.PurifyIndTestParamsEditor;
import edu.cmu.tetradapp.model.BuildPureClustersIndTestParams;
import edu.cmu.tetradapp.model.BuildPureClustersRunner;
import edu.cmu.tetradapp.model.MimBuildIndTestParams;
import edu.cmu.tetradapp.model.MimBuildRunner;
import edu.cmu.tetradapp.model.MimIndTestParams;
import edu.cmu.tetradapp.model.MimParams;
import edu.cmu.tetradapp.model.MimRunner;
import edu.cmu.tetradapp.model.PurifyIndTestParams;
import edu.cmu.tetradapp.model.PurifyRunner;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.rmi.MarshalledObject;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;

public class MimSearchEditor
extends JPanel {
    private MimRunner mimRunner;
    private GraphWorkbench workbench;
    private Thread thread;
    private final int delay = 200;
    private String errorMessage;
    private JButton executeButton = new JButton();
    private String resultLabel;
    private JScrollPane workbenchScroll;
    private JPanel displayPanel;
    private GraphWorkbench structureWorkbench;
    private ClusterEditor clusterEditor;

    private MimSearchEditor(MimRunner mimRunner, String resultLabel) {
        if (mimRunner == null) {
            throw new NullPointerException();
        }
        if (resultLabel == null) {
            throw new NullPointerException();
        }
        this.mimRunner = mimRunner;
        this.resultLabel = resultLabel;
        this.setup(resultLabel);
    }

    public MimSearchEditor(MimBuildRunner runner) {
        this(runner, "Result MAG");
    }

    public MimSearchEditor(BuildPureClustersRunner pureClustersRunner) {
        this(pureClustersRunner, "Result MAG");
    }

    public MimSearchEditor(PurifyRunner runner) {
        this(runner, "Result MAG");
    }

    private JPanel getToolbar() {
        JPanel toolbar = new JPanel();
        this.getExecuteButton().setText("Execute*");
        this.getExecuteButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MimSearchEditor.this.execute();
            }
        });
        Box b1 = Box.createVerticalBox();
        b1.add(this.getParamsPanel());
        b1.add(Box.createVerticalStrut(10));
        Box b2 = Box.createHorizontalBox();
        b2.add(Box.createGlue());
        b2.add(this.getExecuteButton());
        b1.add(b2);
        Box b3 = Box.createHorizontalBox();
        JLabel label = new JLabel("<html>*Please note that some<br>searches may take a<br>long time to complete.</html>");
        label.setHorizontalAlignment(0);
        label.setVerticalAlignment(0);
        label.setBorder(new TitledBorder(""));
        b3.add(label);
        b1.add(Box.createVerticalStrut(10));
        b1.add(b3);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("algorithmFinished".equals(evt.getPropertyName())) {
                    MimSearchEditor.this.specialToolbarSetup();
                }
            }
        });
        toolbar.add(b1);
        return toolbar;
    }

    private void execute() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                MimSearchEditor.this.getExecuteButton().setEnabled(false);
                MimSearchEditor.this.setErrorMessage(null);
                try {
                    MimSearchEditor.this.mimRunner.getParams().setClusters(MimSearchEditor.this.clusterEditor.getClusters());
                    MimSearchEditor.this.getMimRunner().execute();
                }
                catch (Exception e) {
                    CharArrayWriter writer1 = new CharArrayWriter();
                    PrintWriter writer2 = new PrintWriter(writer1);
                    e.printStackTrace(writer2);
                    String message = writer1.toString();
                    writer2.close();
                    e.printStackTrace(System.out);
                    TetradLogger.getInstance().error(message);
                    String messageString = e.getMessage();
                    if (messageString == null) {
                        messageString = message;
                    }
                    MimSearchEditor.this.setErrorMessage(messageString);
                    TetradLogger.getInstance().error("************Algorithm stopped!");
                    MimSearchEditor.this.getExecuteButton().setEnabled(true);
                    throw new RuntimeException(e);
                }
                MimSearchEditor.this.updateDisplayPanel();
                MimSearchEditor.this.getWorkbenchScroll().setBorder(new TitledBorder(MimSearchEditor.this.getResultLabel()));
                Graph resultGraph = MimSearchEditor.this.resultGraph();
                MimSearchEditor.this.doDefaultArrangement(resultGraph);
                GraphUtils.arrangeBySourceGraph(resultGraph, MimSearchEditor.this.getWorkbench().getGraph());
                MimSearchEditor.this.getWorkbench().setBackground(Color.WHITE);
                MimSearchEditor.this.getWorkbench().setGraph(resultGraph);
                MimSearchEditor.this.getWorkbench().repaint();
                MimSearchEditor.this.firePropertyChange("algorithmFinished", null, null);
                MimSearchEditor.this.getExecuteButton().setEnabled(true);
                MimSearchEditor.this.firePropertyChange("modelChanged", null, null);
            }
        };
        Thread thread = new Thread(runnable);
        thread.setPriority(6);
        this.thread = thread;
        thread.start();
        Thread watcher = new Thread(){

            @Override
            public void run() {
                try {
                    4.sleep(200L);
                }
                catch (InterruptedException e) {
                    return;
                }
                if (MimSearchEditor.this.getErrorMessage() != null) {
                    JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Stopped with error:\n" + MimSearchEditor.this.getErrorMessage());
                    return;
                }
                JProgressBar progressBar = new JProgressBar(0, 100);
                progressBar.setIndeterminate(true);
                JButton stopButton = new JButton("Stop");
                stopButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (MimSearchEditor.this.thread() != null) {
                            MimSearchEditor.this.thread().stop();
                            JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Algorithm stopped");
                            MimSearchEditor.this.getExecuteButton().setEnabled(true);
                            TetradLogger.getInstance().error("************Algorithm stopped!");
                        }
                    }
                });
                Box b = Box.createHorizontalBox();
                b.add(progressBar);
                b.add(stopButton);
                Frame ancestor = (Frame)JOptionUtils.centeringComp().getTopLevelAncestor();
                JDialog dialog = new JDialog(ancestor, "Searching...", false);
                dialog.getContentPane().add(b);
                dialog.pack();
                dialog.setLocationRelativeTo(MimSearchEditor.this);
                dialog.setVisible(true);
                while (MimSearchEditor.this.thread().isAlive()) {
                    try {
                        4.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
                dialog.setVisible(false);
                dialog.dispose();
                if (MimSearchEditor.this.getErrorMessage() != null) {
                    JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Stopped with error:\n" + MimSearchEditor.this.getErrorMessage());
                }
            }
        };
        watcher.setPriority(6);
        watcher.start();
    }

    private void doDefaultArrangement(Graph graph) {
        GraphUtils.arrangeInCircle(graph, 200, 200, 150);
        GraphUtils.fruchtermanReingoldLayout(graph);
    }

    private GraphWorkbench getWorkbench() {
        return this.workbench;
    }

    private JButton getExecuteButton() {
        return this.executeButton;
    }

    private MimRunner getMimRunner() {
        return this.mimRunner;
    }

    private void setup(String resultLabel) {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getToolbar(), "West");
        this.add((Component)this.workbenchScroll(resultLabel), "Center");
        this.displayPanel = new JPanel();
        this.displayPanel.setLayout(new BorderLayout());
        this.displayPanel.setPreferredSize(new Dimension(500, 500));
        this.updateDisplayPanel();
        this.add((Component)this.displayPanel, "Center");
        this.add((Component)this.menuBar(), "North");
    }

    private void updateDisplayPanel() {
        this.displayPanel.removeAll();
        JTabbedPane tabbedPane = new JTabbedPane();
        if (this.getMimRunner().getStructureGraph() != null) {
            Graph structureGraph = this.getMimRunner().getStructureGraph();
            if (this.structureWorkbench != null) {
                GraphUtils.fruchtermanReingoldLayout(structureGraph);
            }
            this.structureWorkbench = new GraphWorkbench(structureGraph);
            this.structureWorkbench.setAllowDoubleClickActions(false);
            tabbedPane.add("Structure Model", new JScrollPane(this.structureWorkbench));
        }
        if (this.getMimRunner().getClusters() != null) {
            ClusterEditor editor;
            this.clusterEditor = editor = new ClusterEditor(this.getMimRunner().getClusters(), this.getMimRunner().getData().getVariableNames());
            tabbedPane.add("Measurement Model", editor);
        }
        if (this.getMimRunner().getResultGraph() != null) {
            Graph resultGraph = this.getMimRunner().getResultGraph();
            GraphUtils.arrangeInCircle(resultGraph, 200, 200, 150);
            GraphUtils.fruchtermanReingoldLayout(resultGraph);
            GraphWorkbench resultWorkbench = new GraphWorkbench(resultGraph);
            tabbedPane.add("Full Graph", new JScrollPane(resultWorkbench));
        }
        this.displayPanel.add((Component)tabbedPane, "Center");
        this.displayPanel.revalidate();
        this.displayPanel.repaint();
    }

    private Graph resultGraph() {
        Graph resultGraph = this.getMimRunner().getResultGraph();
        if (resultGraph == null) {
            resultGraph = new EdgeListGraph();
        }
        return resultGraph;
    }

    private JScrollPane workbenchScroll(String resultLabel) {
        Graph resultGraph = this.resultGraph();
        Graph sourceGraph = this.getMimRunner().getSourceGraph();
        Graph latestWorkbenchGraph = this.getMimRunner().getParams().getSourceGraph();
        boolean arrangedAll = GraphUtils.arrangeBySourceGraph(resultGraph, latestWorkbenchGraph);
        if (!arrangedAll) {
            GraphUtils.arrangeBySourceGraph(resultGraph, sourceGraph);
        }
        this.workbench = new GraphWorkbench(resultGraph);
        this.workbench.setAllowDoubleClickActions(false);
        this.workbenchScroll = new JScrollPane(this.getWorkbench());
        this.getWorkbenchScroll().setPreferredSize(new Dimension(450, 450));
        this.getWorkbenchScroll().setBorder(new TitledBorder(resultLabel));
        this.workbench.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                MimSearchEditor.this.storeLatestWorkbenchGraph();
            }
        });
        return this.getWorkbenchScroll();
    }

    private JMenuBar menuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu file = new JMenu("File");
        menuBar.add(file);
        return menuBar;
    }

    private Thread thread() {
        return this.thread;
    }

    private String getErrorMessage() {
        return this.errorMessage;
    }

    private void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    private String getResultLabel() {
        return this.resultLabel;
    }

    private JScrollPane getWorkbenchScroll() {
        return this.workbenchScroll;
    }

    public Graph getLatestWorkbenchGraph() {
        Graph graph = this.getMimRunner().getParams().getSourceGraph();
        if (graph == null) {
            return this.getMimRunner().getSourceGraph();
        }
        return graph;
    }

    private void storeLatestWorkbenchGraph() {
        Graph latestWorkbenchGraph = this.getWorkbench().getGraph();
        if (latestWorkbenchGraph.getNumNodes() == 0) {
            return;
        }
        try {
            Graph graph = new MarshalledObject<Graph>(latestWorkbenchGraph).get();
            this.getMimRunner().getParams().setSourceGraph(graph);
        }
        catch (IOException e) {
            this.getMimRunner().getParams().setSourceGraph(null);
        }
        catch (ClassNotFoundException e) {
            this.getMimRunner().getParams().setSourceGraph(null);
            e.printStackTrace();
        }
    }

    private Box getParamsPanel() {
        Box b2 = Box.createVerticalBox();
        b2.add(this.getIndTestParamBox());
        b2.setBorder(new TitledBorder("Parameters"));
        return b2;
    }

    private void specialToolbarSetup() {
    }

    private JComponent getIndTestParamBox() {
        MimParams params = this.getMimRunner().getParams();
        MimIndTestParams indTestParams = params.getMimIndTestParams();
        return this.getIndTestParamBox(indTestParams);
    }

    private JComponent getIndTestParamBox(MimIndTestParams indTestParams) {
        MimIndTestParams params;
        MimRunner runner;
        if (indTestParams == null) {
            throw new NullPointerException();
        }
        if (indTestParams instanceof BuildPureClustersIndTestParams) {
            runner = this.getMimRunner();
            params = (BuildPureClustersIndTestParams)indTestParams;
            ((BuildPureClustersIndTestParams)params).setVarNames((List)runner.getParams().getVarNames());
            DataModel dataModel = runner.getData();
            if (dataModel instanceof DataSet) {
                DataSet data = (DataSet)runner.getData();
                boolean discrete = data.isDiscrete();
                return new BuildPureClustersIndTestParamsEditor((BuildPureClustersIndTestParams)params, discrete);
            }
            if (dataModel instanceof CovarianceMatrix) {
                return new BuildPureClustersIndTestParamsEditor((BuildPureClustersIndTestParams)params, false);
            }
        }
        if (indTestParams instanceof PurifyIndTestParams) {
            runner = this.getMimRunner();
            params = (PurifyIndTestParams)indTestParams;
            ((PurifyIndTestParams)params).setVarNames(runner.getParams().getVarNames());
            boolean discreteData = ((DataSet)runner.getData()).isDiscrete();
            return new PurifyIndTestParamsEditor((PurifyIndTestParams)params, discreteData);
        }
        if (indTestParams instanceof MimBuildIndTestParams) {
            runner = this.getMimRunner();
            params = (MimBuildIndTestParams)indTestParams;
            ((MimBuildIndTestParams)params).setVarNames((List)runner.getParams().getVarNames());
            return new MimBuildIndTestParamsEditor((MimBuildIndTestParams)params);
        }
        throw new IllegalArgumentException("Unrecognized IndTestParams: " + indTestParams.getClass());
    }
}

