/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.sem.ISemIm;
import edu.cmu.tetrad.util.NumberFormatUtil;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.NumberFormat;
import javax.swing.JTextArea;

final class ModelStatisticsPanel
extends JTextArea {
    private ISemIm semIm;
    private NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();

    public ModelStatisticsPanel(ISemIm semIm) {
        this.semIm = semIm;
        this.reset();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                ModelStatisticsPanel.this.reset();
            }
        });
    }

    private void reset() {
        double modelPValue;
        double modelDof;
        double modelChiSquare;
        this.setText("");
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        try {
            modelChiSquare = this.getSemIm().getChiSquare();
            modelDof = this.semIm.getSemPm().getDof();
            modelPValue = this.getSemIm().getPValue();
        }
        catch (Exception e) {
            this.append("Model statistics not available.");
            return;
        }
        this.append("\nDegrees of Freedom = " + (int)modelDof);
        if (modelDof >= 0.0) {
            this.append("\nChi Square = " + this.nf.format(modelChiSquare));
            this.append("\nP Value = " + this.nf.format(modelPValue));
            this.append("\nBIC Score = " + this.nf.format(this.semIm.getBicScore()));
            this.append("\n\nThe above chi square test assumes that the maximum likelihood function over the measured variables has been minimized. Under that assumption, the null hypothesis for the test is that the population covariance matrix over all of the measured variables is equal to the estimated covariance matrix over all of the measured variables written as a function of the free model parameters--that is, the unfixed parameters for each directed edge (the linear coefficient for that edge), each exogenous variable (the variance for the error term for that variable), and each bidirected edge (the covariance for the exogenous variables it connects).  The model is explained in Bollen, Structural Equations with Latent Variable, 110. ");
        } else {
            int numToFix = (int)Math.abs(modelDof);
            this.append("\n\nA SEM with negative degrees of freedom is underidentified, \nand other model statistics are meaningless.  Please increase \nthe degrees of freedom to 0 or above by fixing at least " + numToFix + " parameter" + (numToFix == 1 ? "." : "s."));
        }
    }

    private ISemIm getSemIm() {
        return this.semIm;
    }
}

