/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import cern.jet.random.Normal;
import cern.jet.random.engine.MersenneTwister;
import edu.cmu.tetrad.data.AndersonDarlingTest;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.Variable;
import edu.cmu.tetrad.util.NumberFormatUtil;
import java.text.NumberFormat;

public class NormalityTests {
    public static String runNormalityTests(DataSet dataSet, ContinuousVariable variable) {
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        String result = "Normality Tests for: " + variable.getName() + " (sample size:" + dataSet.getNumRows() + ")";
        int lengthOfTitle = result.length();
        result = result + "\n";
        for (int i = 0; i < lengthOfTitle; ++i) {
            result = result + "-";
        }
        result = result + "\n\nKolmogorov Smirnov:\n--------------------------------\n";
        double[] ksResults = NormalityTests.kolmogorovSmirnov(dataSet, variable);
        double ksStat = (double)Math.round(ksResults[0] * 1.0E7) / 1.0E7;
        result = result + "K-S Statistic: " + ksStat + "\n\n";
        result = result + "Significance Levels:\t.20\t.15\t.10\t.05\t.01\nK-S Critical Values:";
        result = result + "\t" + nf.format(ksResults[0]) + "\t" + nf.format(ksResults[1]) + "\t" + nf.format(ksResults[2]) + "\t" + nf.format(ksResults[3]) + "\t" + nf.format(ksResults[4]) + "\n";
        boolean testResult = false;
        String pass = "FAIL";
        if (ksResults[0] < ksResults[1]) {
            testResult = true;
        }
        pass = testResult ? "ACCEPT" : "FAIL";
        result = result + "Test Result:\t\t" + pass;
        testResult = false;
        if (ksResults[0] < ksResults[2]) {
            testResult = true;
        }
        pass = testResult ? "ACCEPT" : "FAIL";
        result = result + "\t" + pass;
        testResult = false;
        if (ksResults[0] < ksResults[3]) {
            testResult = true;
        }
        pass = testResult ? "ACCEPT" : "FAIL";
        result = result + "\t" + pass;
        testResult = false;
        if (ksResults[0] < ksResults[4]) {
            testResult = true;
        }
        pass = testResult ? "ACCEPT" : "FAIL";
        result = result + "\t" + pass;
        testResult = false;
        if (ksResults[0] < ksResults[5]) {
            testResult = true;
        }
        pass = testResult ? "ACCEPT" : "FAIL";
        result = result + "\t" + pass;
        testResult = false;
        result = result + "\n\nH0 = " + variable + " is Normal.\n";
        result = result + "(Normal if ACCEPT.)\n";
        result = result + "\n\n";
        result = result + "Anderson Darling Test:\n";
        result = result + "---------------------\n";
        int column = dataSet.getVariables().indexOf(variable);
        double[] data = dataSet.getDoubleData().viewColumn(column).toArray();
        AndersonDarlingTest andersonDarlingTest = new AndersonDarlingTest(data);
        result = result + "A^2 = " + nf.format(andersonDarlingTest.getASquared()) + "\n";
        result = result + "A^2* = " + nf.format(andersonDarlingTest.getASquaredStar()) + "\n";
        result = result + "p = " + nf.format(andersonDarlingTest.getP()) + "\n";
        result = result + "\nH0 = " + variable + " is Non-normal.";
        result = result + "\n(Normal if p > alpha.)\n";
        return result;
    }

    public static double[] kolmogorovSmirnov(DataSet dataSet, ContinuousVariable variable) {
        int n = dataSet.getNumRows();
        int columnIndex = dataSet.getColumn(variable);
        Normal idealDistribution = NormalityTests.getNormal(dataSet, variable);
        double[] ks = new double[6];
        for (int i = 1; i < 6; ++i) {
            ks[i] = NormalityTests.estimateKSCriticalValue(i, n);
        }
        NormalityTests.sortVariable(dataSet, variable);
        double d = 0.0;
        for (int i = 1; i <= n; ++i) {
            double x = dataSet.getDouble(i - 1, columnIndex);
            double idealValue = idealDistribution.cdf(x);
            double difference = Math.abs(idealValue - (double)i / (double)n);
            if (!(difference > d)) continue;
            d = difference;
        }
        ks[0] = d;
        return ks;
    }

    public static double empiricalDistributionFunction(DataSet dataSet, Variable var, double x, int n) {
        double value = 0.0;
        int columnIndex = dataSet.getColumn(var);
        for (int i = 0; i < n; ++i) {
            if (!(dataSet.getDouble(i, columnIndex) <= x)) continue;
            value += 1.0;
        }
        return value /= (double)n;
    }

    public static void sortVariable(DataSet dataSet, Variable variable) {
        int columnIndex = dataSet.getColumn(variable);
        for (int i = 0; i < dataSet.getNumRows(); ++i) {
            for (int k = i; k < dataSet.getNumRows(); ++k) {
                if (!(dataSet.getDouble(i, columnIndex) > dataSet.getDouble(k, columnIndex))) continue;
                double temp = dataSet.getDouble(i, columnIndex);
                dataSet.setDouble(i, columnIndex, dataSet.getDouble(k, columnIndex));
                dataSet.setDouble(k, columnIndex, temp);
            }
        }
    }

    public static double kolmogorovSmirnovCDF(double x) {
        double sum = 0.0;
        for (int i = 0; i < 100; ++i) {
            sum += Math.pow(Math.E, -1.0 * Math.pow(2 * i - 1, 2.0) * Math.pow(Math.PI, 2.0) / Math.pow(8.0 * x, 2.0));
        }
        double estimatedValue = sum * (Math.sqrt(Math.PI * 2) / x);
        return estimatedValue;
    }

    public static double estimateKSCriticalValue(int level, int n) {
        double criticalValue = 0.0;
        if (n <= 35) {
            if (n >= 20 && n < 25) {
                n = 20;
            }
            if (n >= 25 && n < 30) {
                n = 25;
            }
            if (n >= 30 && n < 35) {
                n = 30;
            }
            double[] table = new double[36];
            switch (level) {
                case 1: {
                    table[1] = 0.9;
                    table[2] = 0.684;
                    table[3] = 0.565;
                    table[4] = 0.494;
                    table[5] = 0.446;
                    table[6] = 0.41;
                    table[7] = 0.381;
                    table[8] = 0.358;
                    table[9] = 0.339;
                    table[10] = 0.322;
                    table[11] = 0.307;
                    table[12] = 0.295;
                    table[13] = 0.284;
                    table[14] = 0.274;
                    table[15] = 0.266;
                    table[16] = 0.258;
                    table[17] = 0.25;
                    table[18] = 0.244;
                    table[19] = 0.237;
                    table[20] = 0.231;
                    table[25] = 0.21;
                    table[30] = 0.19;
                    table[35] = 0.18;
                    break;
                }
                case 2: {
                    table[1] = 0.925;
                    table[2] = 0.726;
                    table[3] = 0.597;
                    table[4] = 0.525;
                    table[5] = 0.474;
                    table[6] = 0.436;
                    table[7] = 0.405;
                    table[8] = 0.381;
                    table[9] = 0.36;
                    table[10] = 0.342;
                    table[11] = 0.326;
                    table[12] = 0.313;
                    table[13] = 0.302;
                    table[14] = 0.292;
                    table[15] = 0.283;
                    table[16] = 0.274;
                    table[17] = 0.266;
                    table[18] = 0.259;
                    table[19] = 0.252;
                    table[20] = 0.246;
                    table[25] = 0.22;
                    table[30] = 0.2;
                    table[35] = 0.19;
                    break;
                }
                case 3: {
                    table[1] = 0.95;
                    table[2] = 0.776;
                    table[3] = 0.642;
                    table[4] = 0.564;
                    table[5] = 0.51;
                    table[6] = 0.47;
                    table[7] = 0.438;
                    table[8] = 0.411;
                    table[9] = 0.388;
                    table[10] = 0.368;
                    table[11] = 0.352;
                    table[12] = 0.338;
                    table[13] = 0.325;
                    table[14] = 0.314;
                    table[15] = 0.304;
                    table[16] = 0.295;
                    table[17] = 0.286;
                    table[18] = 0.278;
                    table[19] = 0.272;
                    table[20] = 0.264;
                    table[25] = 0.24;
                    table[30] = 0.22;
                    table[35] = 0.21;
                    break;
                }
                case 4: {
                    table[1] = 0.975;
                    table[2] = 0.842;
                    table[3] = 0.708;
                    table[4] = 0.624;
                    table[5] = 0.565;
                    table[6] = 0.521;
                    table[7] = 0.486;
                    table[8] = 0.457;
                    table[9] = 0.432;
                    table[10] = 0.41;
                    table[11] = 0.391;
                    table[12] = 0.375;
                    table[13] = 0.361;
                    table[14] = 0.349;
                    table[15] = 0.338;
                    table[16] = 0.328;
                    table[17] = 0.318;
                    table[18] = 0.309;
                    table[19] = 0.301;
                    table[20] = 0.294;
                    table[25] = 0.27;
                    table[30] = 0.24;
                    table[35] = 0.23;
                    break;
                }
                case 5: {
                    table[1] = 0.995;
                    table[2] = 0.929;
                    table[3] = 0.828;
                    table[4] = 0.733;
                    table[5] = 0.669;
                    table[6] = 0.618;
                    table[7] = 0.577;
                    table[8] = 0.543;
                    table[9] = 0.514;
                    table[10] = 0.49;
                    table[11] = 0.468;
                    table[12] = 0.45;
                    table[13] = 0.433;
                    table[14] = 0.418;
                    table[15] = 0.404;
                    table[16] = 0.392;
                    table[17] = 0.381;
                    table[18] = 0.371;
                    table[19] = 0.363;
                    table[20] = 0.356;
                    table[25] = 0.32;
                    table[30] = 0.29;
                    table[35] = 0.27;
                }
            }
            criticalValue = table[n];
        } else {
            switch (level) {
                case 1: {
                    criticalValue = 1.07 / Math.sqrt(n);
                    break;
                }
                case 2: {
                    criticalValue = 1.14 / Math.sqrt(n);
                    break;
                }
                case 3: {
                    criticalValue = 1.22 / Math.sqrt(n);
                    break;
                }
                case 4: {
                    criticalValue = 1.36 / Math.sqrt(n);
                    break;
                }
                case 5: {
                    criticalValue = 1.63 / Math.sqrt(n);
                }
            }
        }
        return criticalValue;
    }

    public static double cramerVonMises(DataSet dataSet, ContinuousVariable variable) {
        int n = dataSet.getNumRows();
        int columnIndex = dataSet.getColumn(variable);
        Normal idealDistribution = NormalityTests.getNormal(dataSet, variable);
        double cvmStatistic = 0.0;
        for (int i = 1; i <= n; ++i) {
            double summedTerm = (double)((2 * i - 1) / (2 * n)) - idealDistribution.cdf(dataSet.getDouble(i - 1, columnIndex));
            summedTerm *= summedTerm;
            cvmStatistic += summedTerm;
        }
        cvmStatistic += (double)(1 / (12 * n));
        return cvmStatistic /= (double)n;
    }

    public static Normal getNormal(DataSet dataSet, Variable variable) {
        double[] paramsForNormal = NormalityTests.normalParams(dataSet, variable);
        double mean = paramsForNormal[0];
        double sd = paramsForNormal[1];
        return new Normal(mean, sd, new MersenneTwister());
    }

    public static double[] normalParams(DataSet dataSet, Variable variable) {
        int i;
        int columnIndex = dataSet.getColumn(variable);
        double mean = 0.0;
        double sd = 0.0;
        for (i = 0; i < dataSet.getNumRows(); ++i) {
            mean += dataSet.getDouble(i, columnIndex);
        }
        mean /= (double)dataSet.getNumRows();
        for (i = 0; i < dataSet.getNumRows(); ++i) {
            sd += (dataSet.getDouble(i, columnIndex) - mean) * (dataSet.getDouble(i, columnIndex) - mean);
        }
        sd /= (double)dataSet.getNumRows() - 1.0;
        sd = Math.sqrt(sd);
        double[] result = new double[]{mean, sd};
        return result;
    }
}

