/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.util.NumberFormatUtil;
import java.awt.Color;
import java.awt.Font;
import java.text.NumberFormat;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;

class NumberCellEditor
extends DefaultCellEditor {
    private JTextField textField;
    private String emptyString = "";

    public NumberCellEditor() {
        this(NumberFormatUtil.getInstance().getNumberFormat());
    }

    public NumberCellEditor(final NumberFormat nf) {
        super(new JTextField());
        if (nf == null) {
            throw new NullPointerException();
        }
        this.textField = (JTextField)this.editorComponent;
        this.textField.setHorizontalAlignment(4);
        this.textField.setBorder(new LineBorder(Color.black));
        this.textField.setFont(new Font("Serif", 0, 12));
        this.setClickCountToStart(1);
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            @Override
            public void setValue(Object value) {
                if (value == null) {
                    NumberCellEditor.this.textField.setText(NumberCellEditor.this.emptyString);
                } else if (value instanceof Integer) {
                    NumberCellEditor.this.textField.setText(value.toString());
                } else if (value instanceof Double) {
                    double doubleValue = (Double)value;
                    if (Double.isNaN(doubleValue)) {
                        NumberCellEditor.this.textField.setText(NumberCellEditor.this.emptyString);
                    } else {
                        NumberCellEditor.this.textField.setText(nf.format(doubleValue));
                    }
                }
                NumberCellEditor.this.textField.setCaretPosition(0);
                NumberCellEditor.this.textField.moveCaretPosition(NumberCellEditor.this.textField.getText().length());
            }

            @Override
            public Object getCellEditorValue() {
                return NumberCellEditor.this.textField.getText();
            }
        };
        this.textField.addActionListener(this.delegate);
    }

    public String getEmptyString() {
        return this.emptyString;
    }

    public void setEmptyString(String emptyString) {
        if (emptyString == null) {
            throw new NullPointerException();
        }
        this.emptyString = emptyString;
    }
}

