/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.sem.ISemIm;
import edu.cmu.tetrad.sem.ParamType;
import edu.cmu.tetrad.sem.Parameter;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.ProbUtils;
import edu.cmu.tetradapp.editor.SemImEditor;
import java.text.NumberFormat;
import java.util.List;
import javax.swing.table.AbstractTableModel;

final class ParamTableModel
extends AbstractTableModel {
    private ISemIm semIm;
    private NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
    private SemImEditor editor = null;
    private int maxFreeParamsForStatistics = 50;
    private boolean editable = true;

    public ParamTableModel(ISemIm semIm, SemImEditor editor, int maxFreeParamsForStatistics) {
        if (semIm == null) {
            throw new NullPointerException("SemIm must not be null.");
        }
        if (maxFreeParamsForStatistics < 0) {
            throw new IllegalArgumentException();
        }
        this.semIm = semIm;
        this.maxFreeParamsForStatistics = maxFreeParamsForStatistics;
        this.editor = editor;
    }

    @Override
    public int getRowCount() {
        int numNodes = this.semIm().getVariableNodes().size();
        return this.semIm().getNumFreeParams() + numNodes;
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "From";
            }
            case 1: {
                return "To";
            }
            case 2: {
                return "Type";
            }
            case 3: {
                return "Value";
            }
            case 4: {
                return "SE";
            }
            case 5: {
                return "T";
            }
            case 6: {
                return "P";
            }
        }
        return null;
    }

    @Override
    public Object getValueAt(int row, int column) {
        List<Node> nodes = this.semIm().getVariableNodes();
        List<Parameter> freeParameters = this.semIm().getFreeParameters();
        int numFreeParams = this.semIm.getNumFreeParams();
        if (row < numFreeParams) {
            Parameter parameter = freeParameters.get(row);
            switch (column) {
                case 0: {
                    return parameter.getNodeA();
                }
                case 1: {
                    return parameter.getNodeB();
                }
                case 2: {
                    return this.typeString(parameter);
                }
                case 3: {
                    return this.asString(this.paramValue(parameter));
                }
                case 4: {
                    return this.asString(this.semIm().getStandardError(parameter, this.maxFreeParamsForStatistics));
                }
                case 5: {
                    return this.asString(this.semIm().getTValue(parameter, this.maxFreeParamsForStatistics));
                }
                case 6: {
                    return this.asString(this.semIm().getPValue(parameter, this.maxFreeParamsForStatistics));
                }
            }
        } else if (row < numFreeParams + nodes.size()) {
            int index = row - numFreeParams;
            Node node = this.semIm.getVariableNodes().get(index);
            int n = this.semIm.getSampleSize();
            int df = n - 1;
            double mean = this.semIm.getMean(node);
            double stdDev = this.semIm.getMeanStdDev(node);
            double stdErr = stdDev / Math.sqrt(n);
            double tValue = mean / stdErr;
            double p = 2.0 * (1.0 - ProbUtils.tCdf(Math.abs(tValue), df));
            switch (column) {
                case 0: {
                    return nodes.get(index);
                }
                case 1: {
                    return nodes.get(index);
                }
                case 2: {
                    if (this.editor.isEditIntercepts()) {
                        return "Intercept";
                    }
                    return "Mean";
                }
                case 3: {
                    if (this.editor.isEditIntercepts()) {
                        double intercept = this.semIm.getIntercept(node);
                        return this.asString(intercept);
                    }
                    return this.asString(mean);
                }
                case 4: {
                    return this.asString(stdErr);
                }
                case 5: {
                    return this.asString(tValue);
                }
                case 6: {
                    return this.asString(p);
                }
            }
        }
        return null;
    }

    private double paramValue(Parameter parameter) {
        double paramValue = this.semIm().getParamValue(parameter);
        if (this.editor.isEditCovariancesAsCorrelations()) {
            if (parameter.getType() == ParamType.VAR) {
                paramValue = 1.0;
            }
            if (parameter.getType() == ParamType.COVAR) {
                Node nodeA = parameter.getNodeA();
                Node nodeB = parameter.getNodeB();
                double varA = this.semIm().getParamValue(nodeA, nodeA);
                double varB = this.semIm().getParamValue(nodeB, nodeB);
                paramValue *= Math.sqrt(varA * varB);
            }
        } else if (parameter.getType() == ParamType.VAR) {
            paramValue = Math.sqrt(paramValue);
        }
        return paramValue;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.isEditable() && columnIndex == 3;
    }

    private boolean isEditable() {
        return this.editable;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 3) {
            try {
                double value = Double.parseDouble((String)aValue);
                if (rowIndex < this.semIm().getNumFreeParams()) {
                    Parameter parameter = this.semIm.getFreeParameters().get(rowIndex);
                    if (parameter.getType() == ParamType.VAR) {
                        value *= value;
                        this.semIm.setErrVar(parameter.getNodeA(), value);
                    } else if (parameter.getType() == ParamType.COEF) {
                        Node x = parameter.getNodeA();
                        Node y = parameter.getNodeB();
                        double intercept = this.semIm.getIntercept(y);
                        this.semIm.setEdgeCoef(x, y, value);
                        if (this.editor.isEditIntercepts()) {
                            this.semIm.setIntercept(y, intercept);
                        }
                    }
                    this.editor.firePropertyChange("modelChanged", 0, 0);
                } else {
                    int index = rowIndex - this.semIm().getNumFreeParams();
                    Node node = this.semIm().getVariableNodes().get(index);
                    if (this.semIm.getMean(this.semIm.getVariableNodes().get(index)) != value) {
                        if (this.editor.isEditIntercepts()) {
                            this.semIm.setIntercept(node, value);
                            this.editor.firePropertyChange("modelChanged", 0, 0);
                        } else {
                            this.semIm.setMean(node, value);
                            this.editor.firePropertyChange("modelChanged", 0, 0);
                        }
                    }
                }
            }
            catch (Exception e1) {
                // empty catch block
            }
            this.fireTableDataChanged();
        }
    }

    private String asString(double value) {
        if (Double.isNaN(value)) {
            return " * ";
        }
        return this.nf.format(value);
    }

    private String typeString(Parameter parameter) {
        ParamType type = parameter.getType();
        if (type == ParamType.COEF) {
            return "Edge Coef.";
        }
        if (this.editor.isEditCovariancesAsCorrelations()) {
            if (type == ParamType.VAR) {
                return "Correlation";
            }
            if (type == ParamType.COVAR) {
                return "Correlation";
            }
        }
        if (type == ParamType.VAR) {
            return "Std. Dev.";
        }
        if (type == ParamType.COVAR) {
            return "Covariance";
        }
        throw new IllegalStateException("Unknown param type.");
    }

    private ISemIm semIm() {
        return this.semIm;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }
}

