/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetradapp.editor.KnowledgeSelection;
import edu.cmu.tetradapp.model.KnowledgeEditable;
import edu.cmu.tetradapp.util.InternalClipboard;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

class PasteKnowledgeAction
extends AbstractAction
implements ClipboardOwner {
    private KnowledgeEditable knowledgeEditable;

    public PasteKnowledgeAction(KnowledgeEditable knowledgeEditable) {
        super("Paste Knowledge");
        if (knowledgeEditable == null) {
            throw new NullPointerException();
        }
        this.knowledgeEditable = knowledgeEditable;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Transferable transferable = InternalClipboard.getInstance().getContents(null);
        if (!(transferable instanceof KnowledgeSelection)) {
            return;
        }
        KnowledgeSelection selection = (KnowledgeSelection)transferable;
        DataFlavor flavor = new DataFlavor(KnowledgeSelection.class, "Knowledge");
        try {
            Knowledge knowledge = (Knowledge)selection.getTransferData(flavor);
            if (knowledge != null) {
                this.knowledgeEditable.setKnowledge(knowledge);
            }
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

