/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.Clusters;
import edu.cmu.tetrad.search.TestType;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.model.PurifyIndTestParams;
import edu.cmu.tetradapp.util.DoubleTextField;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

class PurifyIndTestParamsEditor
extends JPanel {
    private PurifyIndTestParams params;

    public PurifyIndTestParamsEditor(PurifyIndTestParams params, boolean discreteData) {
        this.params = params;
        DoubleTextField alphaField = new DoubleTextField(this.getParams().getAlpha(), 7, NumberFormatUtil.getInstance().getNumberFormat());
        alphaField.setFilter(new DoubleTextField.Filter(){

            @Override
            public double filter(double value, double oldValue) {
                try {
                    PurifyIndTestParamsEditor.this.getParams().setAlpha(value);
                    return value;
                }
                catch (IllegalArgumentException e) {
                    return oldValue;
                }
            }
        });
        JComboBox<Object> testSelector = new JComboBox();
        if (!discreteData) {
            TestType[] descriptions = TestType.getTestDescriptions();
            testSelector = new JComboBox<TestType>(descriptions);
            testSelector.setSelectedItem(this.getParams().getTetradTestType());
            testSelector.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JComboBox combo = (JComboBox)e.getSource();
                    TestType index = (TestType)combo.getSelectedItem();
                    PurifyIndTestParamsEditor.this.getParams().setTetradTestType(index);
                }
            });
        }
        this.setLayout(new BoxLayout(this, 1));
        Box b = Box.createVerticalBox();
        if (!discreteData) {
            Box b2 = Box.createHorizontalBox();
            b2.add(new JLabel("Test:"));
            b2.add(Box.createHorizontalStrut(15));
            b2.add(Box.createHorizontalGlue());
            b2.add(testSelector);
            this.add(b2);
            b.add(Box.createVerticalStrut(2));
        }
        Box b3 = Box.createHorizontalBox();
        b3.add(new JLabel("Alpha:"));
        b3.add(Box.createHorizontalStrut(10));
        b3.add(Box.createHorizontalGlue());
        b3.add(alphaField);
        b.add(b3);
        this.add((Component)b, "Center");
    }

    private PurifyIndTestParams getParams() {
        return this.params;
    }

    private Clusters getClusters() {
        return this.params.getClusters();
    }

    private List<String> getVarNames() {
        return this.params.getVarNames();
    }
}

