/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import cern.jet.random.Normal;
import cern.jet.random.engine.MersenneTwister;
import edu.cmu.tetrad.data.ColtDataSet;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.dist.Exponential;
import edu.cmu.tetradapp.editor.NormalityTests;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class QQPlot {
    private DataSet dataSet;
    private Normal comparison;
    private ContinuousVariable selectedVariable;
    private double[] comparisonVariable;
    private double minComparison = 0.0;
    private double maxComparison = 0.0;
    private double minData = 0.0;
    private double maxData = 0.0;
    private double min = 0.0;
    private double max = 0.0;

    public QQPlot(DataSet dataSet, Node selectedNode) {
        int[] selected;
        boolean testMode = false;
        if (selectedNode != null) {
            testMode = false;
        }
        if (dataSet == null) {
            throw new NullPointerException("the given dataset must not be null");
        }
        if (dataSet.getNumColumns() == 0) {
            throw new IllegalArgumentException("The given dataset should not be empty");
        }
        if (!testMode) {
            for (int i = 0; i < dataSet.getNumColumns() && !(dataSet.getVariable(i) instanceof ContinuousVariable); ++i) {
                if (i != dataSet.getNumColumns() - 1) continue;
                JOptionPane.showMessageDialog(new JFrame(), "You must have at least one continuous variable to construct a q-q plot!");
                throw new IllegalArgumentException("You must have at least one continuous variable to construct a q-q plot!");
            }
        }
        this.dataSet = new ColtDataSet((ColtDataSet)dataSet);
        if (selectedNode == null && dataSet.getNumColumns() != 0 && ((selected = dataSet.getSelectedIndices()) == null || selected.length == 0)) {
            for (int i = 0; i < selected.length; ++i) {
                if (!(dataSet.getVariable(selected[i]) instanceof ContinuousVariable)) continue;
                selectedNode = dataSet.getVariable(selected[i]);
                break;
            }
        }
        try {
            this.selectedVariable = (ContinuousVariable)selectedNode;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(new JFrame(), "You cannot construct a q-q plot for a discrete variable!");
            throw new IllegalArgumentException("Only attempt to construct a q-q plot on a continuous variable!");
        }
        if (testMode) {
            this.testPlot();
        } else {
            this.buildQQPlotData(this.selectedVariable);
        }
    }

    public double getMaxSample() {
        return this.maxData;
    }

    public double getMinSample() {
        return this.minData;
    }

    public double getMaxIdeal() {
        return this.maxComparison;
    }

    public double getMinIdeal() {
        return this.minComparison;
    }

    public double getMinValue() {
        return this.min;
    }

    public double getMaxValue() {
        return this.max;
    }

    public Node getSelectedVariable() {
        return this.selectedVariable;
    }

    public void setSelectedVariable(ContinuousVariable c) {
        this.selectedVariable = c;
    }

    public double[] getComparisonVariable() {
        return this.comparisonVariable;
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    private void testPlot() {
        int i;
        ContinuousVariable c = new ContinuousVariable("test");
        if (this.dataSet.getVariable("test") == null) {
            this.dataSet.addVariable(c);
        }
        ContinuousVariable c2 = new ContinuousVariable("test2");
        if (this.dataSet.getVariable("test2") == null) {
            this.dataSet.addVariable(c2);
        }
        this.selectedVariable = c;
        int columnIndex = this.dataSet.getColumn(c);
        edu.cmu.tetrad.util.dist.Normal g = new edu.cmu.tetrad.util.dist.Normal(1.0, 1.0);
        Exponential e = new Exponential(1.0);
        double mean = 0.0;
        double sd = 0.0;
        this.minData = 1.0E13;
        this.maxData = 0.0;
        this.minComparison = 1.0E12;
        this.maxComparison = 0.0;
        for (i = 0; i < this.dataSet.getNumRows(); ++i) {
            double value = g.nextRandom();
            double value2 = e.nextRandom();
            this.dataSet.setDouble(i, columnIndex, value);
            this.dataSet.setDouble(i, columnIndex + 1, value2);
            mean += value;
            if (value < this.minData) {
                this.minData = value;
            }
            if (!(value > this.maxData)) continue;
            this.maxData = value;
        }
        NormalityTests.kolmogorovSmirnov(this.dataSet, c2);
        for (i = 0; i < this.dataSet.getNumRows(); ++i) {
            for (int k = i; k < this.dataSet.getNumRows(); ++k) {
                if (!(this.dataSet.getDouble(i, columnIndex) > this.dataSet.getDouble(k, columnIndex))) continue;
                double temp = this.dataSet.getDouble(i, columnIndex);
                this.dataSet.setDouble(i, columnIndex, this.dataSet.getDouble(k, columnIndex));
                this.dataSet.setDouble(k, columnIndex, temp);
            }
        }
        mean = mean == 0.0 ? 1.0 : (mean /= (double)this.dataSet.getNumRows());
        for (i = 0; i < this.dataSet.getNumRows(); ++i) {
            sd += (this.dataSet.getDouble(i, columnIndex) - mean) * (this.dataSet.getDouble(i, columnIndex) - mean);
        }
        if (sd == 0.0) {
            sd = 1.0;
        } else {
            sd /= (double)this.dataSet.getNumRows() - 1.0;
            sd = Math.sqrt(sd);
        }
        this.comparison = new Normal(mean, sd, new MersenneTwister());
        this.calculateComparisonSet(this.comparison, this.dataSet);
        this.min = this.minData < this.minComparison ? this.minData : this.minComparison;
        this.max = this.maxData > this.maxComparison ? this.maxData : this.maxComparison;
    }

    public void calculateComparisonSet(Normal n, DataSet data) {
        this.comparisonVariable = new double[data.getNumRows()];
        int column2 = data.getColumn(this.selectedVariable);
        for (int i = 0; i < data.getNumRows(); ++i) {
            double valueAtQuantile;
            this.comparisonVariable[i] = valueAtQuantile = QQPlot.findQuantile((double)(i + 1) / ((double)data.getNumRows() + 1.0), this.minData, this.maxData, n, 1.0E-4, 0, 50);
            if (valueAtQuantile < this.minComparison) {
                this.minComparison = valueAtQuantile;
            }
            if (!(valueAtQuantile > this.maxComparison)) continue;
            this.maxComparison = valueAtQuantile;
        }
    }

    public static double findQuantile(double quantile, double low, double high, Normal n, double precision, int count, int searchCap) {
        double mid = low + (high - low) / 2.0;
        double cdfResult = n.cdf(mid);
        if (Math.abs(cdfResult - quantile) < precision || count > searchCap) {
            return mid;
        }
        if (cdfResult > quantile) {
            return QQPlot.findQuantile(quantile, low, mid - precision, n, precision, count + 1, searchCap);
        }
        return QQPlot.findQuantile(quantile, mid + precision, high, n, precision, count + 1, searchCap);
    }

    private void buildQQPlotData(Node selectedNode) {
        int i;
        int columnIndex = this.dataSet.getColumn(selectedNode);
        double mean = 0.0;
        double sd = 0.0;
        this.minData = 1.0E13;
        this.maxData = 0.0;
        this.minComparison = 1.0E12;
        this.maxComparison = 0.0;
        if (columnIndex == -1) {
            for (i = 0; i < this.dataSet.getNumColumns(); ++i) {
                if (!(this.dataSet.getVariable(i) instanceof ContinuousVariable)) continue;
                this.selectedVariable = (ContinuousVariable)this.dataSet.getVariable(i);
                columnIndex = i;
                break;
            }
            if (columnIndex == -1) {
                JOptionPane.showMessageDialog(new JFrame(), "You need at least one complete continuous variable for a q-q plot!");
                throw new IllegalArgumentException("You need at least one complete continuous variable for a q-q plot!");
            }
        }
        for (i = 0; i < this.dataSet.getNumRows(); ++i) {
            double value = this.dataSet.getDouble(i, columnIndex);
            if (Double.isNaN(value) || value == Double.NEGATIVE_INFINITY || value == Double.POSITIVE_INFINITY) continue;
            mean += value;
            if (value < this.minData) {
                this.minData = value;
            }
            if (!(value > this.maxData)) continue;
            this.maxData = value;
        }
        for (i = 0; i < this.dataSet.getNumRows(); ++i) {
            for (int k = i; k < this.dataSet.getNumRows(); ++k) {
                double value1 = this.dataSet.getDouble(i, columnIndex);
                double value2 = this.dataSet.getDouble(k, columnIndex);
                if (Double.isNaN(value1) || value1 == Double.NEGATIVE_INFINITY || value1 == Double.POSITIVE_INFINITY || Double.isNaN(value2) || value2 == Double.NEGATIVE_INFINITY || value2 == Double.POSITIVE_INFINITY || !(value1 > value2)) continue;
                double temp = this.dataSet.getDouble(i, columnIndex);
                this.dataSet.setDouble(i, columnIndex, value2);
                this.dataSet.setDouble(k, columnIndex, temp);
            }
        }
        mean = mean == 0.0 ? 1.0 : (mean /= (double)this.dataSet.getNumRows());
        for (i = 0; i < this.dataSet.getNumRows(); ++i) {
            double value1 = this.dataSet.getDouble(i, columnIndex);
            double value2 = this.dataSet.getDouble(i, columnIndex);
            if (Double.isNaN(value1) || value1 == Double.NEGATIVE_INFINITY || value1 == Double.POSITIVE_INFINITY || Double.isNaN(value2) || value2 == Double.NEGATIVE_INFINITY || value2 == Double.POSITIVE_INFINITY) continue;
            sd += (value1 - mean) * (value2 - mean);
        }
        if (sd == 0.0) {
            sd = 1.0;
        } else {
            sd /= (double)this.dataSet.getNumRows() - 1.0;
            sd = Math.sqrt(sd);
        }
        this.comparison = new Normal(mean, sd, new MersenneTwister());
        this.calculateComparisonSet(this.comparison, this.dataSet);
        this.min = this.minData < this.minComparison ? this.minData : this.minComparison;
        this.max = this.maxData > this.maxComparison ? this.maxData : this.maxComparison;
    }
}

