/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetradapp.editor.DataEditor;
import edu.cmu.tetradapp.editor.EditorWindow;
import edu.cmu.tetradapp.editor.QQPlot;
import edu.cmu.tetradapp.editor.QQPlotDisplayPanel;
import edu.cmu.tetradapp.editor.QQPlotEditorPanel;
import edu.cmu.tetradapp.editor.SaveComponentImage;
import edu.cmu.tetradapp.util.DesktopController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class QQPlotAction
extends AbstractAction {
    private DataEditor dataEditor;

    public QQPlotAction(DataEditor editor) {
        super("Q-Q Plots...");
        this.dataEditor = editor;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DataSet dataSet = (DataSet)this.dataEditor.getSelectedDataModel();
        if (dataSet == null || dataSet.getNumColumns() == 0) {
            JOptionPane.showMessageDialog(this.findOwner(), "Cannot display a Q-Q plot for an empty data set.");
            return;
        }
        int[] selected = dataSet.getSelectedIndices();
        if (selected != null && 0 < selected.length) {
            int option;
            if (10 < selected.length && (option = JOptionPane.showConfirmDialog(this.findOwner(), "You are about to open " + selected.length + " Q-Q plots, are you sure you want to proceed?", "Q-Q Plot Warning", 0)) == 1) {
                return;
            }
            for (int index : selected) {
                JPanel dialog = this.createQQPlotDialog(dataSet.getVariable(index));
                EditorWindow editorWindow = new EditorWindow(dialog, "QQPlot", "Save", true, this.dataEditor);
                DesktopController.getInstance().addEditorWindow(editorWindow, JLayeredPane.PALETTE_LAYER);
                editorWindow.pack();
                editorWindow.setVisible(true);
            }
        } else {
            JPanel dialog = this.createQQPlotDialog(null);
            EditorWindow editorWindow = new EditorWindow(dialog, "QQPlot", "Save", true, this.dataEditor);
            DesktopController.getInstance().addEditorWindow(editorWindow, JLayeredPane.PALETTE_LAYER);
            editorWindow.pack();
            editorWindow.setVisible(true);
        }
    }

    private void setLocation(JDialog dialog, int index) {
        Rectangle bounds = dialog.getBounds();
        JFrame frame = this.findOwner();
        Dimension dim = frame == null ? Toolkit.getDefaultToolkit().getScreenSize() : frame.getSize();
        int x = (int)(150.0 * Math.cos((double)(index * 15) * (Math.PI / 180)));
        int y = (int)(150.0 * Math.sin((double)(index * 15) * (Math.PI / 180)));
        dialog.setLocation(x += (dim.width - bounds.width) / 2, y += (dim.height - bounds.height) / 2);
    }

    private JPanel createQQPlotDialog(Node selected) {
        String dialogTitle = "Q-Q Plots";
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        DataSet dataSet = (DataSet)this.dataEditor.getSelectedDataModel();
        QQPlot qqPlot = new QQPlot(dataSet, selected);
        QQPlotEditorPanel editorPanel = new QQPlotEditorPanel(qqPlot, dataSet);
        QQPlotDisplayPanel display = new QQPlotDisplayPanel(qqPlot);
        editorPanel.addPropertyChangeListener(new QQPlotListener(display));
        JMenuBar bar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.add(new JMenuItem(new SaveComponentImage(display, "Save Q-Q Plot")));
        bar.add(menu);
        Box box = Box.createHorizontalBox();
        box.add(display);
        box.add(Box.createHorizontalStrut(3));
        box.add(editorPanel);
        box.add(Box.createHorizontalStrut(5));
        box.add(Box.createHorizontalGlue());
        Box vBox = Box.createVerticalBox();
        vBox.add(Box.createVerticalStrut(15));
        vBox.add(box);
        vBox.add(Box.createVerticalStrut(5));
        panel.add((Component)bar, "North");
        panel.add((Component)vBox, "Center");
        return panel;
    }

    private JFrame findOwner() {
        return (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this.dataEditor);
    }

    private static class QQPlotListener
    implements PropertyChangeListener {
        private QQPlotDisplayPanel display;

        public QQPlotListener(QQPlotDisplayPanel display) {
            this.display = display;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("histogramChange".equals(evt.getPropertyName())) {
                this.display.updateQQPlot((QQPlot)evt.getNewValue());
            }
        }
    }
}

