/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.ColtDataSet;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.Variable;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetradapp.editor.DataEditor;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import javax.swing.AbstractAction;

public final class RemoveMissingValueCasesAction
extends AbstractAction {
    private DataEditor dataEditor;

    public RemoveMissingValueCasesAction(DataEditor editor) {
        super("Remove Cases with Missing Values");
        if (editor == null) {
            throw new NullPointerException();
        }
        this.dataEditor = editor;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DataModel dataModel = this.getDataEditor().getSelectedDataModel();
        DataSet dataSet = (DataSet)dataModel;
        LinkedList<Node> variables = new LinkedList<Node>();
        for (int j = 0; j < dataSet.getNumColumns(); ++j) {
            variables.add(dataSet.getVariable(j));
        }
        ColtDataSet newDataSet = new ColtDataSet(0, variables);
        int newRow = -1;
        block1: for (int i = 0; i < dataSet.getNumRows(); ++i) {
            int j;
            for (j = 0; j < dataSet.getNumColumns(); ++j) {
                Node variable = dataSet.getVariable(j);
                if (((Variable)variable).isMissingValue(dataSet.getObject(i, j))) continue block1;
            }
            ++newRow;
            for (j = 0; j < dataSet.getNumColumns(); ++j) {
                newDataSet.setObject(newRow, j, dataSet.getObject(i, j));
            }
        }
        DataModelList list = new DataModelList();
        list.add(newDataSet);
        this.getDataEditor().reset(list);
        this.getDataEditor().selectFirstTab();
    }

    private DataEditor getDataEditor() {
        return this.dataEditor;
    }
}

