/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataSet;
import java.util.Vector;

public class ScatterPlot {
    public DataSet dataSet;
    public Vector indexSet;
    public Vector complementIndexSet;
    public boolean drawRegLine = false;
    private ContinuousVariable yVariable;
    private ContinuousVariable xVariable;
    public double[] yData;
    public double[] xData;
    private double xMin;
    private double yMin;
    private double xMax;
    private double yMax;

    public ScatterPlot(DataSet dataSet, ContinuousVariable yVariable, ContinuousVariable xVariable) {
        int i;
        int i2;
        if (xVariable != null) {
            this.xVariable = xVariable;
        } else {
            for (i2 = 0; i2 < dataSet.getNumColumns(); ++i2) {
                if (!(dataSet.getVariable(i2) instanceof ContinuousVariable)) continue;
                this.xVariable = (ContinuousVariable)dataSet.getVariable(i2);
                break;
            }
        }
        if (yVariable != null) {
            this.yVariable = yVariable;
        } else {
            for (i2 = 0; i2 < dataSet.getNumColumns(); ++i2) {
                if (!(dataSet.getVariable(i2) instanceof ContinuousVariable)) continue;
                this.yVariable = (ContinuousVariable)dataSet.getVariable(i2);
                break;
            }
        }
        int yIndex = dataSet.getColumn(yVariable);
        int xIndex = dataSet.getColumn(xVariable);
        if (yIndex == -1) {
            yIndex = 0;
        }
        if (xIndex == -1) {
            xIndex = 0;
        }
        this.xData = new double[dataSet.getNumRows()];
        this.yData = new double[dataSet.getNumRows()];
        this.xMin = this.xMax = dataSet.getDouble(0, xIndex);
        this.yMin = this.yMax = dataSet.getDouble(0, yIndex);
        for (i = 0; i < dataSet.getNumRows(); ++i) {
            this.yData[i] = dataSet.getDouble(i, yIndex);
            this.xData[i] = dataSet.getDouble(i, xIndex);
            if (this.yData[i] < this.yMin) {
                this.yMin = this.yData[i];
            }
            if (this.yData[i] > this.yMax) {
                this.yMax = this.yData[i];
            }
            if (this.xData[i] < this.xMin) {
                this.xMin = this.xData[i];
            }
            if (!(this.xData[i] > this.xMax)) continue;
            this.xMax = this.xData[i];
        }
        this.dataSet = dataSet;
        this.indexSet = new Vector();
        this.complementIndexSet = new Vector();
        for (i = 0; i < dataSet.getNumRows(); ++i) {
            this.indexSet.add(i);
        }
    }

    public double getMaxSample() {
        if (this.xMax > this.yMax) {
            return this.xMax;
        }
        return this.yMax;
    }

    public double getMinSample() {
        if (this.xMin < this.yMin) {
            return this.xMin;
        }
        return this.yMin;
    }

    public ContinuousVariable getXVariable() {
        return this.xVariable;
    }

    public ContinuousVariable getYVariable() {
        return this.yVariable;
    }

    public double[] getYData() {
        return this.yData;
    }

    public double[] getXData() {
        return this.xData;
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }
}

