/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.ColtDataSet;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.regression.RegressionDataset;
import edu.cmu.tetrad.regression.RegressionResult;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.editor.DataEditor;
import edu.cmu.tetradapp.editor.ScatterPlot;
import edu.cmu.tetradapp.model.RegressionParams;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Ellipse2D;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JPanel;

public class ScatterPlotDisplayPanel
extends JPanel {
    private static Color LINE_COLOR = Color.GRAY.darker();
    private DataEditor dataEditor;
    private static final int PADDING = 50;
    private static final int HEIGHT = 650;
    private static final int DISPLAYED_HEIGHT = 650;
    private static final int WIDTH = 650;
    private static final int SPACE = 2;
    private static final int DASH = 10;
    private Dimension size = new Dimension(654, 650);
    private NumberFormat format = NumberFormatUtil.getInstance().getNumberFormat();
    private ScatterPlot scatterPlot;
    private String displayString;
    private Map<Rectangle, Integer> rectMap = new ConcurrentHashMap<Rectangle, Integer>();

    public ScatterPlotDisplayPanel(ScatterPlot scatterPlot, DataEditor dataEditor) {
        this.scatterPlot = scatterPlot;
        this.dataEditor = dataEditor;
        if (scatterPlot == null) {
            throw new NullPointerException("Given scatter plot must be null");
        }
        this.addMouseMotionListener(new MouseMovementListener());
        this.setToolTipText(" ");
    }

    public synchronized void updateScatterPlot(ScatterPlot scatterPlot) {
        if (scatterPlot == null) {
            throw new NullPointerException("The given scatter plot must not be null");
        }
        this.displayString = null;
        this.scatterPlot = scatterPlot;
        this.repaint();
    }

    @Override
    public String getToolTipText(MouseEvent evt) {
        return null;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        this.rectMap.clear();
        Graphics2D g2d = (Graphics2D)graphics;
        int height = 600;
        FontMetrics fontMetrics = g2d.getFontMetrics();
        g2d.setColor(this.getBackground());
        g2d.fillRect(0, 0, 654, 650);
        g2d.setColor(Color.WHITE);
        g2d.fillRect(50, 0, 602, height);
        g2d.setColor(LINE_COLOR);
        g2d.drawRect(50, 0, 602, height);
        g2d.setColor(LINE_COLOR);
        g2d.drawString(this.format.format(Math.floor(this.scatterPlot.getMinSample())), 55, height + 15);
        g2d.drawLine(50, height + 10, 50, height);
        String maxStr = this.format.format((int)Math.ceil(this.scatterPlot.getMaxSample()));
        g2d.drawString(maxStr, 650 - fontMetrics.stringWidth(maxStr), height + 15);
        g2d.drawLine(652, height + 10, 652, height);
        int size = 150;
        g2d.setColor(LINE_COLOR);
        int topY = 0;
        String top = "" + Math.ceil(this.scatterPlot.getMaxSample());
        g2d.drawString(top, 50 - fontMetrics.stringWidth(top), topY + 10);
        g2d.drawLine(40, topY, 50, topY);
        g2d.drawString(Math.floor(this.scatterPlot.getMinSample()) + "", 50 - fontMetrics.stringWidth(Math.floor(this.scatterPlot.getMinSample()) + ""), height - 2);
        g2d.drawLine(40, height, 50, height);
        if (this.scatterPlot.getMinSample() < 0.0 && this.scatterPlot.getMaxSample() > 0.0) {
            double[] originLeft = this.plotPoint(Math.floor(this.scatterPlot.getMinSample()), 0.0, Math.floor(this.scatterPlot.getMinSample()), Math.ceil(this.scatterPlot.getMaxSample()));
            double[] originRight = this.plotPoint(Math.ceil(this.scatterPlot.getMaxSample()), 0.0, Math.floor(this.scatterPlot.getMinSample()), Math.ceil(this.scatterPlot.getMaxSample()));
            double[] originTop = this.plotPoint(0.0, Math.floor(this.scatterPlot.getMinSample()), Math.floor(this.scatterPlot.getMinSample()), Math.ceil(this.scatterPlot.getMaxSample()));
            double[] originBottom = this.plotPoint(0.0, Math.ceil(this.scatterPlot.getMaxSample()), Math.floor(this.scatterPlot.getMinSample()), Math.ceil(this.scatterPlot.getMaxSample()));
            g2d.drawLine((int)originLeft[0] + 2, (int)originLeft[1] + 2, (int)originRight[0] + 2, (int)originRight[1] + 2);
            g2d.drawLine((int)originTop[0] + 2, (int)originTop[1] + 2, (int)originBottom[0] + 2, (int)originBottom[1] + 2);
        }
        g2d.setColor(new Color(255, 0, 0));
        for (Object o : this.scatterPlot.indexSet) {
            int i = (Integer)o;
            double x = this.scatterPlot.xData[i];
            double y = this.scatterPlot.yData[i];
            double[] result = this.plotPoint(x, y, Math.floor(this.scatterPlot.getMinSample()), Math.ceil(this.scatterPlot.getMaxSample()));
            g2d.fill(new Ellipse2D.Double(result[0], result[1], 4.0, 4.0));
        }
        if (this.scatterPlot.drawRegLine) {
            RegressionDataset regData;
            RegressionParams params = new RegressionParams();
            Vector<String> regressors = new Vector<String>();
            regressors.add(this.scatterPlot.getXVariable().getName());
            params.setTargetName(this.scatterPlot.getYVariable().getName());
            if (this.scatterPlot.indexSet.size() != this.scatterPlot.dataSet.getNumRows()) {
                ColtDataSet newDataSet = new ColtDataSet((ColtDataSet)this.scatterPlot.dataSet);
                int[] throwAway = new int[this.scatterPlot.complementIndexSet.size()];
                for (int j = 0; j < throwAway.length; ++j) {
                    throwAway[j] = (Integer)this.scatterPlot.complementIndexSet.get(j);
                }
                newDataSet.removeRows(throwAway);
                regData = new RegressionDataset(newDataSet);
            } else {
                regData = new RegressionDataset(this.scatterPlot.dataSet);
            }
            RegressionResult regResult = regData.regress((Node)this.scatterPlot.getYVariable(), this.scatterPlot.getXVariable());
            double[] coef = regResult.getCoef();
            double[] regLeft = this.plotPoint(Math.floor(this.scatterPlot.getMinSample()), coef[0] + coef[1] * Math.floor(this.scatterPlot.getMinSample()), Math.floor(this.scatterPlot.getMinSample()), Math.ceil(this.scatterPlot.getMaxSample()));
            double[] regRight = this.plotPoint(Math.ceil(this.scatterPlot.getMaxSample()), coef[0] + coef[1] * Math.ceil(this.scatterPlot.getMaxSample()), Math.floor(this.scatterPlot.getMinSample()), Math.ceil(this.scatterPlot.getMaxSample()));
            g2d.setColor(LINE_COLOR);
            g2d.drawLine((int)regLeft[0] + 2, (int)regLeft[1] + 2, (int)regRight[0] + 2, (int)regRight[1] + 2);
        }
        g2d.setColor(LINE_COLOR);
        g2d.drawString(this.getDisplayString(), 50, 645);
    }

    private String getDisplayString() {
        if (this.displayString == null) {
            this.displayString = "Showing: " + this.scatterPlot.getYVariable().getName();
        }
        return this.displayString;
    }

    public double[] plotPoint(double x, double y, double minRange, double maxRange) {
        double[] result = new double[2];
        double range = maxRange - minRange;
        result[0] = 600.0 * ((x - minRange) / range) - 2.0 + 50.0;
        result[1] = 650.0 - 600.0 * ((y - minRange) / range) - 2.0 - 50.0;
        return result;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.size;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.size;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.size;
    }

    private static int getMax(int[] freqs) {
        int max = freqs[0];
        for (int i = 1; i < freqs.length; ++i) {
            int current = freqs[i];
            if (max >= current) continue;
            max = current;
        }
        return max;
    }

    private class MouseMovementListener
    implements MouseMotionListener {
        private MouseMovementListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Rectangle rect;
            Point point = e.getPoint();
            Iterator i$ = ScatterPlotDisplayPanel.this.rectMap.keySet().iterator();
            while (i$.hasNext() && !(rect = (Rectangle)i$.next()).contains(point)) {
            }
        }
    }
}

