/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.KnowledgeBoxInput;
import edu.cmu.tetrad.data.VariableSource;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.model.Params;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.editor.EditorWindow;
import edu.cmu.tetradapp.editor.ParameterEditor;
import edu.cmu.tetradapp.knowledge_editor.KnowledgeEditor;
import edu.cmu.tetradapp.model.BasicSearchParams;
import edu.cmu.tetradapp.model.DagWrapper;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GraphWrapper;
import edu.cmu.tetradapp.model.IndTestFactory;
import edu.cmu.tetradapp.model.SearchParams;
import edu.cmu.tetradapp.model.SemGraphWrapper;
import edu.cmu.tetradapp.util.DesktopController;
import edu.cmu.tetradapp.util.DoubleTextField;
import edu.cmu.tetradapp.util.IntTextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.border.MatteBorder;

public final class SearchParamEditor
extends JPanel
implements ParameterEditor {
    private BasicSearchParams params;
    private DoubleTextField alphaField;
    private Object[] parentModels;
    private List varNames;

    @Override
    public void setParams(Params params) {
        if (params == null) {
            throw new NullPointerException();
        }
        this.params = (BasicSearchParams)params;
    }

    @Override
    public void setParentModels(Object[] parentModels) {
        if (parentModels == null) {
            throw new NullPointerException();
        }
        this.parentModels = parentModels;
    }

    @Override
    public void setup() {
        this.varNames = this.params.getVarNames();
        for (Object parentModel : this.parentModels) {
            KnowledgeBoxInput wrapper;
            if (parentModel instanceof DataWrapper) {
                wrapper = (DataWrapper)parentModel;
                DataModel dataModel = ((DataWrapper)wrapper).getSelectedDataModel();
                new IndTestFactory().adjustIndTestParams(dataModel, this.params);
                break;
            }
            if (parentModel instanceof GraphWrapper) {
                wrapper = (GraphWrapper)parentModel;
                new IndTestFactory().adjustIndTestParams(((GraphWrapper)wrapper).getGraph(), this.params);
                break;
            }
            if (parentModel instanceof DagWrapper) {
                wrapper = (DagWrapper)parentModel;
                new IndTestFactory().adjustIndTestParams(((DagWrapper)wrapper).getGraph(), this.params);
                break;
            }
            if (!(parentModel instanceof SemGraphWrapper)) continue;
            wrapper = (SemGraphWrapper)parentModel;
            new IndTestFactory().adjustIndTestParams(((SemGraphWrapper)wrapper).getGraph(), this.params);
            break;
        }
        VariableSource dataModel1 = null;
        Graph graph = null;
        for (Object parentModel1 : this.parentModels) {
            if (parentModel1 instanceof DataWrapper) {
                DataWrapper dataWrapper = (DataWrapper)parentModel1;
                dataModel1 = dataWrapper.getSelectedDataModel();
            }
            if (parentModel1 instanceof GraphWrapper) {
                GraphWrapper graphWrapper = (GraphWrapper)parentModel1;
                graph = graphWrapper.getGraph();
            }
            if (parentModel1 instanceof DagWrapper) {
                DagWrapper dagWrapper = (DagWrapper)parentModel1;
                graph = dagWrapper.getDag();
            }
            if (!(parentModel1 instanceof SemGraphWrapper)) continue;
            SemGraphWrapper semGraphWrapper = (SemGraphWrapper)parentModel1;
            graph = semGraphWrapper.getGraph();
        }
        if (dataModel1 != null) {
            this.varNames = new ArrayList<String>(dataModel1.getVariableNames());
        } else if (graph != null) {
            Iterator<Node> it = graph.getNodes().iterator();
            this.varNames = new ArrayList();
            while (it.hasNext()) {
                Node temp = it.next();
                if (temp.getNodeType() != NodeType.MEASURED) continue;
                this.varNames.add(temp.getName());
            }
        } else {
            throw new NullPointerException("Null model (no graph or data model passed to the search).");
        }
        this.params.setVarNames(this.varNames);
        JButton knowledgeButton = new JButton("Edit");
        IntTextField depthField = new IntTextField(this.params.getIndTestParams().getDepth(), 4);
        depthField.setFilter(new IntTextField.Filter(){

            @Override
            public int filter(int value, int oldValue) {
                try {
                    SearchParamEditor.this.params.getIndTestParams().setDepth(value);
                    Preferences.userRoot().putInt("depth", value);
                    return value;
                }
                catch (Exception e) {
                    return oldValue;
                }
            }
        });
        double alpha = this.params.getIndTestParams().getAlpha();
        if (!Double.isNaN(alpha)) {
            this.alphaField = new DoubleTextField(alpha, 4, NumberFormatUtil.getInstance().getNumberFormat());
            this.alphaField.setFilter(new DoubleTextField.Filter(){

                @Override
                public double filter(double value, double oldValue) {
                    try {
                        SearchParamEditor.this.params.getIndTestParams().setAlpha(value);
                        Preferences.userRoot().putDouble("alpha", value);
                        return value;
                    }
                    catch (Exception e) {
                        return oldValue;
                    }
                }
            });
        }
        this.setBorder(new MatteBorder(10, 10, 10, 10, super.getBackground()));
        this.setLayout(new BoxLayout(this, 1));
        Box b2 = Box.createHorizontalBox();
        b2.add(new JLabel("Knowledge:"));
        b2.add(Box.createGlue());
        b2.add(knowledgeButton);
        this.add(b2);
        this.add(Box.createVerticalStrut(10));
        if (!Double.isNaN(alpha)) {
            Box b0 = Box.createHorizontalBox();
            b0.add(new JLabel("Alpha Value:"));
            b0.add(Box.createGlue());
            b0.add(this.alphaField);
            this.add(b0);
            this.add(Box.createVerticalStrut(10));
        }
        Box b1 = Box.createHorizontalBox();
        b1.add(new JLabel("Search Depth:"));
        b1.add(Box.createGlue());
        b1.add(depthField);
        this.add(b1);
        this.add(Box.createVerticalStrut(10));
        knowledgeButton.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                SearchParamEditor.this.openKnowledgeEditor();
            }
        });
    }

    @Override
    public boolean mustBeShown() {
        return false;
    }

    private void openKnowledgeEditor() {
        if (this.getParams() == null) {
            throw new NullPointerException("Parameter object must not be null if you want to launch a OldKnowledgeEditor.");
        }
        Knowledge knowledge = this.getParams().getKnowledge();
        KnowledgeEditor knowledgeEditor = new KnowledgeEditor(knowledge, this.varNames, this.params.getSourceGraph());
        EditorWindow window = new EditorWindow(knowledgeEditor, knowledgeEditor.getName(), "Save", false, this);
        DesktopController.getInstance().addEditorWindow(window, JLayeredPane.PALETTE_LAYER);
        window.setVisible(true);
    }

    private SearchParams getParams() {
        return this.params;
    }
}

