/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetradapp.workbench.DisplayEdge;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.Component;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

class SelectBidirectedAction
extends AbstractAction
implements ClipboardOwner {
    private GraphWorkbench workbench;

    public SelectBidirectedAction(GraphWorkbench workbench) {
        super("Highlight Bidirected Edges");
        if (workbench == null) {
            throw new NullPointerException("Desktop must not be null.");
        }
        this.workbench = workbench;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.workbench.deselectAll();
        for (Component comp : this.workbench.getComponents()) {
            Edge edge;
            if (!(comp instanceof DisplayEdge) || !Edges.isBidirectedEdge(edge = ((DisplayEdge)comp).getModelEdge())) continue;
            this.workbench.selectEdge(edge);
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

