/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.model.Params;
import edu.cmu.tetradapp.editor.ParameterEditor;
import edu.cmu.tetradapp.model.SemDataParams;
import edu.cmu.tetradapp.util.IntTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class SemDataParamsEditor
extends JPanel
implements ParameterEditor {
    private transient SemDataParams params = null;

    @Override
    public void setParams(Params params) {
        if (params == null) {
            throw new NullPointerException();
        }
        this.params = (SemDataParams)params;
    }

    @Override
    public void setParentModels(Object[] parentModels) {
    }

    @Override
    public void setup() {
        IntTextField sampleSizeField = new IntTextField(this.getParams().getSampleSize(), 8);
        sampleSizeField.setFilter(new IntTextField.Filter(){

            @Override
            public int filter(int value, int oldValue) {
                try {
                    SemDataParamsEditor.this.getParams().setSampleSize(value);
                    return value;
                }
                catch (Exception e) {
                    return oldValue;
                }
            }
        });
        JCheckBox latentDataSaved = new JCheckBox("Include Latent Variables", this.getParams().isIncludeLatents());
        latentDataSaved.setHorizontalTextPosition(2);
        latentDataSaved.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox b = (JCheckBox)e.getSource();
                SemDataParamsEditor.this.getParams().setIncludeLatents(b.isSelected());
            }
        });
        JCheckBox positiveOnlyBox = new JCheckBox("Positive Data Only", this.getParams().isPositiveDataOnly());
        positiveOnlyBox.setHorizontalTextPosition(2);
        positiveOnlyBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox b = (JCheckBox)e.getSource();
                SemDataParamsEditor.this.getParams().setPositiveDataOnly(b.isSelected());
            }
        });
        this.setLayout(new BorderLayout());
        Box b = Box.createVerticalBox();
        Box b1 = Box.createHorizontalBox();
        b1.add(new JLabel("Sample size:  "));
        b1.add(Box.createHorizontalGlue());
        b1.add(sampleSizeField);
        b.add(b1);
        Box b2 = Box.createHorizontalBox();
        b2.add(latentDataSaved);
        b.add(b2);
        Box b3 = Box.createHorizontalBox();
        b3.add(positiveOnlyBox);
        b.add(b3);
        this.add((Component)b, "Center");
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
    }

    @Override
    public boolean mustBeShown() {
        return true;
    }

    private synchronized SemDataParams getParams() {
        return this.params;
    }
}

