/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.sem.SemEstimator;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemOptimizer;
import edu.cmu.tetrad.sem.SemOptimizerEm;
import edu.cmu.tetrad.sem.SemOptimizerNrPowell;
import edu.cmu.tetrad.sem.SemOptimizerPalCds;
import edu.cmu.tetrad.sem.SemOptimizerRegression;
import edu.cmu.tetrad.sem.SemOptimizerScattershot;
import edu.cmu.tetrad.sem.SemOptimizerUncmin;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetradapp.editor.SemImEditor;
import edu.cmu.tetradapp.model.SemEstimatorWrapper;
import edu.cmu.tetradapp.util.WatchedProcess;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class SemEstimatorEditor
extends JPanel {
    private static SemEstimatorWrapper wrapper;
    private JPanel editorPanel;
    private JComboBox optimizerCombo;

    public SemEstimatorEditor(SemEstimatorWrapper _wrapper) {
        wrapper = _wrapper;
        this.editorPanel = new JPanel();
        this.editorPanel.setLayout(new BorderLayout());
        this.setLayout(new BorderLayout());
        this.add((Component)this.editorPanel, "Center");
        this.optimizerCombo = new JComboBox();
        this.optimizerCombo.addItem("Regression");
        this.optimizerCombo.addItem("EM");
        this.optimizerCombo.addItem("CDS");
        this.optimizerCombo.addItem("Random Search");
        this.optimizerCombo.setMaximumSize(new Dimension(200, 25));
        SemOptimizer optimizer = wrapper.getSemOptimizer();
        String selection = optimizer instanceof SemOptimizerRegression ? "Regression" : (optimizer instanceof SemOptimizerEm ? "EM" : (optimizer instanceof SemOptimizerScattershot ? "Random Search" : (optimizer instanceof SemOptimizerPalCds ? "CDS" : (optimizer instanceof SemOptimizerNrPowell ? "Powell" : (optimizer instanceof SemOptimizerUncmin ? "Uncmin" : "CDS")))));
        this.optimizerCombo.setSelectedItem(selection);
        JButton estimateButton = new JButton("Estimate Again");
        estimateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window owner = (Window)SemEstimatorEditor.this.getTopLevelAncestor();
                new WatchedProcess(owner){

                    @Override
                    public void watch() {
                        SemEstimatorEditor.this.reestimate();
                    }
                };
            }
        });
        Box lowerBar = Box.createHorizontalBox();
        lowerBar.add(Box.createHorizontalGlue());
        lowerBar.add(new JLabel("Choose Optimizer:  "));
        lowerBar.add(this.optimizerCombo);
        lowerBar.add(Box.createHorizontalStrut(10));
        lowerBar.add(estimateButton);
        this.add((Component)lowerBar, "South");
        this.resetSemImEditor();
    }

    private void reestimate() {
        SemEstimator newEstimator;
        SemOptimizer optimizer;
        Object type = this.optimizerCombo.getSelectedItem();
        if ("Regression".equals(type)) {
            optimizer = new SemOptimizerRegression();
        } else if ("EM".equals(type)) {
            optimizer = new SemOptimizerEm();
        } else if ("CDS".equals(type)) {
            optimizer = new SemOptimizerPalCds();
        } else if ("Random Search".equals(type)) {
            optimizer = new SemOptimizerScattershot();
        } else if ("Powell".equals(type)) {
            optimizer = new SemOptimizerNrPowell();
        } else if ("Uncmin".equals(type)) {
            optimizer = new SemOptimizerUncmin();
        } else {
            throw new IllegalArgumentException("Unexpected optimizer type: " + type);
        }
        SemEstimator estimator = wrapper.getSemEstimator();
        SemPm semPm = estimator.getSemPm();
        DataSet dataSet = estimator.getDataSet();
        CovarianceMatrix covMatrix = estimator.getCovMatrix();
        if (dataSet != null) {
            newEstimator = new SemEstimator(dataSet, semPm, optimizer);
        } else if (covMatrix != null) {
            newEstimator = new SemEstimator(covMatrix, semPm, optimizer);
        } else {
            throw new IllegalStateException("Only continuous rectangular data sets or covariance matrices can be processed.");
        }
        newEstimator.estimate();
        wrapper.setSemEstimator(newEstimator);
        this.resetSemImEditor();
    }

    private void resetSemImEditor() {
        SemIm estimatedSem = wrapper.getEstimatedSemIm();
        SemImEditor editor = new SemImEditor(estimatedSem);
        this.editorPanel.removeAll();
        this.editorPanel.add((Component)editor, "Center");
        this.editorPanel.revalidate();
        this.editorPanel.repaint();
    }
}

