/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.sem.SemEvidence;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.util.DoubleTextField;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

class SemEvidenceEditor
extends JPanel {
    private SemEvidence evidence;
    private Map checkBoxesToVariables = new HashMap();
    private Map variablesToCheckboxes = new HashMap();

    public SemEvidenceEditor(SemEvidence evidence) {
        if (evidence == null) {
            throw new NullPointerException();
        }
        this.evidence = evidence;
        this.setLayout(new BoxLayout(this, 1));
        Box d = Box.createHorizontalBox();
        d.add(new JLabel("Variable = value"));
        d.add(Box.createHorizontalGlue());
        d.add(new JLabel("Manipulated"));
        this.add(d);
        for (int i = 0; i < evidence.getNumNodes(); ++i) {
            Box c = Box.createHorizontalBox();
            SemIm semIm = evidence.getSemIm();
            String name = semIm.getVariableNodes().get(i).getName();
            JLabel label = new JLabel(name + " =  "){

                @Override
                public Dimension getMaximumSize() {
                    return this.getPreferredSize();
                }
            };
            c.add(label);
            DoubleTextField field = new DoubleTextField(evidence.getProposition().getValue(i), 5, NumberFormatUtil.getInstance().getNumberFormat());
            c.add(field);
            c.add(Box.createHorizontalStrut(2));
            c.add(Box.createHorizontalGlue());
            JCheckBox checkbox = new JCheckBox(){

                @Override
                public Dimension getMaximumSize() {
                    return this.getPreferredSize();
                }
            };
            checkbox.setSelected(this.getEvidence().isManipulated(i));
            this.checkBoxesToVariables.put(checkbox, i);
            this.variablesToCheckboxes.put(i, checkbox);
            checkbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JCheckBox checkbox = (JCheckBox)e.getSource();
                    boolean selected = checkbox.isSelected();
                    Object o = SemEvidenceEditor.this.checkBoxesToVariables.get(checkbox);
                    int variable = (Integer)o;
                    SemEvidenceEditor.this.getEvidence().setManipulated(variable, selected);
                }
            });
            checkbox.setBackground(Color.WHITE);
            checkbox.setBorder(null);
            c.add(checkbox);
            c.setMaximumSize(new Dimension(1000, 30));
            this.add(c);
        }
    }

    public SemEvidence getEvidence() {
        return this.evidence;
    }
}

