/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.SemGraph;
import edu.cmu.tetrad.sem.ISemIm;
import edu.cmu.tetrad.sem.ParamType;
import edu.cmu.tetrad.sem.Parameter;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.editor.SemImEditor;
import edu.cmu.tetradapp.util.DoubleTextField;
import edu.cmu.tetradapp.workbench.DisplayNode;
import edu.cmu.tetradapp.workbench.GraphNodeMeasured;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;
import javax.swing.border.TitledBorder;

final class SemImGraphicalEditor
extends JPanel {
    private static Font SMALL_FONT = new Font("Dialog", 0, 10);
    private static Color LIGHT_YELLOW = new Color(255, 255, 215);
    private ISemIm semIm;
    private GraphWorkbench workbench;
    private Object lastEditedObject = null;
    private int savedTooltipDelay = 0;
    private SemImEditor editor = null;
    private int maxFreeParamsForStatistics;
    private boolean editable = true;

    public SemImGraphicalEditor(ISemIm semIm, SemImEditor editor, int maxFreeParamsForStatistics) {
        this.semIm = semIm;
        this.editor = editor;
        this.maxFreeParamsForStatistics = maxFreeParamsForStatistics;
        this.setLayout(new BorderLayout());
        JScrollPane scroll = new JScrollPane(this.workbench());
        scroll.setPreferredSize(new Dimension(450, 450));
        this.add((Component)scroll, "Center");
        this.setBorder(new TitledBorder("Click parameter values to edit"));
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        this.setSavedTooltipDelay(toolTipManager.getInitialDelay());
        this.workbench().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                SemImGraphicalEditor.this.resetLabels();
                ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
                toolTipManager.setInitialDelay(100);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
                toolTipManager.setInitialDelay(SemImGraphicalEditor.this.getSavedTooltipDelay());
            }
        });
        this.workbench().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (SemImGraphicalEditor.this.workbench().contains(e.getPoint())) {
                    ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
                    toolTipManager.setInitialDelay(100);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (!SemImGraphicalEditor.this.workbench().contains(e.getPoint())) {
                    ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
                    toolTipManager.setInitialDelay(SemImGraphicalEditor.this.getSavedTooltipDelay());
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                SemImGraphicalEditor.this.resetLabels();
            }
        });
    }

    private void beginEdgeEdit(final Edge edge) {
        this.finishEdit();
        if (!this.isEditable()) {
            return;
        }
        Parameter parameter = this.getEdgeParameter(edge);
        double d = this.semIm().getParamValue(parameter);
        if (this.editor.isEditCovariancesAsCorrelations() && parameter.getType() == ParamType.COVAR) {
            Node nodeA = parameter.getNodeA();
            Node nodeB = parameter.getNodeB();
            double varA = this.semIm().getParamValue(nodeA, nodeA);
            double varB = this.semIm().getParamValue(nodeB, nodeB);
            d /= Math.sqrt(varA * varB);
        }
        DoubleTextField doubleTextField = new DoubleTextField(d, 7, NumberFormatUtil.getInstance().getNumberFormat());
        doubleTextField.setPreferredSize(new Dimension(60, 20));
        doubleTextField.addActionListener(new EdgeActionListener(this, edge));
        doubleTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                DoubleTextField field = (DoubleTextField)e.getSource();
                String s = field.getText();
                SemImGraphicalEditor.this.setEdgeValue(edge, s);
            }
        });
        Box b1 = Box.createHorizontalBox();
        b1.add(new JLabel(parameter.getName() + " = "));
        b1.add(doubleTextField);
        Box b2 = Box.createHorizontalBox();
        JPanel editPanel = new JPanel();
        editPanel.setLayout(new BoxLayout(editPanel, 1));
        editPanel.setBackground(LIGHT_YELLOW);
        editPanel.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        editPanel.add(b1);
        editPanel.add(Box.createVerticalStrut(5));
        editPanel.add(b2);
        this.workbench().setEdgeLabel(edge, editPanel);
        this.setLastEditedObject(edge);
        this.workbench().repaint();
        doubleTextField.grabFocus();
        doubleTextField.selectAll();
    }

    private void beginNodeEdit(Node node) {
        String prefix;
        double d;
        this.finishEdit();
        if (!this.isEditable()) {
            return;
        }
        Parameter parameter = this.getNodeParameter(node);
        if (this.editor.isEditCovariancesAsCorrelations() && parameter.getType() == ParamType.VAR) {
            return;
        }
        String postfix = "";
        if (parameter.getType() == ParamType.MEAN) {
            if (this.editor.isEditIntercepts()) {
                d = this.semIm().getIntercept(node);
                prefix = "B0_" + node.getName() + " = ";
            } else {
                d = this.semIm().getMean(node);
                prefix = "Mean(" + node.getName() + ") = ";
            }
        } else {
            d = Math.sqrt(this.semIm().getParamValue(parameter));
            prefix = node.getName() + " ~ N(0,";
            postfix = ")";
        }
        DoubleTextField field = new DoubleTextField(d, 7, NumberFormatUtil.getInstance().getNumberFormat());
        field.setPreferredSize(new Dimension(60, 20));
        field.addActionListener(new NodeActionListener(this, node));
        field.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                DoubleTextField field = (DoubleTextField)e.getSource();
                field.grabFocus();
            }
        });
        JLabel instruct = new JLabel("Press Enter when done");
        instruct.setFont(SMALL_FONT);
        instruct.setForeground(Color.GRAY);
        Box b1 = Box.createHorizontalBox();
        b1.add(new JLabel(prefix));
        b1.add(field);
        b1.add(new JLabel(postfix));
        Box b2 = Box.createHorizontalBox();
        b2.add(instruct);
        JPanel editPanel = new JPanel();
        editPanel.setLayout(new BoxLayout(editPanel, 1));
        editPanel.setBackground(LIGHT_YELLOW);
        editPanel.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        editPanel.add(b1);
        editPanel.add(Box.createVerticalStrut(5));
        editPanel.add(b2);
        this.workbench().setNodeLabel(node, editPanel, 15, 2);
        this.setLastEditedObject(node);
        this.workbench().repaint();
        field.grabFocus();
        field.selectAll();
    }

    private void finishEdit() {
        if (this.lastEditedObject() != null) {
            Object o = this.lastEditedObject();
            this.resetLabels();
        }
    }

    private ISemIm semIm() {
        return this.semIm;
    }

    private Graph graph() {
        return this.semIm().getSemPm().getGraph();
    }

    private GraphWorkbench workbench() {
        if (this.getWorkbench() == null) {
            this.workbench = new GraphWorkbench(this.graph());
            this.getWorkbench().setAllowDoubleClickActions(false);
            this.getWorkbench().addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("BackgroundClicked".equals(evt.getPropertyName())) {
                        SemImGraphicalEditor.this.finishEdit();
                    }
                }
            });
            this.resetLabels();
            this.addMouseListenerToGraphNodesMeasured();
        }
        return this.getWorkbench();
    }

    private void setLastEditedObject(Object o) {
        this.lastEditedObject = o;
    }

    private Object lastEditedObject() {
        return this.lastEditedObject;
    }

    public void resetLabels() {
        for (Edge o : this.graph().getEdges()) {
            this.resetEdgeLabel(o);
        }
        List<Node> nodes = this.graph().getNodes();
        for (Node node : nodes) {
            this.resetNodeLabel(node);
        }
        this.workbench().repaint();
    }

    private void resetEdgeLabel(Edge edge) {
        Parameter parameter = this.getEdgeParameter(edge);
        if (parameter != null) {
            double val = this.semIm().getParamValue(parameter);
            double standardError = this.semIm().getStandardError(parameter, this.maxFreeParamsForStatistics);
            double tValue = this.semIm().getTValue(parameter, this.maxFreeParamsForStatistics);
            double pValue = this.semIm().getPValue(parameter, this.maxFreeParamsForStatistics);
            if (this.editor.isEditCovariancesAsCorrelations() && parameter.getType() == ParamType.COVAR) {
                Node nodeA = edge.getNode1();
                Node nodeB = edge.getNode2();
                double varA = this.semIm().getVariance(nodeA);
                double varB = this.semIm().getVariance(nodeB);
                val /= Math.sqrt(varA * varB);
            }
            JLabel label = new JLabel();
            if (parameter.getType() == ParamType.COVAR) {
                label.setForeground(Color.GREEN.darker().darker());
            }
            if (parameter.isFixed()) {
                label.setForeground(Color.RED);
            }
            label.setBackground(Color.white);
            label.setOpaque(true);
            label.setFont(SMALL_FONT);
            label.setText(" " + this.asString(val) + " ");
            label.setToolTipText(parameter.getName() + " = " + this.asString(val));
            label.addMouseListener(new EdgeMouseListener(edge, this));
            if (this.semIm().isEstimated()) {
                label.setToolTipText("SE=" + this.asString(standardError) + ", T=" + this.asString(tValue) + ", P=" + this.asString(pValue));
            }
            this.workbench().setEdgeLabel(edge, label);
        } else {
            this.workbench().setEdgeLabel(edge, null);
        }
    }

    private void resetNodeLabel(Node node) {
        Parameter parameter = this.semIm().getSemPm().getVarianceParameter(node);
        double meanOrIntercept = Double.NaN;
        JLabel label = new JLabel();
        label.setBackground(Color.WHITE);
        label.addMouseListener(new NodeMouseListener(node, this));
        label.setFont(SMALL_FONT);
        String tooltip = "";
        NodeType nodeType = node.getNodeType();
        if (nodeType == NodeType.MEASURED || nodeType == NodeType.LATENT) {
            meanOrIntercept = this.editor.isEditIntercepts() ? this.semIm().getIntercept(node) : this.semIm().getMean(node);
        }
        double stdDev = this.semIm().getStdDev(node);
        if (this.editor.isEditCovariancesAsCorrelations() && !Double.isNaN(stdDev)) {
            stdDev = 1.0;
        }
        if (parameter != null) {
            double standardError = this.semIm().getStandardError(parameter, this.maxFreeParamsForStatistics);
            double tValue = this.semIm().getTValue(parameter, this.maxFreeParamsForStatistics);
            double pValue = this.semIm().getPValue(parameter, this.maxFreeParamsForStatistics);
            tooltip = "SE=" + this.asString(standardError) + ", T=" + this.asString(tValue) + ", P=" + this.asString(pValue);
        }
        if (!Double.isNaN(meanOrIntercept)) {
            label.setForeground(Color.GREEN.darker());
            label.setText(this.asString(meanOrIntercept));
            tooltip = this.editor.isEditIntercepts() ? "<html>B0_" + node.getName() + " = " + this.asString(meanOrIntercept) + "</html>" : "<html>Mean(" + node.getName() + ") = " + this.asString(meanOrIntercept) + "</html>";
        } else if (!this.editor.isEditCovariancesAsCorrelations() && !Double.isNaN(stdDev)) {
            label.setForeground(Color.BLUE);
            label.setText(this.asString(stdDev));
            tooltip = "<html>" + node.getName() + " ~ N(0," + this.asString(stdDev) + ")" + "<br><br>" + tooltip + "</html>";
        } else if (this.editor.isEditCovariancesAsCorrelations()) {
            label.setForeground(Color.GRAY);
            label.setText(this.asString(stdDev));
        }
        if (parameter != null && parameter.isFixed()) {
            label.setForeground(Color.RED);
        }
        label.setToolTipText(tooltip);
        if (nodeType == NodeType.ERROR) {
            label.setOpaque(false);
            this.workbench().setNodeLabel(node, label, 15, 2);
        } else {
            label.setOpaque(true);
            this.workbench().setNodeLabel(node, label, 31, 4);
        }
    }

    private Parameter getNodeParameter(Node node) {
        Parameter parameter = this.semIm().getSemPm().getMeanParameter(node);
        if (parameter == null) {
            parameter = this.semIm().getSemPm().getVarianceParameter(node);
        }
        return parameter;
    }

    public Parameter getEdgeParameter(Edge edge) {
        if (Edges.isDirectedEdge(edge)) {
            return this.semIm().getSemPm().getCoefficientParameter(edge.getNode1(), edge.getNode2());
        }
        if (Edges.isBidirectedEdge(edge)) {
            return this.semIm().getSemPm().getCovarianceParameter(edge.getNode1(), edge.getNode2());
        }
        throw new IllegalArgumentException("This is not a directed or bidirected edge: " + edge);
    }

    private void setEdgeValue(Edge edge, String text) {
        try {
            Parameter parameter = this.getEdgeParameter(edge);
            double d = new Double(text);
            if (this.editor.isEditCovariancesAsCorrelations() && parameter.getType() == ParamType.COVAR) {
                Node nodeA = edge.getNode1();
                Node nodeB = edge.getNode2();
                double varA = this.semIm().getVariance(nodeA);
                double varB = this.semIm().getVariance(nodeB);
                this.semIm().setParamValue(parameter, d *= Math.sqrt(varA * varB));
                this.firePropertyChange("modelChanged", null, null);
            } else if (!this.editor.isEditCovariancesAsCorrelations() && parameter.getType() == ParamType.COVAR) {
                this.semIm().setParamValue(parameter, d);
                this.firePropertyChange("modelChanged", null, null);
            } else if (parameter.getType() == ParamType.COEF) {
                Node x = parameter.getNodeA();
                Node y = parameter.getNodeB();
                this.semIm.setEdgeCoef(x, y, d);
                if (this.editor.isEditIntercepts()) {
                    double intercept = this.semIm.getIntercept(y);
                    this.semIm.setIntercept(y, intercept);
                }
                this.firePropertyChange("modelChanged", null, null);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.resetLabels();
        this.workbench().repaint();
        this.setLastEditedObject(null);
    }

    private void setNodeValue(Node node, String text) {
        try {
            Parameter parameter = this.getNodeParameter(node);
            double d = new Double(text);
            if (parameter.getType() == ParamType.VAR && d >= 0.0) {
                this.semIm().setParamValue(node, node, d * d);
                this.firePropertyChange("modelChanged", null, null);
            } else if (parameter.getType() == ParamType.MEAN) {
                if (this.editor.isEditIntercepts()) {
                    this.semIm().setIntercept(node, d);
                } else {
                    this.semIm().setMean(node, d);
                }
                this.firePropertyChange("modelChanged", null, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.resetLabels();
        this.workbench().repaint();
        this.setLastEditedObject(null);
    }

    private int getSavedTooltipDelay() {
        return this.savedTooltipDelay;
    }

    private void setSavedTooltipDelay(int savedTooltipDelay) {
        if (this.savedTooltipDelay == 0) {
            this.savedTooltipDelay = savedTooltipDelay;
        }
    }

    private String asString(double value) {
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        if (Double.isNaN(value)) {
            return " * ";
        }
        return nf.format(value);
    }

    private void addMouseListenerToGraphNodesMeasured() {
        List<Node> nodes = this.graph().getNodes();
        for (Node node : nodes) {
            Object displayNode = this.workbench().getModelToDisplay().get(node);
            if (!(displayNode instanceof GraphNodeMeasured)) continue;
            DisplayNode _displayNode = (DisplayNode)displayNode;
            _displayNode.setToolTipText(this.getEquationOfNode(_displayNode.getModelNode()));
        }
    }

    private String getEquationOfNode(Node node) {
        String eqn = node.getName() + " = B0_" + node.getName();
        SemGraph semGraph = this.semIm().getSemPm().getGraph();
        List<Node> parentNodes = semGraph.getParents(node);
        for (Node parentNodeObj : parentNodes) {
            Node parentNode = parentNodeObj;
            Parameter edgeParam = this.getEdgeParameter(semGraph.getDirectedEdge(parentNode, node));
            if (edgeParam == null) continue;
            eqn = eqn + " + " + edgeParam.getName() + "*" + parentNode;
        }
        eqn = eqn + " + " + this.semIm().getSemPm().getGraph().getExogenous(node);
        return eqn;
    }

    public GraphWorkbench getWorkbench() {
        return this.workbench;
    }

    private boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.workbench().setAllowEdgeReorientations(editable);
        this.workbench().setAllowDoubleClickActions(editable);
        this.workbench().setAllowNodeEdgeSelection(editable);
        this.editable = editable;
    }

    static final class NodeActionListener
    implements ActionListener {
        private SemImGraphicalEditor editor;
        private Node node;

        public NodeActionListener(SemImGraphicalEditor editor, Node node) {
            this.editor = editor;
            this.node = node;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            DoubleTextField doubleTextField = (DoubleTextField)ev.getSource();
            String s = doubleTextField.getText();
            this.getEditor().setNodeValue(this.getNode(), s);
        }

        private SemImGraphicalEditor getEditor() {
            return this.editor;
        }

        private Node getNode() {
            return this.node;
        }
    }

    static final class EdgeActionListener
    implements ActionListener {
        private SemImGraphicalEditor editor;
        private Edge edge;

        public EdgeActionListener(SemImGraphicalEditor editor, Edge edge) {
            this.editor = editor;
            this.edge = edge;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            DoubleTextField doubleTextField = (DoubleTextField)ev.getSource();
            String s = doubleTextField.getText();
            this.getEditor().setEdgeValue(this.getEdge(), s);
        }

        private SemImGraphicalEditor getEditor() {
            return this.editor;
        }

        private Edge getEdge() {
            return this.edge;
        }
    }

    static final class NodeMouseListener
    extends MouseAdapter {
        private Node node;
        private SemImGraphicalEditor editor;

        public NodeMouseListener(Node node, SemImGraphicalEditor editor) {
            this.node = node;
            this.editor = editor;
        }

        private Node getNode() {
            return this.node;
        }

        private SemImGraphicalEditor getEditor() {
            return this.editor;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.getEditor().beginNodeEdit(this.getNode());
        }
    }

    static final class EdgeMouseListener
    extends MouseAdapter {
        private Edge edge;
        private SemImGraphicalEditor editor;

        public EdgeMouseListener(Edge edge, SemImGraphicalEditor editor) {
            this.edge = edge;
            this.editor = editor;
        }

        private Edge getEdge() {
            return this.edge;
        }

        private SemImGraphicalEditor getEditor() {
            return this.editor;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.getEditor().beginEdgeEdit(this.getEdge());
        }
    }
}

