/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.model.Params;
import edu.cmu.tetradapp.editor.ParameterEditor;
import edu.cmu.tetradapp.model.SemImParams;
import edu.cmu.tetradapp.util.DoubleTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class SemImParamsEditor
extends JPanel
implements ParameterEditor {
    private SemImParams params = null;

    @Override
    public void setParams(Params params) {
        if (params == null) {
            throw new NullPointerException();
        }
        this.params = (SemImParams)params;
    }

    @Override
    public void setParentModels(Object[] parentModels) {
    }

    @Override
    public void setup() {
        this.setLayout(new BorderLayout());
        JCheckBox randomEveryTime = new JCheckBox();
        randomEveryTime.setSelected(!this.params.isRetainPreviousValues());
        DecimalFormat decimalFormat = new DecimalFormat("0.0######");
        DoubleTextField coefLowField = new DoubleTextField(this.params.getCoefLow(), 6, decimalFormat);
        coefLowField.setFilter(new DoubleTextField.Filter(){

            @Override
            public double filter(double value, double oldValue) {
                try {
                    SemImParamsEditor.this.params.setCoefRange(value, SemImParamsEditor.this.params.getCoefHigh());
                    return value;
                }
                catch (IllegalArgumentException e) {
                    return oldValue;
                }
            }
        });
        DoubleTextField coefHighField = new DoubleTextField(this.params.getCoefHigh(), 6, decimalFormat);
        coefHighField.setFilter(new DoubleTextField.Filter(){

            @Override
            public double filter(double value, double oldValue) {
                try {
                    SemImParamsEditor.this.params.setCoefRange(SemImParamsEditor.this.params.getCoefLow(), value);
                    return value;
                }
                catch (IllegalArgumentException e) {
                    return oldValue;
                }
            }
        });
        DoubleTextField covLowField = new DoubleTextField(this.params.getCovLow(), 6, decimalFormat);
        covLowField.setFilter(new DoubleTextField.Filter(){

            @Override
            public double filter(double value, double oldValue) {
                try {
                    SemImParamsEditor.this.params.setCovRange(value, SemImParamsEditor.this.params.getCovHigh());
                    return value;
                }
                catch (IllegalArgumentException e) {
                    return oldValue;
                }
            }
        });
        DoubleTextField covHighField = new DoubleTextField(this.params.getCovHigh(), 6, decimalFormat);
        covHighField.setFilter(new DoubleTextField.Filter(){

            @Override
            public double filter(double value, double oldValue) {
                try {
                    SemImParamsEditor.this.params.setCovRange(SemImParamsEditor.this.params.getCovLow(), value);
                    return value;
                }
                catch (IllegalArgumentException e) {
                    return oldValue;
                }
            }
        });
        DoubleTextField varLowField = new DoubleTextField(this.params.getVarLow(), 6, decimalFormat);
        varLowField.setFilter(new DoubleTextField.Filter(){

            @Override
            public double filter(double value, double oldValue) {
                try {
                    SemImParamsEditor.this.params.setVarRange(value, SemImParamsEditor.this.params.getVarHigh());
                    return value;
                }
                catch (IllegalArgumentException e) {
                    return oldValue;
                }
            }
        });
        DoubleTextField varHighField = new DoubleTextField(this.params.getVarHigh(), 6, decimalFormat);
        varHighField.setFilter(new DoubleTextField.Filter(){

            @Override
            public double filter(double value, double oldValue) {
                try {
                    SemImParamsEditor.this.params.setVarRange(SemImParamsEditor.this.params.getVarLow(), value);
                    return value;
                }
                catch (IllegalArgumentException e) {
                    return oldValue;
                }
            }
        });
        JCheckBox coefSymmetric = new JCheckBox("Symmetric about zero.");
        JCheckBox covSymmetric = new JCheckBox("Symmetric about zero.");
        coefSymmetric.setSelected(this.params.isCoefSymmetric());
        covSymmetric.setSelected(this.params.isCovSymmetric());
        coefSymmetric.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox checkBox = (JCheckBox)e.getSource();
                SemImParamsEditor.this.params.setCoefSymmetric(checkBox.isSelected());
            }
        });
        covSymmetric.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox checkBox = (JCheckBox)e.getSource();
                SemImParamsEditor.this.params.setCovSymmetric(checkBox.isSelected());
            }
        });
        randomEveryTime.setText("Pick new random values each time this SEM IM is reinitialized.");
        randomEveryTime.setVerticalTextPosition(1);
        randomEveryTime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox checkBox = (JCheckBox)e.getSource();
                SemImParamsEditor.this.getParams().setRetainPreviousValues(!checkBox.isSelected());
            }
        });
        Box b1 = Box.createVerticalBox();
        Box b2 = Box.createHorizontalBox();
        b2.add(new JLabel("Unfixed parameter values for this SEM IM are drawn as follows:"));
        b2.add(Box.createHorizontalGlue());
        b1.add(b2);
        b1.add(Box.createVerticalStrut(5));
        Box b4a = Box.createHorizontalBox();
        b4a.add(new JLabel("Coefficient values are drawn from "));
        b4a.add(new BigLabel("("));
        b4a.add(coefLowField);
        b4a.add(new BigLabel(", "));
        b4a.add(coefHighField);
        b4a.add(new BigLabel(") "));
        b4a.add(coefSymmetric);
        b4a.add(Box.createHorizontalGlue());
        b1.add(b4a);
        Box b4b = Box.createHorizontalBox();
        b4b.add(new JLabel("Covariance values are drawn from "));
        b4b.add(new BigLabel("("));
        b4b.add(covLowField);
        b4b.add(new BigLabel(", "));
        b4b.add(covHighField);
        b4b.add(new BigLabel(") "));
        b4b.add(covSymmetric);
        b4b.add(Box.createHorizontalGlue());
        b1.add(b4b);
        Box b4c = Box.createHorizontalBox();
        b4c.add(new JLabel("Variance values are drawn from "));
        b4c.add(new BigLabel("("));
        b4c.add(varLowField);
        b4c.add(new BigLabel(", "));
        b4c.add(varHighField);
        b4c.add(new BigLabel(")"));
        b4c.add(new JLabel("."));
        b4c.add(Box.createHorizontalGlue());
        b1.add(b4c);
        Box b5 = Box.createHorizontalBox();
        b5.add(randomEveryTime);
        b5.add(Box.createHorizontalGlue());
        b1.add(b5);
        b1.add(Box.createHorizontalGlue());
        this.add((Component)b1, "Center");
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
    }

    @Override
    public boolean mustBeShown() {
        return false;
    }

    private synchronized SemImParams getParams() {
        return this.params;
    }

    static final class BigLabel
    extends JLabel {
        private static Font FONT = new Font("Dialog", 1, 20);

        public BigLabel(String text) {
            super(text);
            this.setFont(FONT);
        }
    }
}

