/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.SemGraph;
import edu.cmu.tetrad.sem.Parameter;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.session.DelegatesEditing;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetradapp.editor.SaveComponentImage;
import edu.cmu.tetradapp.editor.SemPmGraphicalEditor;
import edu.cmu.tetradapp.model.SemPmWrapper;
import edu.cmu.tetradapp.util.LayoutEditable;
import edu.cmu.tetradapp.util.LayoutMenu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public final class SemPmEditor
extends JPanel
implements DelegatesEditing,
LayoutEditable {
    private SemPm semPm;
    private SemPmGraphicalEditor graphicalEditor;
    private JMenuItem errorTerms;

    public SemPmEditor(final SemPm semPm) {
        if (semPm == null) {
            throw new NullPointerException("SemPm must not be null.");
        }
        this.semPm = semPm;
        this.setLayout(new BorderLayout());
        this.add((Component)this.graphicalEditor(), "Center");
        JMenuBar menuBar = new JMenuBar();
        JMenu file = new JMenu("File");
        menuBar.add(file);
        file.add(new SaveComponentImage(this.graphicalEditor.getWorkbench(), "Save Graph Image..."));
        this.errorTerms = new JMenuItem();
        if (this.getSemGraph().isShowErrorTerms()) {
            this.errorTerms.setText("Hide Error Terms");
        } else {
            this.errorTerms.setText("Show Error Terms");
        }
        this.errorTerms.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem menuItem = (JMenuItem)e.getSource();
                if ("Hide Error Terms".equals(menuItem.getText())) {
                    menuItem.setText("Show Error Terms");
                    SemPmEditor.this.getSemGraph().setShowErrorTerms(false);
                    SemPmEditor.this.graphicalEditor().resetLabels();
                } else if ("Show Error Terms".equals(menuItem.getText())) {
                    menuItem.setText("Hide Error Terms");
                    SemPmEditor.this.getSemGraph().setShowErrorTerms(true);
                    SemPmEditor.this.graphicalEditor().resetLabels();
                }
            }
        });
        JMenuItem fixParameters = new JMenuItem("Fix Parameters");
        fixParameters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int ret = JOptionPane.showConfirmDialog(JOptionUtils.centeringComp(), "This will fix one measurement for each latent to 1.0 and cannot be undone. Proceed?", "Confirm", 0, 2);
                if (ret == 0) {
                    SemGraph graph = semPm.getGraph();
                    List<Node> nodes = graph.getNodes();
                    block0: for (Node x : nodes) {
                        if (x.getNodeType() != NodeType.LATENT) continue;
                        for (Node y : graph.getAdjacentNodes(x)) {
                            Edge edge;
                            if (y.getNodeType() != NodeType.MEASURED || !(edge = graph.getEdge(x, y)).pointsTowards(y)) continue;
                            Parameter p = semPm.getParameter(x, y);
                            if (p == null) {
                                throw new IllegalArgumentException();
                            }
                            if (p.isFixed()) continue;
                            p.setFixed(true);
                            p.setInitializedRandomly(false);
                            p.setStartingValue(1.0);
                            continue block0;
                        }
                    }
                    SemPmEditor.this.graphicalEditor.resetLabels();
                }
            }
        });
        JMenuItem startFactorLoadingsAtOne = new JMenuItem("Start All Factor Loadings At 1.0");
        startFactorLoadingsAtOne.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int ret = JOptionPane.showConfirmDialog(JOptionUtils.centeringComp(), "This will start all factor loadings at 1.0 for purposes of estimation. Proceed?", "Confirm", 0, 2);
                if (ret == 0) {
                    SemGraph graph = semPm.getGraph();
                    for (Edge edge : graph.getEdges()) {
                        Parameter p;
                        Node x = edge.getNode1();
                        Node y = edge.getNode2();
                        if (edge.pointsTowards(x)) {
                            if (x.getNodeType() != NodeType.MEASURED || y.getNodeType() != NodeType.LATENT) continue;
                            p = semPm.getParameter(y, x);
                        } else {
                            if (y.getNodeType() != NodeType.MEASURED || x.getNodeType() != NodeType.LATENT) continue;
                            p = semPm.getParameter(x, y);
                        }
                        p.setInitializedRandomly(false);
                        p.setStartingValue(1.0);
                    }
                    SemPmEditor.this.graphicalEditor.resetLabels();
                }
            }
        });
        JMenu params = new JMenu("Parameters");
        params.add(this.errorTerms);
        params.add(fixParameters);
        params.add(startFactorLoadingsAtOne);
        menuBar.add(params);
        menuBar.add(new LayoutMenu(this));
        this.add((Component)menuBar, "North");
    }

    private SemGraph getSemGraph() {
        return this.semPm.getGraph();
    }

    public SemPmEditor(SemPmWrapper semImWrapper) {
        this(semImWrapper.getSemPm());
    }

    @Override
    public JComponent getEditDelegate() {
        return this.graphicalEditor();
    }

    @Override
    public Graph getGraph() {
        return this.graphicalEditor().getWorkbench().getGraph();
    }

    @Override
    public Knowledge getKnowledge() {
        return this.graphicalEditor().getWorkbench().getKnowledge();
    }

    @Override
    public Graph getSourceGraph() {
        return this.graphicalEditor().getWorkbench().getSourceGraph();
    }

    @Override
    public void layoutByGraph(Graph graph) {
        SemGraph _graph = (SemGraph)this.graphicalEditor().getWorkbench().getGraph();
        _graph.setShowErrorTerms(false);
        this.graphicalEditor().getWorkbench().layoutByGraph(graph);
        _graph.resetErrorPositions();
        this.graphicalEditor().getWorkbench().setGraph(_graph);
        this.errorTerms.setText("Show Error Terms");
    }

    @Override
    public void layoutByKnowledge() {
        SemGraph _graph = (SemGraph)this.graphicalEditor().getWorkbench().getGraph();
        _graph.setShowErrorTerms(false);
        this.graphicalEditor().getWorkbench().layoutByKnowledge();
        _graph.resetErrorPositions();
        this.graphicalEditor().getWorkbench().setGraph(_graph);
        this.errorTerms.setText("Show Error Terms");
    }

    private SemPm getSemPm() {
        return this.semPm;
    }

    private SemPmGraphicalEditor graphicalEditor() {
        if (this.graphicalEditor == null) {
            this.graphicalEditor = new SemPmGraphicalEditor(this.getSemPm());
        }
        return this.graphicalEditor;
    }
}

