/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import cern.colt.matrix.DoubleMatrix2D;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.sem.StandardizedSemIm;
import edu.cmu.tetrad.util.NumberFormatUtil;
import java.text.NumberFormat;
import java.util.List;
import javax.swing.table.AbstractTableModel;

final class StandardizedSemImImpliedCovTable
extends AbstractTableModel {
    private StandardizedSemIm semIm;
    private boolean measured;
    private boolean correlations;
    private NumberFormat nf;
    private double[][] matrix;

    public StandardizedSemImImpliedCovTable(StandardizedSemIm semIm, boolean measured, boolean correlations) {
        this.semIm = semIm;
        this.measured = measured;
        this.correlations = correlations;
        this.nf = NumberFormatUtil.getInstance().getNumberFormat();
        if (this.measured() && this.covariances()) {
            this.matrix = this.getSemIm().getImplCovarMeas().toArray();
        } else if (this.measured() && !this.covariances()) {
            this.matrix = StandardizedSemImImpliedCovTable.corr(this.getSemIm().getImplCovarMeas().toArray());
        } else if (!this.measured() && this.covariances()) {
            DoubleMatrix2D implCovarC = this.getSemIm().getImplCovar();
            this.matrix = implCovarC.toArray();
        } else if (!this.measured() && !this.covariances()) {
            DoubleMatrix2D implCovarC = this.getSemIm().getImplCovar();
            this.matrix = StandardizedSemImImpliedCovTable.corr(implCovarC.toArray());
        }
    }

    @Override
    public int getRowCount() {
        if (this.measured()) {
            return this.getSemIm().getMeasuredNodes().size() + 1;
        }
        return this.getSemIm().getVariableNodes().size() + 1;
    }

    @Override
    public int getColumnCount() {
        if (this.measured()) {
            return this.getSemIm().getMeasuredNodes().size() + 1;
        }
        return this.getSemIm().getVariableNodes().size() + 1;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "";
        }
        if (this.measured()) {
            List<Node> nodes = this.getSemIm().getMeasuredNodes();
            Node node = nodes.get(columnIndex - 1);
            return node.getName();
        }
        List<Node> nodes = this.getSemIm().getVariableNodes();
        Node node = nodes.get(columnIndex - 1);
        return node.getName();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex == 0) {
            return this.getColumnName(columnIndex);
        }
        if (columnIndex == 0) {
            return this.getColumnName(rowIndex);
        }
        if (rowIndex < columnIndex) {
            return null;
        }
        return this.nf.format(this.matrix[rowIndex - 1][columnIndex - 1]);
    }

    private boolean covariances() {
        return !this.correlations();
    }

    private static double[][] corr(double[][] implCovar) {
        int i;
        int length = implCovar.length;
        double[][] corr = new double[length][length];
        for (i = 1; i < length; ++i) {
            for (int j = 0; j < i; ++j) {
                double d1 = implCovar[i][j];
                double d2 = implCovar[i][i];
                double d3 = implCovar[j][j];
                double d4 = d1 / Math.pow(d2 * d3, 0.5);
                if (!(d4 <= 1.0) && !Double.isNaN(d4)) {
                    throw new IllegalArgumentException("Off-diagonal element at (" + i + ", " + j + ") cannot be converted to correlation: " + d1 + " <= Math.pow(" + d2 + " * " + d3 + ", 0.5)");
                }
                corr[i][j] = d4;
            }
        }
        for (i = 0; i < length; ++i) {
            corr[i][i] = 1.0;
        }
        return corr;
    }

    private boolean measured() {
        return this.measured;
    }

    private boolean correlations() {
        return this.correlations;
    }

    private StandardizedSemIm getSemIm() {
        return this.semIm;
    }
}

