/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Node;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.rmi.MarshalledObject;
import java.util.List;

class SubgraphSelection
implements Transferable {
    private List graphElements;
    private DataFlavor[] dataFlavors = new DataFlavor[]{new DataFlavor(SubgraphSelection.class, "Subgraph Selection")};

    public SubgraphSelection(List graphElements) {
        List result;
        if (graphElements == null) {
            throw new NullPointerException("List of graph elements must not be null.");
        }
        for (Object graphElement : graphElements) {
            if (graphElement instanceof Node || graphElement instanceof Edge) continue;
            throw new IllegalArgumentException("Model node list contains an object that is not a Node or an Edge: " + graphElement);
        }
        try {
            result = new MarshalledObject<List>(graphElements).get();
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw new IllegalStateException("Could not clone.");
        }
        this.graphElements = result;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        List returnList = this.graphElements;
        this.graphElements = null;
        return returnList;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(this.getTransferDataFlavors()[0]);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.dataFlavors;
    }
}

