/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetradapp.editor.DataEditor;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public final class SubsetContinuousVariablesAction
extends AbstractAction {
    private DataEditor dataEditor;

    public SubsetContinuousVariablesAction(DataEditor editor) {
        super("Copy Continuous Variables");
        if (editor == null) {
            throw new NullPointerException();
        }
        this.dataEditor = editor;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DataModel selectedDataModel = this.getDataEditor().getSelectedDataModel();
        if (selectedDataModel instanceof DataSet) {
            DataSet dataSet = (DataSet)selectedDataModel;
            List<Node> variables = dataSet.getVariables();
            int n = 0;
            for (Node variable : variables) {
                if (!(variable instanceof ContinuousVariable)) continue;
                ++n;
            }
            if (n == 0) {
                JOptionPane.showMessageDialog(this.getDataEditor(), "There are no continuous variables in this data set.");
                return;
            }
            int[] indices = new int[n];
            int m = -1;
            for (int i = 0; i < variables.size(); ++i) {
                if (!(variables.get(i) instanceof ContinuousVariable)) continue;
                indices[++m] = i;
            }
            dataSet = dataSet.subsetColumns(indices);
            DataModelList list = new DataModelList();
            list.add(dataSet);
            this.getDataEditor().reset(list);
            this.getDataEditor().selectFirstTab();
        } else {
            JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Requires a tabular data set.");
        }
    }

    private DataEditor getDataEditor() {
        return this.dataEditor;
    }
}

