/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.CorrelationMatrix;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetradapp.editor.DataEditor;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public final class SubsetSelectedVariablesAction
extends AbstractAction {
    private DataEditor dataEditor;

    public SubsetSelectedVariablesAction(DataEditor editor) {
        super("Copy Selected Columns");
        if (editor == null) {
            throw new NullPointerException();
        }
        this.dataEditor = editor;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DataModel dataModel = this.getDataEditor().getSelectedDataModel();
        if (dataModel instanceof DataSet) {
            DataSet dataSet = (DataSet)dataModel;
            int[] selectedIndices = dataSet.getSelectedIndices();
            if (selectedIndices.length == 0) {
                JOptionPane.showMessageDialog(this.getDataEditor(), "No columns have been selected.");
                return;
            }
            DataSet selection = dataSet.subsetColumns(selectedIndices);
            DataModelList list = new DataModelList();
            list.add(selection);
            this.getDataEditor().reset(list);
            this.getDataEditor().selectFirstTab();
        } else if (dataModel instanceof CorrelationMatrix) {
            CorrelationMatrix corrMatrix = (CorrelationMatrix)dataModel;
            List<String> selectedNames = corrMatrix.getSelectedVariableNames();
            if (selectedNames.isEmpty()) {
                JOptionPane.showMessageDialog(this.getDataEditor(), "No columns have been selected.");
                return;
            }
            CorrelationMatrix submatrix = corrMatrix.getSubCorrMatrix(selectedNames.toArray(new String[0]));
            DataModelList list = new DataModelList();
            list.add(submatrix);
            this.getDataEditor().reset(list);
            this.getDataEditor().selectFirstTab();
        } else if (dataModel instanceof CovarianceMatrix) {
            CovarianceMatrix corrMatrix = (CovarianceMatrix)dataModel;
            List<String> selectedNames = corrMatrix.getSelectedVariableNames();
            if (selectedNames.isEmpty()) {
                JOptionPane.showMessageDialog(this.getDataEditor(), "No columns have been selected.");
                return;
            }
            CovarianceMatrix submatrix = corrMatrix.getSubmatrix(selectedNames.toArray(new String[0]));
            DataModelList list = new DataModelList();
            list.add(submatrix);
            this.getDataEditor().reset(list);
            this.getDataEditor().selectFirstTab();
        } else {
            throw new IllegalArgumentException("Data subsetting requires a tabular data set or a covariance (correlation) matrix.");
        }
    }

    private DataEditor getDataEditor() {
        return this.dataEditor;
    }
}

