/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetradapp.editor.TierList;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;

public class TemporalTierEditor
extends JPanel
implements PropertyChangeListener,
ActionListener {
    private Knowledge knowledge;
    private JButton clear = new JButton("Clear All Knowledge");
    private TierList tierList;

    public TemporalTierEditor(Knowledge knowledge, List varNames, String sessionName) {
        if (knowledge == null) {
            throw new NullPointerException("Knowledge must not be null.");
        }
        if (varNames == null) {
            throw new NullPointerException("AbstractVariable names must not be null.");
        }
        if (sessionName == null) {
            throw new NullPointerException("Session name must not be null.");
        }
        System.out.println("old Knowledge in Forb is: " + knowledge);
        this.knowledge = knowledge;
        System.out.println("\nnew Knowledge in Forb is: " + knowledge);
        this.setLayout(new BoxLayout(this, 1));
        this.tierList = new TierList(knowledge, varNames, this);
        this.tierList.addPropertyChangeListener(this);
        this.add(this.tierList);
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new FlowLayout(2, 5, 5));
        southPanel.add(this.clear);
        this.add(southPanel);
        this.clear.addActionListener(this);
        this.setName(this.getTitle());
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.tierList.repaint();
        this.validate();
    }

    @Override
    public void setName(String name) {
        String oldName = this.getName();
        super.setName(name);
        this.firePropertyChange("name", oldName, this.getName());
    }

    private String getTitle() {
        String graphName = "Background Knowledge";
        return this.getName() + ":  " + graphName;
    }

    @Override
    public void actionPerformed(ActionEvent a) {
        if (a.getSource() == this.clear) {
            this.knowledge.clear();
            this.tierList.repaint();
            this.tierList.refreshInfo();
            this.validate();
        }
    }
}

