/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.sem.SemEvidence;
import edu.cmu.tetrad.sem.SemUpdater;
import edu.cmu.tetradapp.util.SortingComboBox;
import edu.cmu.tetradapp.util.WatchedProcess;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class UpdatedSemImWizard
extends JPanel {
    private SemEvidence evidence;
    private GraphWorkbench workbench;
    private SemUpdater semUpdater;
    private Node selectedNode;
    private JComboBox varNamesComboBox;
    private JComboBox varNamesComboBox2;
    private JPanel marginalsPanel;

    public UpdatedSemImWizard(SemUpdater semUpdater, GraphWorkbench workbench, int tab, Node selectedNode) {
        if (semUpdater == null) {
            throw new NullPointerException();
        }
        this.semUpdater = semUpdater;
        this.selectedNode = selectedNode;
        this.evidence = semUpdater.getEvidence();
        this.workbench = workbench;
        this.workbench.setAllowDoubleClickActions(false);
        this.setLayout(new BorderLayout());
        this.varNamesComboBox = this.makeVarNamesDropdown();
        this.varNamesComboBox2 = this.makeVarNamesDropdown();
        Node modelNode = (Node)this.varNamesComboBox.getSelectedItem();
        workbench.deselectAll();
        workbench.selectNode(modelNode);
        selectedNode = (Node)this.varNamesComboBox.getSelectedItem();
        this.marginalsPanel = new JPanel();
        this.marginalsPanel.setLayout(new BorderLayout());
        this.marginalsPanel.add((Component)this.createMarginalDisplay(selectedNode), "Center");
        JTabbedPane probsPane = new JTabbedPane(1);
        this.setupMarginalsDisplay(probsPane);
        tab = tab < probsPane.getTabCount() ? tab : 0;
        probsPane.setSelectedIndex(tab);
        this.add((Component)probsPane, "Center");
        this.varNamesComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Node node = (Node)UpdatedSemImWizard.this.varNamesComboBox.getSelectedItem();
                UpdatedSemImWizard.this.setCurrentNode(node);
            }
        });
        this.varNamesComboBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Node node = (Node)UpdatedSemImWizard.this.varNamesComboBox2.getSelectedItem();
                UpdatedSemImWizard.this.setCurrentNode(node);
            }
        });
        workbench.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                List selection;
                if (e.getPropertyName().equals("selectedNodes") && (selection = (List)e.getNewValue()).size() == 1) {
                    Node node = (Node)selection.get(0);
                    UpdatedSemImWizard.this.varNamesComboBox.setSelectedItem(node);
                }
            }
        });
    }

    private void setupMarginalsDisplay(JTabbedPane probsPane) {
        probsPane.add("Marginal Probabilities", this.marginalsPanel);
        probsPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JTabbedPane tabbedPane = (JTabbedPane)e.getSource();
                int tab = tabbedPane.getSelectedIndex();
                UpdatedSemImWizard.this.firePropertyChange("updatedBayesImWizardTab", null, tab);
            }
        });
    }

    private JComboBox makeVarNamesDropdown() {
        SortingComboBox varNamesComboBox = new SortingComboBox(){

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        varNamesComboBox.setBackground(Color.white);
        Graph graph = this.semUpdater.getManipulatedGraph();
        for (Node o : graph.getNodes()) {
            ((JComboBox)varNamesComboBox).addItem(o);
        }
        if (this.selectedNode != null) {
            varNamesComboBox.setSelectedItem(this.selectedNode);
        } else {
            varNamesComboBox.setSelectedIndex(0);
            this.selectedNode = (Node)varNamesComboBox.getSelectedItem();
        }
        return varNamesComboBox;
    }

    private void addListOfEvidence(Box verticalBox) {
        boolean foundACondition = false;
        for (int i = 0; i < this.evidence.getNumNodes(); ++i) {
            if (this.evidence.hasNoEvidence(i)) continue;
            foundACondition = true;
            Node node = this.evidence.getNode(i);
            Box c = Box.createHorizontalBox();
            c.add(Box.createRigidArea(new Dimension(30, 1)));
            StringBuilder buf = new StringBuilder();
            buf.append("<html>").append(node.getName()).append(" = ");
            buf.append("</html>");
            c.add(new JLabel(buf.toString()));
            c.add(Box.createHorizontalGlue());
            verticalBox.add(c);
        }
        if (!foundACondition) {
            Box e = Box.createHorizontalBox();
            e.add(Box.createRigidArea(new Dimension(30, 1)));
            e.add(new JLabel("--No Evidence--"));
            e.add(Box.createHorizontalGlue());
            verticalBox.add(e);
        }
    }

    private JComponent createMarginalDisplay(Node node) {
        if (node == null) {
            throw new NullPointerException();
        }
        Box marginalBox = Box.createVerticalBox();
        Box b1 = Box.createHorizontalBox();
        b1.add(new JLabel("Marginal probabilities for variable "));
        b1.add(this.varNamesComboBox2);
        b1.add(new JLabel(", updated"));
        b1.add(Box.createHorizontalGlue());
        marginalBox.add(b1);
        Box b2 = Box.createHorizontalBox();
        b2.add(new JLabel("to reflect the following evidence:"));
        b2.add(Box.createHorizontalGlue());
        marginalBox.add(b2);
        marginalBox.add(Box.createRigidArea(new Dimension(1, 10)));
        this.addListOfEvidence(marginalBox);
        marginalBox.add(Box.createRigidArea(new Dimension(1, 20)));
        marginalBox.add(Box.createGlue());
        return marginalBox;
    }

    private void setCurrentNode(final Node node) {
        Window owner = (Window)this.getTopLevelAncestor();
        if (owner == null) {
            this.setCurrentNodeSub(node);
        } else {
            new WatchedProcess(owner){

                @Override
                public void watch() {
                    UpdatedSemImWizard.this.setCurrentNodeSub(node);
                }
            };
        }
    }

    private void setCurrentNodeSub(Node node) {
        if (node == this.selectedNode) {
            return;
        }
        this.selectedNode = node;
        this.getWorkbench().deselectAll();
        this.getWorkbench().selectNode(this.selectedNode);
        if (this.varNamesComboBox.getSelectedItem() != node) {
            this.varNamesComboBox.setSelectedItem(node);
        }
        if (this.varNamesComboBox2.getSelectedItem() != node) {
            this.varNamesComboBox2.setSelectedItem(node);
        }
        this.marginalsPanel.removeAll();
        this.marginalsPanel.add((Component)this.createMarginalDisplay(node), "Center");
        this.marginalsPanel.revalidate();
        this.marginalsPanel.repaint();
    }

    private GraphWorkbench getWorkbench() {
        return this.workbench;
    }

    public Node getSelectedNode() {
        return this.selectedNode;
    }
}

