/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.gene.editor;

import edu.cmu.tetradapp.model.BooleanGlassGeneIm;
import java.util.List;
import javax.swing.table.AbstractTableModel;

class BooleanTable
extends AbstractTableModel {
    private String t = "+1";
    private String f = "-1";
    private int factorIndex = 0;
    private BooleanGlassGeneIm im = null;
    private List parents = null;
    private int numParents;

    public BooleanTable(int factorIndex, BooleanGlassGeneIm im) {
        this.factorIndex = factorIndex;
        this.im = im;
        this.parents = im.getParents(factorIndex);
        this.numParents = im.getNumParents(factorIndex);
    }

    @Override
    public int getRowCount() {
        return (int)Math.pow(2.0, this.numParents);
    }

    @Override
    public int getColumnCount() {
        if (this.numParents == 0) {
            return 0;
        }
        return this.numParents + 1;
    }

    @Override
    public String getColumnName(int column) {
        if (this.numParents == 0) {
            return null;
        }
        if (column < this.numParents) {
            return (String)this.parents.get(column);
        }
        if (column == this.numParents) {
            return "Fcn. Value";
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (this.numParents == 0) {
            return false;
        }
        if (column < this.numParents) {
            return false;
        }
        return column == this.numParents;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this.numParents == 0) {
            return null;
        }
        if (column < this.numParents) {
            int jump = 1;
            for (int i = 0; i < this.numParents - column - 1; ++i) {
                jump *= 2;
            }
            return row / jump % 2 == 0 ? this.f : this.t;
        }
        if (column == this.numParents) {
            return this.im.getRowValueAt(this.factorIndex, row) ? this.t : this.f;
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        String str = ((String)value).trim();
        if (this.t.equals(str)) {
            this.im.setRowValueAt(this.factorIndex, row, true);
        } else if (this.f.equals(str)) {
            this.im.setRowValueAt(this.factorIndex, row, false);
        }
    }
}

