/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.gene.editor;

import edu.cmu.tetradapp.gene.editor.DirectedGraphWorkbench;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.MatteBorder;

public class DirectedGraphToolbar
extends JPanel
implements PropertyChangeListener {
    static final long serialVersionUID = 23L;
    private ButtonGroup group;
    private JToggleButton move;
    private JToggleButton addObserved;
    private JToggleButton addDirectedEdge;
    private JToggleButton cleanup;
    private DirectedGraphWorkbench workbench;

    public DirectedGraphToolbar(DirectedGraphWorkbench workbench) {
        this.workbench = workbench;
        this.group = new ButtonGroup();
        this.setLayout(new BoxLayout(this, 1));
        this.setMinimumSize(new Dimension(200, 10));
        MatteBorder insideBorder = new MatteBorder(10, 10, 10, 10, this.getBackground());
        EtchedBorder outsideBorder = new EtchedBorder();
        this.setBorder(new CompoundBorder(outsideBorder, insideBorder));
        this.move = new JToggleButton();
        this.addObserved = new JToggleButton();
        this.addDirectedEdge = new JToggleButton();
        this.cleanup = new JToggleButton();
        FocusAdapter focusListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                JToggleButton component = (JToggleButton)e.getComponent();
                component.doClick();
            }
        };
        this.move.addFocusListener(focusListener);
        this.addObserved.addFocusListener(focusListener);
        this.addDirectedEdge.addFocusListener(focusListener);
        this.move.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirectedGraphToolbar.this.move.getModel().setSelected(true);
                DirectedGraphToolbar.this.setWorkbenchMode(0);
            }
        });
        this.addObserved.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirectedGraphToolbar.this.addObserved.getModel().setSelected(true);
                DirectedGraphToolbar.this.setWorkbenchMode(1);
            }
        });
        this.addDirectedEdge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirectedGraphToolbar.this.addDirectedEdge.getModel().setSelected(true);
                DirectedGraphToolbar.this.setWorkbenchMode(2);
            }
        });
        this.cleanup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirectedGraphToolbar.this.cleanup.setSelected(false);
                DirectedGraphToolbar.this.cleanup.getModel().setSelected(false);
                DirectedGraphToolbar.this.cleanup();
            }
        });
        this.addButton(this.move, "move", true);
        this.addButton(this.addObserved, "variable", true);
        this.addButton(this.addDirectedEdge, "directed", true);
        this.addButton(this.cleanup, "cleanup", false);
        workbench.addPropertyChangeListener(this);
        this.move.doClick();
        this.selectArrowTools();
    }

    private void setWorkbenchMode(int mode) {
        this.workbench.setWorkbenchMode(mode);
    }

    private void addButton(JToggleButton jb, String name, boolean addgroup) {
        jb.setIcon(new ImageIcon(this.getImage(name + "Up.gif")));
        jb.setRolloverIcon(new ImageIcon(this.getImage(name + "Roll.gif")));
        jb.setPressedIcon(new ImageIcon(this.getImage(name + "Down.gif")));
        jb.setSelectedIcon(new ImageIcon(this.getImage(name + "Down.gif")));
        jb.setDisabledIcon(new ImageIcon(this.getImage(name + "Off.gif")));
        jb.setRolloverEnabled(true);
        jb.setBorder(new EmptyBorder(1, 1, 1, 1));
        jb.setSize(100, 50);
        jb.setMinimumSize(new Dimension(100, 50));
        jb.setPreferredSize(new Dimension(100, 50));
        this.add(jb);
        if (addgroup) {
            this.group.add(jb);
        }
    }

    private Image getImage(String path) {
        try {
            String fullPath = "/resources/images/" + path;
            URL url = this.getClass().getResource(fullPath);
            return Toolkit.getDefaultToolkit().getImage(url);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("graph".equals(e.getPropertyName())) {
            this.selectArrowTools();
        }
    }

    private void selectArrowTools() {
        this.addDirectedEdge.setEnabled(true);
    }

    private void cleanup() {
        this.workbench.cleanup();
    }
}

