/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.gene.editor;

import edu.cmu.tetrad.gene.graph.ActiveLagGraph;
import edu.cmu.tetrad.gene.history.LaggedEdge;
import edu.cmu.tetrad.gene.history.LaggedFactor;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.PointXy;
import edu.cmu.tetradapp.gene.editor.DirectedGraphNode;
import edu.cmu.tetradapp.gene.editor.LabeledGraphEdge;
import edu.cmu.tetradapp.gene.editor.LagGraphWorkbench;
import edu.cmu.tetradapp.workbench.DisplayEdge;
import edu.cmu.tetradapp.workbench.DisplayNode;
import edu.cmu.tetradapp.workbench.IDisplayEdge;
import edu.cmu.tetradapp.workbench.Rubberband;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;

public final class DirectedGraphWorkbench
extends JComponent
implements LagGraphWorkbench {
    private static final int SELECT_MOVE = 0;
    private static final int ADD_NODE = 1;
    private static final int ADD_EDGE = 2;
    private static final String BASE_FACTOR_NAME = "Gene";
    private ActiveLagGraph modelGraph;
    private Map modelToDisplay;
    private boolean showEdgeLabels;
    private boolean showEdgeMulti;
    private Point lastMouseLoc;
    private boolean lastClickWasAdd;
    private JPopupMenu nodePopup;
    private JPopupMenu edgePopup;
    private static final String POPUP_DELETE = "Delete selection";
    private static final String POPUP_RENAME = "Rename factor";
    private static final String POPUP_EDIT = "Edit Lag";
    private int workbenchMode = 0;
    private final Color BACKGROUND = Color.white;
    private DisplayEdge trackedEdge;
    private LabeledGraphEdge ghostEdge;
    private Point clickPoint;
    private Rubberband rubberband;
    private boolean allowRubberband = true;
    private boolean allowUserEditing = true;
    private boolean allowMultipleNodeSelection = true;
    private final ComponentHandler compHandler = new ComponentHandler();
    private MouseHandler mouseHandler = new MouseHandler();
    private PropertyChangeHandler propChangeHandler = new PropertyChangeHandler();

    public DirectedGraphWorkbench(ActiveLagGraph graphModel) {
        if (graphModel == null) {
            throw new NullPointerException("Graph model must not be null.");
        }
        this.setModelGraph(graphModel);
        this.addMouseListener(this.mouseHandler);
        this.addMouseMotionListener(this.mouseHandler);
        this.setCursor(null);
        this.setShowEdgeLabels(true);
        PopupListener popupListener = new PopupListener();
        KeyStroke delete = KeyStroke.getKeyStroke(127, 0);
        this.nodePopup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem(POPUP_RENAME);
        menuItem.addActionListener(popupListener);
        this.nodePopup.add(menuItem);
        menuItem = new JMenuItem(POPUP_DELETE);
        menuItem.addActionListener(popupListener);
        menuItem.setAccelerator(delete);
        this.nodePopup.add(menuItem);
        this.edgePopup = new JPopupMenu();
        menuItem = new JMenuItem(POPUP_EDIT);
        menuItem.addActionListener(popupListener);
        this.edgePopup.add(menuItem);
        menuItem = new JMenuItem(POPUP_DELETE);
        menuItem.addActionListener(popupListener);
        menuItem.setAccelerator(delete);
        this.edgePopup.add(menuItem);
    }

    private void addModelNode(String name) throws IllegalArgumentException {
        this.getModelGraph().addFactor(name);
        LaggedFactor toSelf = new LaggedFactor(name, 1);
        this.getModelGraph().addEdge(name, toSelf);
        this.adjustPreferredSize();
        this.scrollRectToVisible(this.getVisibleRect());
    }

    private void addDisplayNode(Point loc, String name) {
        DirectedGraphNode displayNode = new DirectedGraphNode(name);
        this.modelToDisplay.put(name, displayNode);
        Dimension dim = displayNode.getPreferredSize();
        displayNode.setSize(dim);
        displayNode.setLocation(loc.x - dim.width / 2, loc.y - dim.height / 2);
        this.add((Component)displayNode, 0);
        SortedSet laggedFactors = this.getModelGraph().getParents(name);
        for (LaggedFactor f : laggedFactors) {
            if (this.modelToDisplay.get(f.getFactor()) == null) continue;
            this.addDisplayEdge(f.getFactor(), name, f.getLag());
        }
        for (String factor : this.getModelGraph().getFactors()) {
            if (factor.equals(name)) continue;
            for (LaggedFactor e : this.getModelGraph().getParents(factor)) {
                if (!e.getFactor().equals(name) || this.modelToDisplay.get(factor) == null) continue;
                this.addDisplayEdge(name, factor, e.getLag());
            }
        }
        displayNode.addComponentListener(this.compHandler);
        displayNode.addMouseListener(this.mouseHandler);
        displayNode.addMouseMotionListener(this.mouseHandler);
        this.repaint();
        this.validate();
        this.firePropertyChange("nodeAdded", null, displayNode);
    }

    private void removeDisplayNode(String name) {
        DisplayNode displayNode = (DisplayNode)this.modelToDisplay.get(name);
        this.remove(displayNode);
        this.modelToDisplay.remove(displayNode.getName());
        Set keys = this.modelToDisplay.keySet();
        LinkedList<String> removals = new LinkedList<String>();
        for (String s : keys) {
            if (!s.startsWith(displayNode.getName() + ":") && s.indexOf(":" + displayNode.getName() + ":") == -1) continue;
            this.remove((Component)this.modelToDisplay.get(s));
            removals.add(s);
        }
        Iterator<Object> it = removals.iterator();
        while (it.hasNext()) {
            this.removeDisplayEdge((String)it.next());
        }
        this.repaint();
    }

    private void removeModelNode(String factor) {
        this.getModelGraph().removeFactor(factor);
    }

    private void startEdge(DisplayNode node, Point mouseLoc) {
        if (this.trackedEdge != null) {
            this.remove(this.trackedEdge);
            this.remove(this.ghostEdge);
            this.trackedEdge = null;
            this.ghostEdge = null;
            this.repaint();
        }
        this.trackedEdge = new DisplayEdge(node, mouseLoc, 0);
        this.ghostEdge = new LabeledGraphEdge(node, this.findNearestNode(mouseLoc), null);
        this.ghostEdge.setAlpha(100);
        this.add((Component)this.trackedEdge, -1);
        this.add((Component)this.ghostEdge, -1);
        this.deselectAll();
    }

    private void finishEdge() {
        if (this.trackedEdge == null) {
            return;
        }
        DisplayNode comp1 = this.trackedEdge.getComp1();
        Point p = this.trackedEdge.getTrackPoint();
        DisplayNode comp2 = this.findNearestNode(p);
        String node1 = comp1.getName();
        String node2 = comp2.getName();
        String lagString = JOptionPane.showInputDialog("Time lag of edge:");
        if (lagString != null) {
            try {
                int lag = Integer.parseInt(lagString);
                if (lag > 0) {
                    this.addModelEdge(node1, node2, lag);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        this.remove(this.trackedEdge);
        this.remove(this.ghostEdge);
        this.trackedEdge = null;
        this.ghostEdge = null;
    }

    private void addModelEdge(String src, String dst, int lag) {
        this.getModelGraph().addEdge(dst, new LaggedFactor(src, lag));
    }

    private static double calcEdgeOffset(double i, double n, double w) {
        return w * (2.0 * i + 1.0 - n) / 2.0 / n;
    }

    private void resetEdgeOffsets(String node1, String node2) {
        LabeledGraphEdge e;
        int parallel = 0;
        Iterator it = this.getModelGraph().getParents(node2).iterator();
        while (it.hasNext()) {
            if (!((LaggedFactor)it.next()).getFactor().equals(node1)) continue;
            ++parallel;
        }
        it = this.getModelGraph().getParents(node1).iterator();
        while (it.hasNext()) {
            if (!((LaggedFactor)it.next()).getFactor().equals(node2)) continue;
            ++parallel;
        }
        int i = 1;
        for (LaggedFactor f : this.getModelGraph().getParents(node2)) {
            if (!f.getFactor().equals(node1)) continue;
            e = (LabeledGraphEdge)this.modelToDisplay.get(node1 + ":" + node2 + ":" + f.getLag());
            if (e != null) {
                e.setOffset(DirectedGraphWorkbench.calcEdgeOffset(i, parallel + 1, 40.0));
            }
            ++i;
        }
        for (LaggedFactor f : this.getModelGraph().getParents(node1)) {
            if (!f.getFactor().equals(node2)) continue;
            e = (LabeledGraphEdge)this.modelToDisplay.get(node2 + ":" + node1 + ":" + f.getLag());
            if (e != null) {
                e.setOffset(DirectedGraphWorkbench.calcEdgeOffset(i, parallel + 1, -40.0));
            }
            ++i;
        }
    }

    private void addDisplayEdge(String node1, String node2, int lag) {
        DisplayNode src = (DisplayNode)this.modelToDisplay.get(node1);
        DisplayNode dst = (DisplayNode)this.modelToDisplay.get(node2);
        LabeledGraphEdge displayEdge = new LabeledGraphEdge(src, dst, String.valueOf(lag));
        displayEdge.setShowLabel(this.showEdgeLabels);
        displayEdge.setShowMulti(this.showEdgeMulti);
        this.add((Component)displayEdge, -1);
        displayEdge.addComponentListener(this.compHandler);
        displayEdge.addMouseListener(this.mouseHandler);
        displayEdge.addMouseMotionListener(this.mouseHandler);
        displayEdge.addPropertyChangeListener(this.propChangeHandler);
        this.modelToDisplay.put(node1 + ":" + node2 + ":" + lag, displayEdge);
        this.resetEdgeOffsets(node1, node2);
    }

    private void removeModelEdge(String src, String dst, int lag) {
        this.getModelGraph().removeEdge(dst, new LaggedFactor(src, lag));
    }

    private void removeDisplayEdge(String src, String dst, int lag) {
        this.removeDisplayEdge(src + ":" + dst + ":" + lag);
    }

    private void removeDisplayEdge(String name) {
        DisplayEdge displayEdge = (DisplayEdge)this.modelToDisplay.get(name);
        this.modelToDisplay.remove(name);
        this.remove(displayEdge);
        this.repaint();
    }

    public void setShowEdgeLabels(boolean showEdgeLabels) {
        this.showEdgeLabels = showEdgeLabels;
        Component[] components = this.getComponents();
        for (int i = components.length - 1; i >= 0; --i) {
            Component comp = components[i];
            if (!(comp instanceof LabeledGraphEdge)) continue;
            ((LabeledGraphEdge)comp).setShowLabel(showEdgeLabels);
        }
    }

    public void setShowEdgeMulti(boolean showEdgeMulti) {
        this.showEdgeMulti = showEdgeMulti;
        Component[] components = this.getComponents();
        for (int i = components.length - 1; i >= 0; --i) {
            Component comp = components[i];
            if (!(comp instanceof LabeledGraphEdge)) continue;
            ((LabeledGraphEdge)comp).setShowMulti(showEdgeMulti);
        }
    }

    private String nextVariableName(String base) {
        int i = 0;
        block0: while (true) {
            String name = base + ++i;
            for (String fname : this.modelGraph.getFactors()) {
                if (!fname.equals(name)) continue;
                continue block0;
            }
            break;
        }
        return base + i;
    }

    private void adjustPreferredSize() {
        Component[] components = this.getComponents();
        Rectangle r = new Rectangle(0, 0, 400, 400);
        for (int i = 0; i < components.length; ++i) {
            r = r.union(components[i].getBounds());
        }
        this.setPreferredSize(new Dimension(r.width, r.height));
    }

    private void promptDeleteSelectedObjects() {
        JLabel message = new JLabel("Really deleted selected objects?");
        int ret = JOptionPane.showConfirmDialog(JOptionUtils.centeringComp(), message, "Confirm Deletion", 2);
        if (ret == 0) {
            this.deleteSelectedObjects();
        }
    }

    private void deleteSelectedObjects() {
        Component[] components = this.getComponents();
        for (int i = components.length - 1; i >= 0; --i) {
            Component comp = components[i];
            if (comp instanceof IDisplayEdge) {
                if (!((IDisplayEdge)((Object)comp)).isSelected()) continue;
                DisplayNode node1 = ((IDisplayEdge)((Object)comp)).getNode1();
                String src = node1.getName();
                DisplayNode node2 = ((IDisplayEdge)((Object)comp)).getNode2();
                String dst = node2.getName();
                int lag = ((LabeledGraphEdge)comp).getWeight();
                this.removeModelEdge(src, dst, lag);
                continue;
            }
            if (!(comp instanceof DisplayNode) || !((DisplayNode)comp).isSelected()) continue;
            this.removeModelNode(comp.getName());
        }
        this.repaint();
    }

    private void deselectAll() {
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component comp = components[i];
            if (comp instanceof IDisplayEdge) {
                ((IDisplayEdge)((Object)comp)).setSelected(false);
                continue;
            }
            if (!(comp instanceof DisplayNode)) continue;
            ((DisplayNode)comp).setSelected(false);
        }
        this.repaint();
    }

    private static double distance(Point p1, Point p2) {
        double d = (p1.x - p2.x) * (p1.x - p2.x);
        d += (double)((p1.y - p2.y) * (p1.y - p2.y));
        d = Math.sqrt(d);
        return d;
    }

    private DisplayNode findNearestNode(Point p) {
        Component[] components = this.getComponents();
        double leastDistance = Double.POSITIVE_INFINITY;
        int index = -1;
        for (int i = 0; i < components.length; ++i) {
            DisplayNode node;
            double distance;
            if (!(components[i] instanceof DisplayNode) || !((distance = DirectedGraphWorkbench.distance(p, (node = (DisplayNode)components[i]).getCenterPoint())) < leastDistance)) continue;
            leastDistance = distance;
            index = i;
        }
        if (index != -1) {
            return (DisplayNode)components[index];
        }
        return null;
    }

    private void finishRubberband() {
        if (this.rubberband != null) {
            this.remove(this.rubberband);
            this.rubberband = null;
            this.repaint();
        }
    }

    private void fireNodeSelection() {
        ArrayList selection = new ArrayList();
        if (this.allowMultipleNodeSelection) {
            this.firePropertyChange("selectedNodes", null, selection);
        } else if (selection.size() == 1) {
            this.firePropertyChange("selectedNode", null, selection.get(0));
        } else {
            throw new IllegalStateException("Multiple or null selection detected when single selection mode is set.");
        }
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public ActiveLagGraph getModelGraph() {
        return this.modelGraph;
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(this.BACKGROUND);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        super.paint(g);
    }

    private void registerKeys() {
        AbstractAction deleteAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirectedGraphWorkbench.this.deleteSelectedObjects();
            }
        };
        KeyStroke backspace = KeyStroke.getKeyStroke(8, 0);
        KeyStroke delete = KeyStroke.getKeyStroke(127, 0);
        this.getInputMap(2).put(backspace, "DELETE");
        this.getInputMap(2).put(delete, "DELETE");
        this.getActionMap().put("DELETE", deleteAction);
    }

    private void selectAllInRubberband(Rubberband rubberband) {
        Shape rubberShape = rubberband.getShape();
        Point rubberLoc = rubberband.getLocation();
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component comp = components[i];
            Rectangle bounds = comp.getBounds();
            bounds.translate(-rubberLoc.x, -rubberLoc.y);
            if (rubberShape.intersects(bounds)) {
                if (!(comp instanceof DisplayNode)) continue;
                ((DisplayNode)comp).setSelected(true);
                continue;
            }
            if (comp instanceof IDisplayEdge) {
                ((IDisplayEdge)((Object)comp)).setSelected(false);
                continue;
            }
            if (!(comp instanceof DisplayNode)) continue;
            ((DisplayNode)comp).setSelected(false);
        }
    }

    @Override
    public void setModelGraph(ActiveLagGraph modelGraph) {
        if (modelGraph == null) {
            throw new NullPointerException();
        }
        this.unregisterKeys();
        this.removeCurrentListeners();
        this.modelGraph = modelGraph;
        this.modelToDisplay = new HashMap();
        if (!this.nodesArrangedAlready()) {
            this.arrangeNodesInCircle();
        }
        SortedSet<String> factors = this.getModelGraph().getFactors();
        for (String factor : factors) {
            PointXy point = this.getModelGraph().getLocation(factor);
            this.addDisplayNode(new Point(point.getX(), point.getY()), factor);
        }
        this.adjustPreferredSize();
        this.getModelGraph().addPropertyChangeListener(this.propChangeHandler);
        this.registerKeys();
    }

    private boolean nodesArrangedAlready() {
        SortedSet<String> factors = this.getModelGraph().getFactors();
        for (String factor : factors) {
            if (this.getModelGraph().getLocation(factor) != null) continue;
            return false;
        }
        return true;
    }

    private void arrangeNodesInCircle() {
        SortedSet<String> factors = this.getModelGraph().getFactors();
        double radius = 150 + 20 * (factors.size() - 5);
        int offset = (int)radius + 80;
        double dr = Math.PI * 2 / (double)factors.size();
        double a = 0.0;
        for (String factor : factors) {
            int x = (int)(radius * Math.sin(a));
            int y = -((int)(radius * Math.cos(a)));
            a += dr;
            int offsetX = offset + x;
            int offsetY = offset + y;
            PointXy point = new PointXy(offsetX, offsetY);
            this.getModelGraph().setLocation(factor, point);
        }
    }

    private void removeCurrentListeners() {
        if (this.getModelGraph() != null) {
            this.getModelGraph().removePropertyChangeListener(this.propChangeHandler);
        }
    }

    public void setWorkbenchMode(int workbenchMode) {
        switch (workbenchMode) {
            case 0: 
            case 1: 
            case 2: {
                if (this.workbenchMode == workbenchMode) break;
                this.workbenchMode = workbenchMode;
                this.deselectAll();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void startNodeDrag(Point p) {
        this.clickPoint = p;
    }

    private void startRubberband(Point p) {
        if (this.rubberband != null) {
            this.remove(this.rubberband);
            this.rubberband = null;
            this.repaint();
        }
        if (this.allowRubberband) {
            this.rubberband = new Rubberband(p);
            this.add((Component)this.rubberband, 0);
            this.rubberband.repaint();
        }
    }

    private void unregisterKeys() {
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(8, 0));
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(127, 0));
    }

    public void cleanup() {
        this.arrangeNodesInCircle();
        SortedSet<String> factors = this.getModelGraph().getFactors();
        for (String factor : factors) {
            DisplayNode displayNode = (DisplayNode)this.modelToDisplay.get(factor);
            Dimension dim = displayNode.getPreferredSize();
            PointXy _point = this.getModelGraph().getLocation(factor);
            Point point = new Point(_point.getX() - dim.width / 2, _point.getY() - dim.height / 2);
            displayNode.setLocation(point);
        }
    }

    final class PopupListener
    implements ActionListener {
        PopupListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPopupMenu parent;
            JMenuItem source = (JMenuItem)e.getSource();
            if (source.getText().equals(DirectedGraphWorkbench.POPUP_DELETE)) {
                DirectedGraphWorkbench.this.promptDeleteSelectedObjects();
            } else if (source.getText().equals(DirectedGraphWorkbench.POPUP_RENAME)) {
                JPopupMenu parent2 = (JPopupMenu)source.getParent();
                if (parent2 == DirectedGraphWorkbench.this.nodePopup) {
                    ((DisplayNode)parent2.getInvoker()).doDoubleClickAction();
                }
            } else if (source.getText().equals(DirectedGraphWorkbench.POPUP_EDIT) && (parent = (JPopupMenu)source.getParent()) == DirectedGraphWorkbench.this.edgePopup) {
                ((LabeledGraphEdge)parent.getInvoker()).launchAssociatedEditor();
            }
        }
    }

    final class PropertyChangeHandler
    implements PropertyChangeListener {
        PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propName = e.getPropertyName();
            Object old = e.getOldValue();
            Object _new = e.getNewValue();
            if (propName.equals("nodeAdded")) {
                Point loc = DirectedGraphWorkbench.this.lastMouseLoc;
                if (!DirectedGraphWorkbench.this.lastClickWasAdd) {
                    loc = new Point((int)(Math.random() * (double)(DirectedGraphWorkbench.this.getWidth() - 100)) + 50, (int)(Math.random() * (double)(DirectedGraphWorkbench.this.getHeight() - 100)) + 50);
                }
                DirectedGraphWorkbench.this.addDisplayNode(loc, (String)_new);
                DirectedGraphWorkbench.this.lastClickWasAdd = false;
            } else if (propName.equals("nodeRemoved")) {
                DirectedGraphWorkbench.this.removeDisplayNode((String)old);
            } else if (propName.equals("edgeAdded")) {
                LaggedEdge le = (LaggedEdge)_new;
                LaggedFactor lf = le.getLaggedFactor();
                String src = lf.getFactor();
                String dst = le.getFactor();
                int lag = lf.getLag();
                DirectedGraphWorkbench.this.addDisplayEdge(src, dst, lag);
            } else if (propName.equals("edgeRemoved")) {
                LaggedEdge le = (LaggedEdge)old;
                LaggedFactor lf = le.getLaggedFactor();
                String src = lf.getFactor();
                String dst = le.getFactor();
                int lag = lf.getLag();
                DirectedGraphWorkbench.this.removeDisplayEdge(src, dst, lag);
            } else if (propName.equals("edgeLaunch")) {
                String s1 = ((DisplayEdge)_new).getComp1().getName();
                String s2 = ((DisplayEdge)_new).getComp2().getName();
                int lag = Integer.parseInt((String)old);
                SortedSet laggedFactors = DirectedGraphWorkbench.this.modelGraph.getParents(s2);
                for (LaggedFactor f : laggedFactors) {
                    if (!f.getFactor().equals(s1) || f.getLag() != lag) continue;
                    DirectedGraphWorkbench.this.modelGraph.removeEdge(s2, f);
                    DirectedGraphWorkbench.this.modelGraph.addEdge(s2, new LaggedFactor(f.getFactor(), ((LabeledGraphEdge)_new).getWeight()));
                    break;
                }
            } else if (propName.equals("factorRenamed")) {
                String oldname = (String)old;
                String newname = (String)_new;
                DisplayNode oldnode = (DisplayNode)DirectedGraphWorkbench.this.modelToDisplay.get(oldname);
                DirectedGraphWorkbench.this.removeDisplayNode(oldname);
                DirectedGraphWorkbench.this.addDisplayNode(oldnode.getCenterPoint(), newname);
            }
        }
    }

    final class MouseHandler
    implements MouseListener,
    MouseMotionListener {
        MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Object source = e.getSource();
            switch (DirectedGraphWorkbench.this.workbenchMode) {
                case 0: 
                case 1: 
                case 2: {
                    if (source instanceof DisplayNode) {
                        DisplayNode node = (DisplayNode)source;
                        if (e.getClickCount() == 2) {
                            DirectedGraphWorkbench.this.deselectAll();
                            node.doDoubleClickAction();
                            break;
                        }
                        if (!e.isShiftDown() || !DirectedGraphWorkbench.this.allowMultipleNodeSelection) {
                            DirectedGraphWorkbench.this.deselectAll();
                        }
                        node.setSelected(true);
                        DirectedGraphWorkbench.this.fireNodeSelection();
                        break;
                    }
                    DirectedGraphWorkbench.this.deselectAll();
                    if (!(source instanceof IDisplayEdge)) break;
                    IDisplayEdge edge = (IDisplayEdge)source;
                    if (e.getClickCount() == 2) {
                        DirectedGraphWorkbench.this.deselectAll();
                        edge.launchAssociatedEditor();
                        DirectedGraphWorkbench.this.firePropertyChange("edgeLaunch", edge, edge);
                        break;
                    }
                    if (edge.isSelected()) {
                        edge.setSelected(false);
                        break;
                    }
                    if (e.isShiftDown()) {
                        edge.setSelected(true);
                        break;
                    }
                    DirectedGraphWorkbench.this.deselectAll();
                    edge.setSelected(true);
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            DirectedGraphWorkbench.this.lastMouseLoc = e.getPoint();
            Object source = e.getSource();
            if (!DirectedGraphWorkbench.this.allowUserEditing) {
                return;
            }
            if (this.maybeShowPopup(e)) {
                return;
            }
            Point loc = e.getPoint();
            switch (DirectedGraphWorkbench.this.workbenchMode) {
                case 0: {
                    if (source == DirectedGraphWorkbench.this) {
                        DirectedGraphWorkbench.this.startRubberband(loc);
                        break;
                    }
                    if (!(source instanceof DisplayNode)) break;
                    DirectedGraphWorkbench.this.startNodeDrag(loc);
                    break;
                }
                case 1: {
                    if (source != DirectedGraphWorkbench.this) break;
                    DirectedGraphWorkbench.this.lastClickWasAdd = true;
                    DirectedGraphWorkbench.this.addModelNode(DirectedGraphWorkbench.this.nextVariableName(DirectedGraphWorkbench.BASE_FACTOR_NAME));
                    break;
                }
                case 2: {
                    DisplayNode nearestNode;
                    if (source instanceof DisplayNode) {
                        Point o = ((Component)source).getLocation();
                        loc.translate(o.x, o.y);
                    }
                    if ((nearestNode = DirectedGraphWorkbench.this.findNearestNode(loc)) == null) break;
                    DirectedGraphWorkbench.this.startEdge(nearestNode, loc);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            Object source = e.getSource();
            if (!DirectedGraphWorkbench.this.allowUserEditing) {
                return;
            }
            if (this.maybeShowPopup(e)) {
                return;
            }
            switch (DirectedGraphWorkbench.this.workbenchMode) {
                case 0: {
                    if (source != DirectedGraphWorkbench.this) break;
                    DirectedGraphWorkbench.this.finishRubberband();
                    break;
                }
                case 2: {
                    DirectedGraphWorkbench.this.finishEdge();
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!DirectedGraphWorkbench.this.allowUserEditing) {
                return;
            }
            Object source = e.getSource();
            Point newPoint = e.getPoint();
            switch (DirectedGraphWorkbench.this.workbenchMode) {
                case 0: {
                    if (source instanceof DisplayNode && DirectedGraphWorkbench.this.clickPoint != null) {
                        DisplayNode node = (DisplayNode)source;
                        Point point = new Point(node.getLocation());
                        point.x += newPoint.x - ((DirectedGraphWorkbench)DirectedGraphWorkbench.this).clickPoint.x;
                        point.y += newPoint.y - ((DirectedGraphWorkbench)DirectedGraphWorkbench.this).clickPoint.y;
                        if (point.x < 0) {
                            point.x = 0;
                        }
                        if (point.y < 0) {
                            point.y = 0;
                        }
                        node.setLocation(point);
                        this.setLocationInModel(point, node);
                        break;
                    }
                    if (DirectedGraphWorkbench.this.rubberband == null) break;
                    DirectedGraphWorkbench.this.rubberband.updateTrackPoint(newPoint);
                    DirectedGraphWorkbench.this.selectAllInRubberband(DirectedGraphWorkbench.this.rubberband);
                    break;
                }
                case 2: {
                    if (source instanceof DisplayNode) {
                        Point o = ((Component)source).getLocation();
                        newPoint.translate(o.x, o.y);
                    }
                    if (DirectedGraphWorkbench.this.trackedEdge == null) break;
                    DirectedGraphWorkbench.this.trackedEdge.updateTrackPoint(newPoint);
                    DirectedGraphWorkbench.this.remove(DirectedGraphWorkbench.this.ghostEdge);
                    Rectangle r = DirectedGraphWorkbench.this.ghostEdge.getBounds();
                    DirectedGraphWorkbench.this.ghostEdge = new LabeledGraphEdge(DirectedGraphWorkbench.this.trackedEdge.getComp1(), DirectedGraphWorkbench.this.findNearestNode(newPoint), null);
                    DirectedGraphWorkbench.this.ghostEdge.setAlpha(100);
                    DirectedGraphWorkbench.this.add((Component)DirectedGraphWorkbench.this.ghostEdge, -1);
                    r.union(DirectedGraphWorkbench.this.ghostEdge.getBounds());
                    DirectedGraphWorkbench.this.repaint(r.x, r.y, r.width, r.height);
                }
            }
        }

        private void setLocationInModel(Point point, DisplayNode node) {
            ActiveLagGraph graph = DirectedGraphWorkbench.this.getModelGraph();
            PointXy _point = new PointXy(point.x, point.y);
            graph.setLocation(node.getName(), _point);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        private boolean maybeShowPopup(MouseEvent e) {
            Object source = e.getSource();
            if (e.isPopupTrigger()) {
                if (source instanceof DisplayNode) {
                    if (!((DisplayNode)source).isSelected()) {
                        if (!e.isShiftDown() || !DirectedGraphWorkbench.this.allowMultipleNodeSelection) {
                            DirectedGraphWorkbench.this.deselectAll();
                        }
                        ((DisplayNode)source).setSelected(true);
                    }
                    DirectedGraphWorkbench.this.nodePopup.show(e.getComponent(), e.getX(), e.getY());
                    return true;
                }
                if (source instanceof LabeledGraphEdge) {
                    if (!((IDisplayEdge)source).isSelected()) {
                        if (!e.isShiftDown() || !DirectedGraphWorkbench.this.allowMultipleNodeSelection) {
                            DirectedGraphWorkbench.this.deselectAll();
                        }
                        ((IDisplayEdge)source).setSelected(true);
                    }
                    DirectedGraphWorkbench.this.edgePopup.show(e.getComponent(), e.getX(), e.getY());
                    return true;
                }
            }
            return false;
        }
    }

    final class ComponentHandler
    extends ComponentAdapter {
        ComponentHandler() {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            Component source = (Component)e.getSource();
            Rectangle bounds = source.getBounds();
            DirectedGraphWorkbench.this.adjustPreferredSize();
            DirectedGraphWorkbench.this.scrollRectToVisible(bounds);
        }
    }
}

