/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.gene.editor;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.TimeSeriesData;
import edu.cmu.tetradapp.editor.DataDisplay;
import edu.cmu.tetradapp.editor.TimeSeriesDataDisplay;
import edu.cmu.tetradapp.gene.editor.GeneDataEditorMenuBar;
import edu.cmu.tetradapp.model.GeneSimDataWrapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GeneDataEditor
extends JPanel
implements PropertyChangeListener {
    private GeneSimDataWrapper dataWrapper;
    private JTabbedPane tabbedPane;
    private Map<Component, Object> compsToDataModels = new HashMap<Component, Object>();

    public GeneDataEditor() {
    }

    public GeneDataEditor(GeneSimDataWrapper dataWrapper) {
        if (dataWrapper == null) {
            throw new NullPointerException("Data wrapper must not be null.");
        }
        this.dataWrapper = dataWrapper;
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(600, 400));
        this.setName(this.getTitle());
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GeneDataEditor.this.getDataModelList().setSelectedModel(GeneDataEditor.this.getSelectedDataSet());
            }
        });
        this.reset();
    }

    public GeneSimDataWrapper getDataWrapper() {
        return this.dataWrapper;
    }

    public final void reset() {
        this.constructTabbedPane();
        this.constructEditor();
    }

    private void constructTabbedPane() {
        this.clearTabbedPane();
        for (int index = 0; index < this.getDataModelList().size(); ++index) {
            JPanel dataDisplay;
            DataModel dataModel = this.getDataModelList().get(index);
            if (dataModel instanceof DataSet) {
                DataSet dataSet = (DataSet)dataModel;
                dataDisplay = new DataDisplay(dataSet);
                this.constructTab(dataModel, index, dataDisplay);
                continue;
            }
            if (!(dataModel instanceof TimeSeriesData)) continue;
            TimeSeriesData timeSeriesData = (TimeSeriesData)dataModel;
            dataDisplay = new TimeSeriesDataDisplay(timeSeriesData);
            this.constructTab(dataModel, index, dataDisplay);
        }
    }

    private void constructEditor() {
        this.removeAll();
        this.add((Component)this.tabbedPane, "Center");
        this.add((Component)this.getMenuBar(), "North");
        this.validate();
    }

    private void clearTabbedPane() {
        this.tabbedPane.removeAll();
    }

    private JMenuBar getMenuBar() {
        return new GeneDataEditorMenuBar(this);
    }

    private void constructTab(Object dataModel, int i, JComponent dataDisplay) {
        String tabName = ((DataModel)dataModel).getName();
        tabName = tabName == null ? "Data Set " + i : tabName;
        JScrollPane component = new JScrollPane(dataDisplay);
        this.compsToDataModels.put(component, dataModel);
        this.tabbedPane.addTab(tabName, component);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("closeFrame".equals(e.getPropertyName())) {
            this.firePropertyChange("closeFrame", null, null);
        } else if ("dataModel".equals(e.getPropertyName())) {
            this.firePropertyChange("dataModel", e.getOldValue(), e.getNewValue());
        }
    }

    @Override
    public void setName(String name) {
        String oldName = this.getName();
        super.setName(name);
        this.firePropertyChange("name", oldName, this.getName());
    }

    private String getTitle() {
        return "Gene Data Editor";
    }

    public Component getSelectedDisplay() {
        return this.tabbedPane.getSelectedComponent();
    }

    public DataModel getSelectedDataSet() {
        Component comp = this.tabbedPane.getSelectedComponent();
        return (DataModel)this.compsToDataModels.get(comp);
    }

    private DataModelList getDataModelList() {
        DataModelList dataModel = this.dataWrapper.getDataModelList();
        if (dataModel instanceof DataModelList) {
            return dataModel;
        }
        DataModelList dataModelList = new DataModelList();
        dataModelList.add(dataModel);
        return dataModelList;
    }
}

